%------------------------------------------------------------------------------
% File     : ITP018^5 : TPTP v9.2.0. Bugfixed v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : HOL4 set theory export of thm_2Ebinary__ieee_2Eneg__ulp.p, chainy mode
% Version  : [BG+19] axioms.
% English  :

% Refs     : [BG+19] Brown et al. (2019), GRUNGE: A Grand Unified ATP Chall
%          : [Gau20] Gauthier (2020), Email to Geoff Sutcliffe
% Source   : [BG+19]
% Names    : thm_2Ebinary__ieee_2Eneg__ulp.p [Gau20]
%          : HL408501^5.p [TPAP]

% Status   : Theorem
% Rating   : 1.00 v8.1.0, 0.91 v7.5.0
% Syntax   : Number of formulae    : 16457 (1927 unt;2664 typ;   0 def)
%            Number of atoms       : 404544 (15377 equ;   0 cnn)
%            Maximal formula atoms : 9722 (  29 avg)
%            Number of connectives : 699203 (1906   ~; 871   |;24180   &;637548   @)
%                                         (5504 <=>;29194  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  368 (  12 avg)
%            Number of types       :  117 ( 115 usr)
%            Number of type conns  : 2625 (2625   >;   0   *;   0   +;   0  <<)
%            Number of symbols     : 2655 (2652 usr; 817 con; 0-5 aty)
%            Number of variables   : 64599 (4104   ^;46784   !;13711   ?;64599   :)
% SPC      : TH0_THM_EQU_NAR

% Comments :
% Bugfixes : v7.5.0 - Bugfixes in axioms and export.
%------------------------------------------------------------------------------
include('Axioms/ITP001/ITP001^2.ax').
include('Axioms/ITP001/ITP002^5.ax').
include('Axioms/ITP001/ITP003^5.ax').
include('Axioms/ITP001/ITP004^5.ax').
include('Axioms/ITP001/ITP007^5.ax').
include('Axioms/ITP001/ITP006^5.ax').
include('Axioms/ITP001/ITP005^5.ax').
include('Axioms/ITP001/ITP008^5.ax').
include('Axioms/ITP001/ITP009^5.ax').
include('Axioms/ITP001/ITP010^5.ax').
include('Axioms/ITP001/ITP012^5.ax').
include('Axioms/ITP001/ITP011^5.ax').
include('Axioms/ITP001/ITP013^5.ax').
include('Axioms/ITP001/ITP014^5.ax').
include('Axioms/ITP001/ITP015^5.ax').
include('Axioms/ITP001/ITP017^5.ax').
include('Axioms/ITP001/ITP016^5.ax').
include('Axioms/ITP001/ITP019^5.ax').
include('Axioms/ITP001/ITP018^5.ax').
include('Axioms/ITP001/ITP021^5.ax').
include('Axioms/ITP001/ITP022^5.ax').
include('Axioms/ITP001/ITP020^5.ax').
include('Axioms/ITP001/ITP024^5.ax').
include('Axioms/ITP001/ITP023^5.ax').
include('Axioms/ITP001/ITP025^5.ax').
include('Axioms/ITP001/ITP026^5.ax').
include('Axioms/ITP001/ITP027^5.ax').
include('Axioms/ITP001/ITP028^5.ax').
include('Axioms/ITP001/ITP031^5.ax').
include('Axioms/ITP001/ITP029^5.ax').
include('Axioms/ITP001/ITP033^5.ax').
include('Axioms/ITP001/ITP030^5.ax').
include('Axioms/ITP001/ITP032^5.ax').
include('Axioms/ITP001/ITP038^5.ax').
include('Axioms/ITP001/ITP035^5.ax').
include('Axioms/ITP001/ITP034^5.ax').
include('Axioms/ITP001/ITP036^5.ax').
include('Axioms/ITP001/ITP037^5.ax').
include('Axioms/ITP001/ITP039^5.ax').
include('Axioms/ITP001/ITP041^5.ax').
include('Axioms/ITP001/ITP042^5.ax').
include('Axioms/ITP001/ITP040^5.ax').
include('Axioms/ITP001/ITP044^5.ax').
include('Axioms/ITP001/ITP051^5.ax').
include('Axioms/ITP001/ITP045^5.ax').
include('Axioms/ITP001/ITP056^5.ax').
include('Axioms/ITP001/ITP046^5.ax').
include('Axioms/ITP001/ITP043^5.ax').
include('Axioms/ITP001/ITP052^5.ax').
include('Axioms/ITP001/ITP057^5.ax').
include('Axioms/ITP001/ITP048^5.ax').
include('Axioms/ITP001/ITP047^5.ax').
include('Axioms/ITP001/ITP055^5.ax').
include('Axioms/ITP001/ITP053^5.ax').
include('Axioms/ITP001/ITP054^5.ax').
include('Axioms/ITP001/ITP058^5.ax').
include('Axioms/ITP001/ITP049^5.ax').
include('Axioms/ITP001/ITP050^5.ax').
include('Axioms/ITP001/ITP061^5.ax').
include('Axioms/ITP001/ITP069^5.ax').
include('Axioms/ITP001/ITP062^5.ax').
include('Axioms/ITP001/ITP068^5.ax').
include('Axioms/ITP001/ITP078^5.ax').
include('Axioms/ITP001/ITP064^5.ax').
include('Axioms/ITP001/ITP060^5.ax').
include('Axioms/ITP001/ITP067^5.ax').
include('Axioms/ITP001/ITP075^5.ax').
include('Axioms/ITP001/ITP074^5.ax').
include('Axioms/ITP001/ITP063^5.ax').
include('Axioms/ITP001/ITP059^5.ax').
include('Axioms/ITP001/ITP065^5.ax').
include('Axioms/ITP001/ITP076^5.ax').
include('Axioms/ITP001/ITP066^5.ax').
include('Axioms/ITP001/ITP077^5.ax').
include('Axioms/ITP001/ITP070^5.ax').
include('Axioms/ITP001/ITP071^5.ax').
include('Axioms/ITP001/ITP072^5.ax').
include('Axioms/ITP001/ITP073^5.ax').
include('Axioms/ITP001/ITP080^5.ax').
include('Axioms/ITP001/ITP083^5.ax').
include('Axioms/ITP001/ITP088^5.ax').
include('Axioms/ITP001/ITP082^5.ax').
include('Axioms/ITP001/ITP081^5.ax').
include('Axioms/ITP001/ITP079^5.ax').
include('Axioms/ITP001/ITP087^5.ax').
include('Axioms/ITP001/ITP085^5.ax').
include('Axioms/ITP001/ITP086^5.ax').
include('Axioms/ITP001/ITP090^5.ax').
include('Axioms/ITP001/ITP089^5.ax').
include('Axioms/ITP001/ITP084^5.ax').
include('Axioms/ITP001/ITP104^5.ax').
include('Axioms/ITP001/ITP097^5.ax').
include('Axioms/ITP001/ITP094^5.ax').
include('Axioms/ITP001/ITP095^5.ax').
include('Axioms/ITP001/ITP093^5.ax').
include('Axioms/ITP001/ITP102^5.ax').
include('Axioms/ITP001/ITP091^5.ax').
include('Axioms/ITP001/ITP098^5.ax').
include('Axioms/ITP001/ITP096^5.ax').
include('Axioms/ITP001/ITP100^5.ax').
include('Axioms/ITP001/ITP092^5.ax').
include('Axioms/ITP001/ITP105^5.ax').
include('Axioms/ITP001/ITP101^5.ax').
include('Axioms/ITP001/ITP103^5.ax').
include('Axioms/ITP001/ITP099^5.ax').
include('Axioms/ITP001/ITP111^5.ax').
include('Axioms/ITP001/ITP108^5.ax').
include('Axioms/ITP001/ITP106^5.ax').
include('Axioms/ITP001/ITP107^5.ax').
include('Axioms/ITP001/ITP114^5.ax').
include('Axioms/ITP001/ITP110^5.ax').
include('Axioms/ITP001/ITP109^5.ax').
include('Axioms/ITP001/ITP112^5.ax').
include('Axioms/ITP001/ITP113^5.ax').
include('Axioms/ITP001/ITP117^5.ax').
include('Axioms/ITP001/ITP116^5.ax').
include('Axioms/ITP001/ITP118^5.ax').
include('Axioms/ITP001/ITP120^5.ax').
include('Axioms/ITP001/ITP119^5.ax').
include('Axioms/ITP001/ITP121^5.ax').
include('Axioms/ITP001/ITP123^5.ax').
include('Axioms/ITP001/ITP124^5.ax').
include('Axioms/ITP001/ITP126^5.ax').
include('Axioms/ITP001/ITP127^5.ax').
include('Axioms/ITP001/ITP129^5.ax').
include('Axioms/ITP001/ITP128^5.ax').
include('Axioms/ITP001/ITP130^5.ax').
include('Axioms/ITP001/ITP131^5.ax').
include('Axioms/ITP001/ITP132^5.ax').
%------------------------------------------------------------------------------
thf(tp_ty_2Ebinary__ieee_2Eflags,type,
    ty_2Ebinary__ieee_2Eflags: del ).

thf(tp_ty_2Ebinary__ieee_2Efloat,type,
    ty_2Ebinary__ieee_2Efloat: del > del > del ).

thf(tp_ty_2Ebinary__ieee_2Efloat__compare,type,
    ty_2Ebinary__ieee_2Efloat__compare: del ).

thf(tp_ty_2Ebinary__ieee_2Efloat__value,type,
    ty_2Ebinary__ieee_2Efloat__value: del ).

thf(tp_ty_2Ebinary__ieee_2Efp__op,type,
    ty_2Ebinary__ieee_2Efp__op: del > del > del ).

thf(tp_ty_2Ebinary__ieee_2Erounding,type,
    ty_2Ebinary__ieee_2Erounding: del ).

thf(stp_ty_2Ebinary__ieee_2Efloat__compare,type,
    tp__ty_2Ebinary__ieee_2Efloat__compare: $tType ).

thf(stp_inj_ty_2Ebinary__ieee_2Efloat__compare,type,
    inj__ty_2Ebinary__ieee_2Efloat__compare: tp__ty_2Ebinary__ieee_2Efloat__compare > $i ).

thf(stp_surj_ty_2Ebinary__ieee_2Efloat__compare,type,
    surj__ty_2Ebinary__ieee_2Efloat__compare: $i > tp__ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_inj_surj_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ X ) )
      = X ) ).

thf(stp_inj_mem_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( mem @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ X ) @ ty_2Ebinary__ieee_2Efloat__compare ) ).

thf(stp_iso_mem_ty_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ty_2Ebinary__ieee_2Efloat__compare )
     => ( X
        = ( inj__ty_2Ebinary__ieee_2Efloat__compare @ ( surj__ty_2Ebinary__ieee_2Efloat__compare @ X ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EEQ,type,
    c_2Ebinary__ieee_2EEQ: $i ).

thf(mem_c_2Ebinary__ieee_2EEQ,axiom,
    mem @ c_2Ebinary__ieee_2EEQ @ ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_fo_c_2Ebinary__ieee_2EEQ,type,
    fo__c_2Ebinary__ieee_2EEQ: tp__ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EEQ,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ )
    = c_2Ebinary__ieee_2EEQ ) ).

thf(stp_ty_2Ebinary__ieee_2Erounding,type,
    tp__ty_2Ebinary__ieee_2Erounding: $tType ).

thf(stp_inj_ty_2Ebinary__ieee_2Erounding,type,
    inj__ty_2Ebinary__ieee_2Erounding: tp__ty_2Ebinary__ieee_2Erounding > $i ).

thf(stp_surj_ty_2Ebinary__ieee_2Erounding,type,
    surj__ty_2Ebinary__ieee_2Erounding: $i > tp__ty_2Ebinary__ieee_2Erounding ).

thf(stp_inj_surj_ty_2Ebinary__ieee_2Erounding,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( inj__ty_2Ebinary__ieee_2Erounding @ X ) )
      = X ) ).

thf(stp_inj_mem_ty_2Ebinary__ieee_2Erounding,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Erounding] : ( mem @ ( inj__ty_2Ebinary__ieee_2Erounding @ X ) @ ty_2Ebinary__ieee_2Erounding ) ).

thf(stp_iso_mem_ty_2Ebinary__ieee_2Erounding,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ty_2Ebinary__ieee_2Erounding )
     => ( X
        = ( inj__ty_2Ebinary__ieee_2Erounding @ ( surj__ty_2Ebinary__ieee_2Erounding @ X ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__Add,type,
    c_2Ebinary__ieee_2EFP__Add: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__Add,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__Div,type,
    c_2Ebinary__ieee_2EFP__Div: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__Div,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__Mul,type,
    c_2Ebinary__ieee_2EFP__Mul: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__Mul,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__MulAdd,type,
    c_2Ebinary__ieee_2EFP__MulAdd: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__MulAdd,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__MulSub,type,
    c_2Ebinary__ieee_2EFP__MulSub: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__MulSub,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__Sqrt,type,
    c_2Ebinary__ieee_2EFP__Sqrt: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__Sqrt,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFP__Sub,type,
    c_2Ebinary__ieee_2EFP__Sub: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EFP__Sub,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) ).

thf(stp_ty_2Ebinary__ieee_2Efloat__value,type,
    tp__ty_2Ebinary__ieee_2Efloat__value: $tType ).

thf(stp_inj_ty_2Ebinary__ieee_2Efloat__value,type,
    inj__ty_2Ebinary__ieee_2Efloat__value: tp__ty_2Ebinary__ieee_2Efloat__value > $i ).

thf(stp_surj_ty_2Ebinary__ieee_2Efloat__value,type,
    surj__ty_2Ebinary__ieee_2Efloat__value: $i > tp__ty_2Ebinary__ieee_2Efloat__value ).

thf(stp_inj_surj_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__value] :
      ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ X ) )
      = X ) ).

thf(stp_inj_mem_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Efloat__value] : ( mem @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ X ) @ ty_2Ebinary__ieee_2Efloat__value ) ).

thf(stp_iso_mem_ty_2Ebinary__ieee_2Efloat__value,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ty_2Ebinary__ieee_2Efloat__value )
     => ( X
        = ( inj__ty_2Ebinary__ieee_2Efloat__value @ ( surj__ty_2Ebinary__ieee_2Efloat__value @ X ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EFloat,type,
    c_2Ebinary__ieee_2EFloat: $i ).

thf(mem_c_2Ebinary__ieee_2EFloat,axiom,
    mem @ c_2Ebinary__ieee_2EFloat @ ( arr @ ty_2Erealax_2Ereal @ ty_2Ebinary__ieee_2Efloat__value ) ).

thf(stp_fo_c_2Ebinary__ieee_2EFloat,type,
    fo__c_2Ebinary__ieee_2EFloat: tp__ty_2Erealax_2Ereal > tp__ty_2Ebinary__ieee_2Efloat__value ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EFloat,axiom,
    ! [X0: tp__ty_2Erealax_2Ereal] :
      ( ( inj__ty_2Ebinary__ieee_2Efloat__value @ ( fo__c_2Ebinary__ieee_2EFloat @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EGT,type,
    c_2Ebinary__ieee_2EGT: $i ).

thf(mem_c_2Ebinary__ieee_2EGT,axiom,
    mem @ c_2Ebinary__ieee_2EGT @ ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_fo_c_2Ebinary__ieee_2EGT,type,
    fo__c_2Ebinary__ieee_2EGT: tp__ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EGT,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT )
    = c_2Ebinary__ieee_2EGT ) ).

thf(tp_c_2Ebinary__ieee_2EInfinity,type,
    c_2Ebinary__ieee_2EInfinity: $i ).

thf(mem_c_2Ebinary__ieee_2EInfinity,axiom,
    mem @ c_2Ebinary__ieee_2EInfinity @ ty_2Ebinary__ieee_2Efloat__value ).

thf(stp_fo_c_2Ebinary__ieee_2EInfinity,type,
    fo__c_2Ebinary__ieee_2EInfinity: tp__ty_2Ebinary__ieee_2Efloat__value ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EInfinity,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity )
    = c_2Ebinary__ieee_2EInfinity ) ).

thf(tp_c_2Ebinary__ieee_2ELT,type,
    c_2Ebinary__ieee_2ELT: $i ).

thf(mem_c_2Ebinary__ieee_2ELT,axiom,
    mem @ c_2Ebinary__ieee_2ELT @ ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_fo_c_2Ebinary__ieee_2ELT,type,
    fo__c_2Ebinary__ieee_2ELT: tp__ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_eq_fo_c_2Ebinary__ieee_2ELT,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT )
    = c_2Ebinary__ieee_2ELT ) ).

thf(tp_c_2Ebinary__ieee_2ENaN,type,
    c_2Ebinary__ieee_2ENaN: $i ).

thf(mem_c_2Ebinary__ieee_2ENaN,axiom,
    mem @ c_2Ebinary__ieee_2ENaN @ ty_2Ebinary__ieee_2Efloat__value ).

thf(stp_fo_c_2Ebinary__ieee_2ENaN,type,
    fo__c_2Ebinary__ieee_2ENaN: tp__ty_2Ebinary__ieee_2Efloat__value ).

thf(stp_eq_fo_c_2Ebinary__ieee_2ENaN,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN )
    = c_2Ebinary__ieee_2ENaN ) ).

thf(tp_c_2Ebinary__ieee_2EULP,type,
    c_2Ebinary__ieee_2EULP: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2EULP,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w ) @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ ty_2Erealax_2Ereal ) ) ).

thf(tp_c_2Ebinary__ieee_2EUN,type,
    c_2Ebinary__ieee_2EUN: $i ).

thf(mem_c_2Ebinary__ieee_2EUN,axiom,
    mem @ c_2Ebinary__ieee_2EUN @ ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_fo_c_2Ebinary__ieee_2EUN,type,
    fo__c_2Ebinary__ieee_2EUN: tp__ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EUN,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN )
    = c_2Ebinary__ieee_2EUN ) ).

thf(stp_ty_2Ebinary__ieee_2Eflags,type,
    tp__ty_2Ebinary__ieee_2Eflags: $tType ).

thf(stp_inj_ty_2Ebinary__ieee_2Eflags,type,
    inj__ty_2Ebinary__ieee_2Eflags: tp__ty_2Ebinary__ieee_2Eflags > $i ).

thf(stp_surj_ty_2Ebinary__ieee_2Eflags,type,
    surj__ty_2Ebinary__ieee_2Eflags: $i > tp__ty_2Ebinary__ieee_2Eflags ).

thf(stp_inj_surj_ty_2Ebinary__ieee_2Eflags,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Eflags] :
      ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( inj__ty_2Ebinary__ieee_2Eflags @ X ) )
      = X ) ).

thf(stp_inj_mem_ty_2Ebinary__ieee_2Eflags,axiom,
    ! [X: tp__ty_2Ebinary__ieee_2Eflags] : ( mem @ ( inj__ty_2Ebinary__ieee_2Eflags @ X ) @ ty_2Ebinary__ieee_2Eflags ) ).

thf(stp_iso_mem_ty_2Ebinary__ieee_2Eflags,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ty_2Ebinary__ieee_2Eflags )
     => ( X
        = ( inj__ty_2Ebinary__ieee_2Eflags @ ( surj__ty_2Ebinary__ieee_2Eflags @ X ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Echeck__for__signalling,type,
    c_2Ebinary__ieee_2Echeck__for__signalling: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Echeck__for__signalling,axiom,
    ! [A_27a: del,A_27b: del] : ( mem @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27a @ A_27b ) @ ( arr @ ( ty_2Elist_2Elist @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eclear__flags,type,
    c_2Ebinary__ieee_2Eclear__flags: $i ).

thf(mem_c_2Ebinary__ieee_2Eclear__flags,axiom,
    mem @ c_2Ebinary__ieee_2Eclear__flags @ ty_2Ebinary__ieee_2Eflags ).

thf(stp_fo_c_2Ebinary__ieee_2Eclear__flags,type,
    fo__c_2Ebinary__ieee_2Eclear__flags: tp__ty_2Ebinary__ieee_2Eflags ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Eclear__flags,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags )
    = c_2Ebinary__ieee_2Eclear__flags ) ).

thf(tp_c_2Ebinary__ieee_2Eclosest,type,
    c_2Ebinary__ieee_2Eclosest: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eclosest,axiom,
    ! [A_27a: del,A_27b: del] : ( mem @ ( c_2Ebinary__ieee_2Eclosest @ A_27a @ A_27b ) @ ( arr @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Eclosest__such,type,
    c_2Ebinary__ieee_2Eclosest__such: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eclosest__such,axiom,
    ! [A_27a: del,A_27b: del] : ( mem @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27a @ A_27b ) @ ( arr @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) @ ( arr @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Edividezero__flags,type,
    c_2Ebinary__ieee_2Edividezero__flags: $i ).

thf(mem_c_2Ebinary__ieee_2Edividezero__flags,axiom,
    mem @ c_2Ebinary__ieee_2Edividezero__flags @ ty_2Ebinary__ieee_2Eflags ).

thf(stp_fo_c_2Ebinary__ieee_2Edividezero__flags,type,
    fo__c_2Ebinary__ieee_2Edividezero__flags: tp__ty_2Ebinary__ieee_2Eflags ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Edividezero__flags,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Edividezero__flags )
    = c_2Ebinary__ieee_2Edividezero__flags ) ).

thf(tp_c_2Ebinary__ieee_2Eexponent__boundary,type,
    c_2Ebinary__ieee_2Eexponent__boundary: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eexponent__boundary,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Eexponent__boundary @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__CASE,type,
    c_2Ebinary__ieee_2Eflags__CASE: del > $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__CASE,axiom,
    ! [A_27a: del] : ( mem @ ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ( arr @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ A_27a ) ) ) ) ) ) @ A_27a ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__DivideByZero,type,
    c_2Ebinary__ieee_2Eflags__DivideByZero: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,type,
    c_2Ebinary__ieee_2Eflags__DivideByZero__fupd: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( arr @ ( arr @ bool @ bool ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__InvalidOp,type,
    c_2Ebinary__ieee_2Eflags__InvalidOp: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,type,
    c_2Ebinary__ieee_2Eflags__InvalidOp__fupd: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( arr @ ( arr @ bool @ bool ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Overflow,type,
    c_2Ebinary__ieee_2Eflags__Overflow: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Overflow,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Overflow @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Overflow__fupd,type,
    c_2Ebinary__ieee_2Eflags__Overflow__fupd: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( arr @ ( arr @ bool @ bool ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Precision,type,
    c_2Ebinary__ieee_2Eflags__Precision: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Precision,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Precision @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Precision__fupd,type,
    c_2Ebinary__ieee_2Eflags__Precision__fupd: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( arr @ ( arr @ bool @ bool ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,type,
    c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,type,
    c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( arr @ ( arr @ bool @ bool ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,type,
    c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,type,
    c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( arr @ ( arr @ bool @ bool ) @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) ) ).

thf(tp_c_2Ebinary__ieee_2Eflags__size,type,
    c_2Ebinary__ieee_2Eflags__size: $i ).

thf(mem_c_2Ebinary__ieee_2Eflags__size,axiom,
    mem @ c_2Ebinary__ieee_2Eflags__size @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Ebinary__ieee_2Eflags__size,type,
    fo__c_2Ebinary__ieee_2Eflags__size: tp__ty_2Ebinary__ieee_2Eflags > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Eflags__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Eflags] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Ebinary__ieee_2Eflags__size @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Eflags__size @ ( inj__ty_2Ebinary__ieee_2Eflags @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__CASE,type,
    c_2Ebinary__ieee_2Efloat__CASE: del > del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__CASE,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ A_27a ) ) ) @ A_27a ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__Exponent,type,
    c_2Ebinary__ieee_2Efloat__Exponent: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__Exponent__fupd,type,
    c_2Ebinary__ieee_2Efloat__Exponent__fupd: del > del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t: del,A_27w: del,A_27x: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ ( arr @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__Sign,type,
    c_2Ebinary__ieee_2Efloat__Sign: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__Sign__fupd,type,
    c_2Ebinary__ieee_2Efloat__Sign__fupd: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( arr @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__Significand,type,
    c_2Ebinary__ieee_2Efloat__Significand: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__Significand__fupd,type,
    c_2Ebinary__ieee_2Efloat__Significand__fupd: del > del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( arr @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__abs,type,
    c_2Ebinary__ieee_2Efloat__abs: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__abs,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__abs @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__add,type,
    c_2Ebinary__ieee_2Efloat__add: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__add,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__add @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__bottom,type,
    c_2Ebinary__ieee_2Efloat__bottom: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__bottom,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__compare,type,
    c_2Ebinary__ieee_2Efloat__compare: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__compare,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ty_2Ebinary__ieee_2Efloat__compare ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__compare2num,type,
    c_2Ebinary__ieee_2Efloat__compare2num: $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__compare2num,axiom,
    mem @ c_2Ebinary__ieee_2Efloat__compare2num @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Ebinary__ieee_2Efloat__compare2num,type,
    fo__c_2Ebinary__ieee_2Efloat__compare2num: tp__ty_2Ebinary__ieee_2Efloat__compare > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Efloat__compare2num,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Ebinary__ieee_2Efloat__compare2num @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__compare__CASE,type,
    c_2Ebinary__ieee_2Efloat__compare__CASE: del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ( arr @ A_27a @ ( arr @ A_27a @ ( arr @ A_27a @ ( arr @ A_27a @ A_27a ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__compare__size,type,
    c_2Ebinary__ieee_2Efloat__compare__size: $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__compare__size,axiom,
    mem @ c_2Ebinary__ieee_2Efloat__compare__size @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Ebinary__ieee_2Efloat__compare__size,type,
    fo__c_2Ebinary__ieee_2Efloat__compare__size: tp__ty_2Ebinary__ieee_2Efloat__compare > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Efloat__compare__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Ebinary__ieee_2Efloat__compare__size @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Efloat__compare__size @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__div,type,
    c_2Ebinary__ieee_2Efloat__div: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__div,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__div @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__equal,type,
    c_2Ebinary__ieee_2Efloat__equal: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__equal,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__equal @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__greater__equal,type,
    c_2Ebinary__ieee_2Efloat__greater__equal: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__greater__equal,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__greater__equal @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__greater__than,type,
    c_2Ebinary__ieee_2Efloat__greater__than: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__greater__than,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__greater__than @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__finite,type,
    c_2Ebinary__ieee_2Efloat__is__finite: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__infinite,type,
    c_2Ebinary__ieee_2Efloat__is__infinite: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__infinite,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__integral,type,
    c_2Ebinary__ieee_2Efloat__is__integral: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__integral,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__nan,type,
    c_2Ebinary__ieee_2Efloat__is__nan: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__nan,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__normal,type,
    c_2Ebinary__ieee_2Efloat__is__normal: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__normal,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__signalling,type,
    c_2Ebinary__ieee_2Efloat__is__signalling: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__signalling,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__subnormal,type,
    c_2Ebinary__ieee_2Efloat__is__subnormal: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__subnormal,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__is__zero,type,
    c_2Ebinary__ieee_2Efloat__is__zero: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__less__equal,type,
    c_2Ebinary__ieee_2Efloat__less__equal: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__less__equal,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__less__equal @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__less__than,type,
    c_2Ebinary__ieee_2Efloat__less__than: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__less__than,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__less__than @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__minus__infinity,type,
    c_2Ebinary__ieee_2Efloat__minus__infinity: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__minus__infinity,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__minus__min,type,
    c_2Ebinary__ieee_2Efloat__minus__min: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__minus__min,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__minus__zero,type,
    c_2Ebinary__ieee_2Efloat__minus__zero: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__minus__zero,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__mul,type,
    c_2Ebinary__ieee_2Efloat__mul: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__mul,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__mul @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__mul__add,type,
    c_2Ebinary__ieee_2Efloat__mul__add: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__mul__add,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__mul__add @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__mul__sub,type,
    c_2Ebinary__ieee_2Efloat__mul__sub: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__mul__sub,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__mul__sub @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__negate,type,
    c_2Ebinary__ieee_2Efloat__negate: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__negate,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__plus__infinity,type,
    c_2Ebinary__ieee_2Efloat__plus__infinity: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__plus__infinity,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__plus__min,type,
    c_2Ebinary__ieee_2Efloat__plus__min: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__plus__min,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__plus__zero,type,
    c_2Ebinary__ieee_2Efloat__plus__zero: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__plus__zero,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__round,type,
    c_2Ebinary__ieee_2Efloat__round: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__round,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ bool @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__round__to__integral,type,
    c_2Ebinary__ieee_2Efloat__round__to__integral: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__round__to__integral,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__round__to__integral @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__round__with__flags,type,
    c_2Ebinary__ieee_2Efloat__round__with__flags: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__round__with__flags,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ bool @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__size,type,
    c_2Ebinary__ieee_2Efloat__size: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__size,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ ( arr @ ( arr @ A_27t @ ty_2Enum_2Enum ) @ ( arr @ ( arr @ A_27w @ ty_2Enum_2Enum ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ty_2Enum_2Enum ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__some__qnan,type,
    c_2Ebinary__ieee_2Efloat__some__qnan: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__some__qnan,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__sqrt,type,
    c_2Ebinary__ieee_2Efloat__sqrt: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__sqrt,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__sqrt @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__sub,type,
    c_2Ebinary__ieee_2Efloat__sub: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__sub,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__sub @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(stp_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,type,
    tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint: $tType ).

thf(stp_inj_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,type,
    inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint: tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint > $i ).

thf(stp_surj_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,type,
    surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint: $i > tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint ).

thf(stp_inj_surj_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,axiom,
    ! [X: tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint] :
      ( ( surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint @ ( inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint @ X ) )
      = X ) ).

thf(stp_inj_mem_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,axiom,
    ! [X: tp__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint] : ( mem @ ( inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint @ X ) @ ( ty_2Eoption_2Eoption @ ty_2Einteger_2Eint ) ) ).

thf(stp_iso_mem_c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ( ty_2Eoption_2Eoption @ ty_2Einteger_2Eint ) )
     => ( X
        = ( inj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint @ ( surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint @ X ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__to__int,type,
    c_2Ebinary__ieee_2Efloat__to__int: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__to__int,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__to__int @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Eoption_2Eoption @ ty_2Einteger_2Eint ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__to__real,type,
    c_2Ebinary__ieee_2Efloat__to__real: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__to__real,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ty_2Erealax_2Ereal ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__top,type,
    c_2Ebinary__ieee_2Efloat__top: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__top,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__value,type,
    c_2Ebinary__ieee_2Efloat__value: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__value,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ty_2Ebinary__ieee_2Efloat__value ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__value__CASE,type,
    c_2Ebinary__ieee_2Efloat__value__CASE: del > $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__value__CASE,axiom,
    ! [A_27a: del] : ( mem @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ ( arr @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) @ ( arr @ A_27a @ ( arr @ A_27a @ A_27a ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efloat__value__size,type,
    c_2Ebinary__ieee_2Efloat__value__size: $i ).

thf(mem_c_2Ebinary__ieee_2Efloat__value__size,axiom,
    mem @ c_2Ebinary__ieee_2Efloat__value__size @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Ebinary__ieee_2Efloat__value__size,type,
    fo__c_2Ebinary__ieee_2Efloat__value__size: tp__ty_2Ebinary__ieee_2Efloat__value > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Efloat__value__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Efloat__value] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Ebinary__ieee_2Efloat__value__size @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Efloat__value__size @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efp__op__CASE,type,
    c_2Ebinary__ieee_2Efp__op__CASE: del > del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efp__op__CASE,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) @ A_27a ) ) ) ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Efp__op__size,type,
    c_2Ebinary__ieee_2Efp__op__size: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Efp__op__size,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ ( arr @ ( arr @ A_27t @ ty_2Enum_2Enum ) @ ( arr @ ( arr @ A_27w @ ty_2Enum_2Enum ) @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ ty_2Enum_2Enum ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Eintegral__round,type,
    c_2Ebinary__ieee_2Eintegral__round: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eintegral__round,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Eintegral__round @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Einvalidop__flags,type,
    c_2Ebinary__ieee_2Einvalidop__flags: $i ).

thf(mem_c_2Ebinary__ieee_2Einvalidop__flags,axiom,
    mem @ c_2Ebinary__ieee_2Einvalidop__flags @ ty_2Ebinary__ieee_2Eflags ).

thf(stp_fo_c_2Ebinary__ieee_2Einvalidop__flags,type,
    fo__c_2Ebinary__ieee_2Einvalidop__flags: tp__ty_2Ebinary__ieee_2Eflags ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Einvalidop__flags,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags )
    = c_2Ebinary__ieee_2Einvalidop__flags ) ).

thf(tp_c_2Ebinary__ieee_2Eis__closest,type,
    c_2Ebinary__ieee_2Eis__closest: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eis__closest,axiom,
    ! [A_27a: del,A_27b: del] : ( mem @ ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b ) @ ( arr @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) @ ( arr @ ty_2Erealax_2Ereal @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Eis__integral,type,
    c_2Ebinary__ieee_2Eis__integral: $i ).

thf(mem_c_2Ebinary__ieee_2Eis__integral,axiom,
    mem @ c_2Ebinary__ieee_2Eis__integral @ ( arr @ ty_2Erealax_2Ereal @ bool ) ).

thf(tp_c_2Ebinary__ieee_2Elargest,type,
    c_2Ebinary__ieee_2Elargest: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Elargest,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ty_2Erealax_2Ereal ) ) ).

thf(tp_c_2Ebinary__ieee_2Enum2float__compare,type,
    c_2Ebinary__ieee_2Enum2float__compare: $i ).

thf(mem_c_2Ebinary__ieee_2Enum2float__compare,axiom,
    mem @ c_2Ebinary__ieee_2Enum2float__compare @ ( arr @ ty_2Enum_2Enum @ ty_2Ebinary__ieee_2Efloat__compare ) ).

thf(stp_fo_c_2Ebinary__ieee_2Enum2float__compare,type,
    fo__c_2Ebinary__ieee_2Enum2float__compare: tp__ty_2Enum_2Enum > tp__ty_2Ebinary__ieee_2Efloat__compare ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Enum2float__compare,axiom,
    ! [X0: tp__ty_2Enum_2Enum] :
      ( ( inj__ty_2Ebinary__ieee_2Efloat__compare @ ( fo__c_2Ebinary__ieee_2Enum2float__compare @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Enum2rounding,type,
    c_2Ebinary__ieee_2Enum2rounding: $i ).

thf(mem_c_2Ebinary__ieee_2Enum2rounding,axiom,
    mem @ c_2Ebinary__ieee_2Enum2rounding @ ( arr @ ty_2Enum_2Enum @ ty_2Ebinary__ieee_2Erounding ) ).

thf(stp_fo_c_2Ebinary__ieee_2Enum2rounding,type,
    fo__c_2Ebinary__ieee_2Enum2rounding: tp__ty_2Enum_2Enum > tp__ty_2Ebinary__ieee_2Erounding ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Enum2rounding,axiom,
    ! [X0: tp__ty_2Enum_2Enum] :
      ( ( inj__ty_2Ebinary__ieee_2Erounding @ ( fo__c_2Ebinary__ieee_2Enum2rounding @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Ereal__to__float,type,
    c_2Ebinary__ieee_2Ereal__to__float: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Ereal__to__float,axiom,
    ! [A_27a: del,A_27b: del] : ( mem @ ( c_2Ebinary__ieee_2Ereal__to__float @ A_27a @ A_27b ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Ereal__to__float__with__flags,type,
    c_2Ebinary__ieee_2Ereal__to__float__with__flags: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Ereal__to__float__with__flags,axiom,
    ! [A_27a: del,A_27b: del] : ( mem @ ( c_2Ebinary__ieee_2Ereal__to__float__with__flags @ A_27a @ A_27b ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Erecordtype_2Eflags,type,
    c_2Ebinary__ieee_2Erecordtype_2Eflags: $i ).

thf(mem_c_2Ebinary__ieee_2Erecordtype_2Eflags,axiom,
    mem @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Erecordtype_2Efloat,type,
    c_2Ebinary__ieee_2Erecordtype_2Efloat: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Erecordtype_2Efloat,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Eround,type,
    c_2Ebinary__ieee_2Eround: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eround,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Eround @ A_27t @ A_27w ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2EroundTiesToEven,type,
    c_2Ebinary__ieee_2EroundTiesToEven: $i ).

thf(mem_c_2Ebinary__ieee_2EroundTiesToEven,axiom,
    mem @ c_2Ebinary__ieee_2EroundTiesToEven @ ty_2Ebinary__ieee_2Erounding ).

thf(stp_fo_c_2Ebinary__ieee_2EroundTiesToEven,type,
    fo__c_2Ebinary__ieee_2EroundTiesToEven: tp__ty_2Ebinary__ieee_2Erounding ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EroundTiesToEven,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTiesToEven )
    = c_2Ebinary__ieee_2EroundTiesToEven ) ).

thf(tp_c_2Ebinary__ieee_2EroundTowardNegative,type,
    c_2Ebinary__ieee_2EroundTowardNegative: $i ).

thf(mem_c_2Ebinary__ieee_2EroundTowardNegative,axiom,
    mem @ c_2Ebinary__ieee_2EroundTowardNegative @ ty_2Ebinary__ieee_2Erounding ).

thf(stp_fo_c_2Ebinary__ieee_2EroundTowardNegative,type,
    fo__c_2Ebinary__ieee_2EroundTowardNegative: tp__ty_2Ebinary__ieee_2Erounding ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EroundTowardNegative,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative )
    = c_2Ebinary__ieee_2EroundTowardNegative ) ).

thf(tp_c_2Ebinary__ieee_2EroundTowardPositive,type,
    c_2Ebinary__ieee_2EroundTowardPositive: $i ).

thf(mem_c_2Ebinary__ieee_2EroundTowardPositive,axiom,
    mem @ c_2Ebinary__ieee_2EroundTowardPositive @ ty_2Ebinary__ieee_2Erounding ).

thf(stp_fo_c_2Ebinary__ieee_2EroundTowardPositive,type,
    fo__c_2Ebinary__ieee_2EroundTowardPositive: tp__ty_2Ebinary__ieee_2Erounding ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EroundTowardPositive,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardPositive )
    = c_2Ebinary__ieee_2EroundTowardPositive ) ).

thf(tp_c_2Ebinary__ieee_2EroundTowardZero,type,
    c_2Ebinary__ieee_2EroundTowardZero: $i ).

thf(mem_c_2Ebinary__ieee_2EroundTowardZero,axiom,
    mem @ c_2Ebinary__ieee_2EroundTowardZero @ ty_2Ebinary__ieee_2Erounding ).

thf(stp_fo_c_2Ebinary__ieee_2EroundTowardZero,type,
    fo__c_2Ebinary__ieee_2EroundTowardZero: tp__ty_2Ebinary__ieee_2Erounding ).

thf(stp_eq_fo_c_2Ebinary__ieee_2EroundTowardZero,axiom,
    ( ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardZero )
    = c_2Ebinary__ieee_2EroundTowardZero ) ).

thf(tp_c_2Ebinary__ieee_2Erounding2num,type,
    c_2Ebinary__ieee_2Erounding2num: $i ).

thf(mem_c_2Ebinary__ieee_2Erounding2num,axiom,
    mem @ c_2Ebinary__ieee_2Erounding2num @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Ebinary__ieee_2Erounding2num,type,
    fo__c_2Ebinary__ieee_2Erounding2num: tp__ty_2Ebinary__ieee_2Erounding > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Erounding2num,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Ebinary__ieee_2Erounding2num @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Erounding__CASE,type,
    c_2Ebinary__ieee_2Erounding__CASE: del > $i ).

thf(mem_c_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a: del] : ( mem @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ A_27a @ ( arr @ A_27a @ ( arr @ A_27a @ ( arr @ A_27a @ A_27a ) ) ) ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Erounding__size,type,
    c_2Ebinary__ieee_2Erounding__size: $i ).

thf(mem_c_2Ebinary__ieee_2Erounding__size,axiom,
    mem @ c_2Ebinary__ieee_2Erounding__size @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ty_2Enum_2Enum ) ).

thf(stp_fo_c_2Ebinary__ieee_2Erounding__size,type,
    fo__c_2Ebinary__ieee_2Erounding__size: tp__ty_2Ebinary__ieee_2Erounding > tp__ty_2Enum_2Enum ).

thf(stp_eq_fo_c_2Ebinary__ieee_2Erounding__size,axiom,
    ! [X0: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( inj__ty_2Enum_2Enum @ ( fo__c_2Ebinary__ieee_2Erounding__size @ X0 ) )
      = ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ X0 ) ) ) ).

thf(tp_c_2Ebinary__ieee_2Ethreshold,type,
    c_2Ebinary__ieee_2Ethreshold: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Ethreshold,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ty_2Erealax_2Ereal ) ) ).

thf(tp_c_2Ebinary__ieee_2Eulp,type,
    c_2Ebinary__ieee_2Eulp: del > del > $i ).

thf(mem_c_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t: del,A_27w: del] : ( mem @ ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebool_2Eitself @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) @ ty_2Erealax_2Ereal ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__TY__DEF,axiom,
    ! [A_27t: del,A_27w: del] :
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) )
              @ ^ [V1a0_27: $i] :
                  ( ap @ ( c_2Ebool_2E_21 @ ( arr @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) @ bool ) )
                  @ ( lam @ ( arr @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) @ bool )
                    @ ^ [V2_27float_27: $i] :
                        ( ap
                        @ ( ap @ c_2Emin_2E_3D_3D_3E
                          @ ( ap @ ( c_2Ebool_2E_21 @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) )
                            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) )
                              @ ^ [V3a0_27: $i] :
                                  ( ap
                                  @ ( ap @ c_2Emin_2E_3D_3D_3E
                                    @ ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) )
                                      @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone )
                                        @ ^ [V4a0: $i] :
                                            ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
                                            @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ A_27w )
                                              @ ^ [V5a1: $i] :
                                                  ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                                                  @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ A_27t )
                                                    @ ^ [V6a2: $i] :
                                                        ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) ) @ V3a0_27 )
                                                        @ ( ap
                                                          @ ( ap
                                                            @ ( ap
                                                              @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone )
                                                                @ ^ [V7a0: $i] :
                                                                    ( lam @ ( ty_2Efcp_2Ecart @ bool @ A_27w )
                                                                    @ ^ [V8a1: $i] :
                                                                        ( lam @ ( ty_2Efcp_2Ecart @ bool @ A_27t )
                                                                        @ ^ [V9a2: $i] :
                                                                            ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) @ V7a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V8a1 ) @ V9a2 ) ) )
                                                                            @ ( lam @ ty_2Enum_2Enum
                                                                              @ ^ [V10n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) ) ) ) ) ) ) )
                                                              @ V4a0 )
                                                            @ V5a1 )
                                                          @ V6a2 ) ) ) ) ) ) ) ) )
                                  @ ( ap @ V2_27float_27 @ V3a0_27 ) ) ) ) )
                        @ ( ap @ V2_27float_27 @ V1a0_27 ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__case__def,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1a1: $i] :
      ( ( mem @ V1a1 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
     => ! [V2a2: $i] :
          ( ( mem @ V2a2 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
         => ! [V3f: $i] :
              ( ( mem @ V3f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ A_27a ) ) ) )
             => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0a0 ) ) @ V1a1 ) @ V2a2 ) ) @ V3f )
                = ( ap @ ( ap @ ( ap @ V3f @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0a0 ) ) @ V1a1 ) @ V2a2 ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__size__def,axiom,
    ! [A_27t: del,A_27w: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
     => ! [V1f1: $i] :
          ( ( mem @ V1f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
         => ! [V2a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3a1: $i] :
              ( ( mem @ V3a1 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V4a2: $i] :
                  ( ( mem @ V4a2 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V0f ) @ V1f1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V2a0 ) ) @ V3a1 ) @ V4a2 ) ) )
                    = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__Sign,axiom,
    ! [A_27t: del,A_27w: del,V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
      ( ( mem @ V1c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
     => ! [V2c1: $i] :
          ( ( mem @ V2c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
         => ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0c ) ) @ V1c0 ) @ V2c1 ) ) )
            = V0c ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__Exponent,axiom,
    ! [A_27t: del,A_27w: del,V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
      ( ( mem @ V1c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
     => ! [V2c1: $i] :
          ( ( mem @ V2c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0c ) ) @ V1c0 ) @ V2c1 ) )
            = V1c0 ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__Significand,axiom,
    ! [A_27t: del,A_27w: del,V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
      ( ( mem @ V1c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
     => ! [V2c1: $i] :
          ( ( mem @ V2c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0c ) ) @ V1c0 ) @ V2c1 ) )
            = V2c1 ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__accessors,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c0: $i] :
          ( ( mem @ V1c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
         => ! [V2c1: $i] :
              ( ( mem @ V2c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
             => ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0c ) ) @ V1c0 ) @ V2c1 ) ) )
                = V0c ) ) )
      & ! [V3c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4c0: $i] :
          ( ( mem @ V4c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
         => ! [V5c1: $i] :
              ( ( mem @ V5c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V3c ) ) @ V4c0 ) @ V5c1 ) )
                = V4c0 ) ) )
      & ! [V6c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V7c0: $i] :
          ( ( mem @ V7c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
         => ! [V8c1: $i] :
              ( ( mem @ V8c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V6c ) ) @ V7c0 ) @ V8c1 ) )
                = V8c1 ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__Sign__fupd,axiom,
    ! [A_27t: del,A_27w: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
     => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
         => ! [V3c1: $i] :
              ( ( mem @ V3c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
             => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V0f ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ V3c1 ) )
                = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( ap @ V0f @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) ) @ V2c0 ) @ V3c1 ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__Exponent__fupd,axiom,
    ! [A_27t: del,A_27w: del,A_27x: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
     => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
         => ! [V3c1: $i] :
              ( ( mem @ V3c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
             => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V0f ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ V3c1 ) )
                = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27x ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ ( ap @ V0f @ V2c0 ) ) @ V3c1 ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__Significand__fupd,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
     => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
         => ! [V3c1: $i] :
              ( ( mem @ V3c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
             => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V0f ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ V3c1 ) )
                = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27u @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ ( ap @ V0f @ V3c1 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__fn__updates,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0f: $i] :
          ( ( mem @ V0f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
              ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V3c1: $i] :
                  ( ( mem @ V3c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V0f ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ V3c1 ) )
                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( ap @ V0f @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) ) @ V2c0 ) @ V3c1 ) ) ) ) )
      & ! [V4f: $i] :
          ( ( mem @ V4f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V5c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V6c0: $i] :
              ( ( mem @ V6c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V7c1: $i] :
                  ( ( mem @ V7c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V4f ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V5c ) ) @ V6c0 ) @ V7c1 ) )
                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27x ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V5c ) ) @ ( ap @ V4f @ V6c0 ) ) @ V7c1 ) ) ) ) )
      & ! [V8f: $i] :
          ( ( mem @ V8f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
         => ! [V9c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V10c0: $i] :
              ( ( mem @ V10c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V11c1: $i] :
                  ( ( mem @ V11c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V8f ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V9c ) ) @ V10c0 ) @ V11c1 ) )
                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27u @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V9c ) ) @ V10c0 ) @ ( ap @ V8f @ V11c1 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__accfupds,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0f0: $i] :
          ( ( mem @ V0f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V1f: $i] :
              ( ( mem @ V1f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27x ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V0f0 ) @ V1f ) ) )
                = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1f ) ) ) ) )
      & ! [V2f0: $i] :
          ( ( mem @ V2f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
         => ! [V3f: $i] :
              ( ( mem @ V3f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27u @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V2f0 ) @ V3f ) ) )
                = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3f ) ) ) ) )
      & ! [V4f0: $i] :
          ( ( mem @ V4f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V5f: $i] :
              ( ( mem @ V5f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V4f0 ) @ V5f ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V5f ) ) ) )
      & ! [V6f0: $i] :
          ( ( mem @ V6f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
         => ! [V7f: $i] :
              ( ( mem @ V7f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27u @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V6f0 ) @ V7f ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V7f ) ) ) )
      & ! [V8f0: $i] :
          ( ( mem @ V8f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V9f: $i] :
              ( ( mem @ V9f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V8f0 ) @ V9f ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V9f ) ) ) )
      & ! [V10f0: $i] :
          ( ( mem @ V10f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V11f: $i] :
              ( ( mem @ V11f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27x ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V10f0 ) @ V11f ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V11f ) ) ) )
      & ! [V12f0: $i] :
          ( ( mem @ V12f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V13f: $i] :
              ( ( mem @ V13f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V12f0 ) @ V13f ) ) )
                = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ V12f0 @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V13f ) ) ) ) ) )
      & ! [V14f0: $i] :
          ( ( mem @ V14f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V15f: $i] :
              ( ( mem @ V15f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27x ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V14f0 ) @ V15f ) )
                = ( ap @ V14f0 @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V15f ) ) ) ) )
      & ! [V16f0: $i] :
          ( ( mem @ V16f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
         => ! [V17f: $i] :
              ( ( mem @ V17f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27u @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V16f0 ) @ V17f ) )
                = ( ap @ V16f0 @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V17f ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__fupdfupds,axiom,
    ! [A_27t: del,A_27u: del,A_27v: del,A_27w: del,A_27x: del,A_27y: del] :
      ( ! [V0g: $i] :
          ( ( mem @ V0g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V1f0: $i] :
              ( ( mem @ V1f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
             => ! [V2f: $i] :
                  ( ( mem @ V2f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V1f0 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V0g ) @ V2f ) )
                    = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V1f0 ) @ V0g ) ) @ V2f ) ) ) ) )
      & ! [V3g: $i] :
          ( ( mem @ V3g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V4f0: $i] :
              ( ( mem @ V4f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27y ) ) )
             => ! [V5f: $i] :
                  ( ( mem @ V5f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27x @ A_27y ) @ V4f0 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V3g ) @ V5f ) )
                    = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27y ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27y ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) @ V4f0 ) @ V3g ) ) @ V5f ) ) ) ) )
      & ! [V6g: $i] :
          ( ( mem @ V6g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
         => ! [V7f0: $i] :
              ( ( mem @ V7f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27v ) ) )
             => ! [V8f: $i] :
                  ( ( mem @ V8f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27u @ A_27v @ A_27w ) @ V7f0 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V6g ) @ V8f ) )
                    = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27v @ A_27w ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27v ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) @ V7f0 ) @ V6g ) ) @ V8f ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__fupdfupds__comp,axiom,
    ! [A_27a: del,A_27t: del,A_27u: del,A_27v: del,A_27w: del,A_27x: del,A_27y: del] :
      ( ! [V0g: $i] :
          ( ( mem @ V0g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V1f0: $i] :
              ( ( mem @ V1f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V1f0 ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V0g ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V1f0 ) @ V0g ) ) ) ) )
      & ! [V2h: $i] :
          ( ( mem @ V2h @ ( arr @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
         => ! [V3g: $i] :
              ( ( mem @ V3g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
             => ! [V4f0: $i] :
                  ( ( mem @ V4f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V4f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V3g ) ) @ V2h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4f0 ) @ V3g ) ) ) @ V2h ) ) ) ) )
      & ! [V5g: $i] :
          ( ( mem @ V5g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V6f0: $i] :
              ( ( mem @ V6f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27y ) ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27y ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27x @ A_27y ) @ V6f0 ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V5g ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27y ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27y ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) @ V6f0 ) @ V5g ) ) ) ) )
      & ! [V7h: $i] :
          ( ( mem @ V7h @ ( arr @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
         => ! [V8g: $i] :
              ( ( mem @ V8g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
             => ! [V9f0: $i] :
                  ( ( mem @ V9f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27y ) ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27y ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27x @ A_27y ) @ V9f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V8g ) ) @ V7h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27y ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27y ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27y ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) @ V9f0 ) @ V8g ) ) ) @ V7h ) ) ) ) )
      & ! [V10g: $i] :
          ( ( mem @ V10g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
         => ! [V11f0: $i] :
              ( ( mem @ V11f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27v ) ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27v @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27u @ A_27v @ A_27w ) @ V11f0 ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V10g ) )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27v @ A_27w ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27v ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) @ V11f0 ) @ V10g ) ) ) ) )
      & ! [V12h: $i] :
          ( ( mem @ V12h @ ( arr @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
         => ! [V13g: $i] :
              ( ( mem @ V13g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
             => ! [V14f0: $i] :
                  ( ( mem @ V14f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27v ) ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27v @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27u @ A_27v @ A_27w ) @ V14f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V13g ) ) @ V12h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27v @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27v @ A_27w ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27v ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) @ V14f0 ) @ V13g ) ) ) @ V12h ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__fupdcanon,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0g: $i] :
          ( ( mem @ V0g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V1f0: $i] :
              ( ( mem @ V1f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
             => ! [V2f: $i] :
                  ( ( mem @ V2f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V1f0 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V0g ) @ V2f ) )
                    = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27x ) @ V0g ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V1f0 ) @ V2f ) ) ) ) ) )
      & ! [V3g: $i] :
          ( ( mem @ V3g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V4f0: $i] :
              ( ( mem @ V4f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
             => ! [V5f: $i] :
                  ( ( mem @ V5f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V4f0 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V3g ) @ V5f ) )
                    = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27w ) @ V3g ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V4f0 ) @ V5f ) ) ) ) ) )
      & ! [V6g: $i] :
          ( ( mem @ V6g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V7f0: $i] :
              ( ( mem @ V7f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
             => ! [V8f: $i] :
                  ( ( mem @ V8f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27x ) @ V7f0 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V6g ) @ V8f ) )
                    = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ V6g ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V7f0 ) @ V8f ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__fupdcanon__comp,axiom,
    ! [A_27a: del,A_27t: del,A_27u: del,A_27w: del,A_27x: del] :
      ( ! [V0g: $i] :
          ( ( mem @ V0g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V1f0: $i] :
              ( ( mem @ V1f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V1f0 ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V0g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27x ) @ V0g ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V1f0 ) ) ) ) )
      & ! [V2h: $i] :
          ( ( mem @ V2h @ ( arr @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
         => ! [V3g: $i] :
              ( ( mem @ V3g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
             => ! [V4f0: $i] :
                  ( ( mem @ V4f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V4f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V3g ) ) @ V2h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27x ) @ V3g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V4f0 ) ) @ V2h ) ) ) ) ) )
      & ! [V5g: $i] :
          ( ( mem @ V5g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
         => ! [V6f0: $i] :
              ( ( mem @ V6f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V6f0 ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V5g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27w ) @ V5g ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V6f0 ) ) ) ) )
      & ! [V7h: $i] :
          ( ( mem @ V7h @ ( arr @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
         => ! [V8g: $i] :
              ( ( mem @ V8g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) )
             => ! [V9f0: $i] :
                  ( ( mem @ V9f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V9f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ V8g ) ) @ V7h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27w ) @ V8g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V9f0 ) ) @ V7h ) ) ) ) ) )
      & ! [V10g: $i] :
          ( ( mem @ V10g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
         => ! [V11f0: $i] :
              ( ( mem @ V11f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27x ) @ V11f0 ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V10g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ V10g ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V11f0 ) ) ) ) )
      & ! [V12h: $i] :
          ( ( mem @ V12h @ ( arr @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
         => ! [V13g: $i] :
              ( ( mem @ V13g @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) ) )
             => ! [V14f0: $i] :
                  ( ( mem @ V14f0 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27x ) @ V14f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27x ) @ V13g ) ) @ V12h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ V13g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ V14f0 ) ) @ V12h ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__component__equality,axiom,
    ! [A_27t: del,A_27w: del,V0f1: $i] :
      ( ( mem @ V0f1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1f2: $i] :
          ( ( mem @ V1f2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( V0f1 = V1f2 )
          <=> ( ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0f1 ) )
                = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1f2 ) ) )
              & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0f1 )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V1f2 ) )
              & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0f1 )
                = ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V1f2 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__updates__eq__literal,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0f: $i] :
      ( ( mem @ V0f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) )
         => ! [V3c: $i] :
              ( ( mem @ V3c @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) )
             => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c1 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V2c0 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V3c ) ) @ V0f ) ) )
                = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c1 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V2c0 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V3c ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__literal__nchotomy,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0f: $i] :
      ( ( mem @ V0f @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) )
     => ? [V1c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) )
          & ? [V3c: $i] :
              ( ( mem @ V3c @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) )
              & ( V0f
                = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c1 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V2c0 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V3c ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2EFORALL__float,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ bool ) )
     => ( ! [V1f: $i] :
            ( ( mem @ V1f @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) )
           => ( p @ ( ap @ V0P @ V1f ) ) )
      <=> ! [V2c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3c0: $i] :
            ( ( mem @ V3c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) )
           => ! [V4c: $i] :
                ( ( mem @ V4c @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) )
               => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V2c1 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V3c0 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V4c ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2EEXISTS__float,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) @ bool ) )
     => ( ? [V1f: $i] :
            ( ( mem @ V1f @ ( ty_2Ebinary__ieee_2Efloat @ A_27u @ A_27x ) )
            & ( p @ ( ap @ V0P @ V1f ) ) )
      <=> ? [V2c1: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3c0: $i] :
            ( ( mem @ V3c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) )
            & ? [V4c: $i] :
                ( ( mem @ V4c @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) )
                & ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V2c1 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V3c0 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V4c ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__literal__11,axiom,
    ! [A_27t: del,A_27u: del,A_27w: del,A_27x: del,V0c11: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1c01: $i] :
      ( ( mem @ V1c01 @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) )
     => ! [V2c1: $i] :
          ( ( mem @ V2c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) )
         => ! [V3c12: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4c02: $i] :
              ( ( mem @ V4c02 @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) )
             => ! [V5c2: $i] :
                  ( ( mem @ V5c2 @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) )
                 => ( ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0c11 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V1c01 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V2c1 ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27u @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V3c12 ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27u @ A_27w @ A_27x ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27x ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V4c02 ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27u @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27u ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ V5c2 ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                  <=> ( ( V0c11 = V3c12 )
                      & ( V1c01 = V4c02 )
                      & ( V2c1 = V5c2 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Edatatype__float,axiom,
    ! [A_27t: del,A_27w: del,V0record: $i] :
      ( ( mem @ V0record @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ bool ) ) ) ) )
     => ! [V1float: $i] :
          ( ( mem @ V1float @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V2Sign: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3Exponent: $i] :
              ( ( mem @ V3Exponent @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V4Significand: $i] :
                  ( ( mem @ V4Significand @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ ( ap @ V0record @ V1float ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V2Sign ) ) @ V3Exponent ) @ V4Significand ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__11,axiom,
    ! [A_27t: del,A_27w: del,V0a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V1a1: $i] :
      ( ( mem @ V1a1 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
     => ! [V2a2: $i] :
          ( ( mem @ V2a2 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
         => ! [V3a0_27: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4a1_27: $i] :
              ( ( mem @ V4a1_27 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V5a2_27: $i] :
                  ( ( mem @ V5a2_27 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0a0 ) ) @ V1a1 ) @ V2a2 )
                      = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V3a0_27 ) ) @ V4a1_27 ) @ V5a2_27 ) )
                  <=> ( ( V0a0 = V3a0_27 )
                      & ( V1a1 = V4a1_27 )
                      & ( V2a2 = V5a2_27 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__nchotomy,axiom,
    ! [A_27t: del,A_27w: del,V0ff: $i] :
      ( ( mem @ V0ff @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ? [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
          ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
          & ? [V3c1: $i] :
              ( ( mem @ V3c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
              & ( V0ff
                = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ V3c1 ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__Axiom,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ A_27a ) ) ) )
     => ? [V1fn: $i] :
          ( ( mem @ V1fn @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) )
          & ! [V2a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V3a1: $i] :
              ( ( mem @ V3a1 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
             => ! [V4a2: $i] :
                  ( ( mem @ V4a2 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                 => ( ( ap @ V1fn @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V2a0 ) ) @ V3a1 ) @ V4a2 ) )
                    = ( ap @ ( ap @ ( ap @ V0f @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V2a0 ) ) @ V3a1 ) @ V4a2 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__induction,axiom,
    ! [A_27t: del,A_27w: del,V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) )
     => ( ! [V1c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V2c0: $i] :
            ( ( mem @ V2c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
           => ! [V3c1: $i] :
                ( ( mem @ V3c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
               => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V1c ) ) @ V2c0 ) @ V3c1 ) ) ) ) )
       => ! [V4f: $i] :
            ( ( mem @ V4f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
           => ( p @ ( ap @ V0P @ V4f ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__case__cong,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f_27: $i] :
      ( ( mem @ V0f_27 @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ A_27a ) ) ) )
     => ! [V1M: $i] :
          ( ( mem @ V1M @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V2M_27: $i] :
              ( ( mem @ V2M_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V3f: $i] :
                  ( ( mem @ V3f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ A_27a ) ) ) )
                 => ( ( ( V1M = V2M_27 )
                      & ! [V4a0: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V5a1: $i] :
                          ( ( mem @ V5a1 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
                         => ! [V6a2: $i] :
                              ( ( mem @ V6a2 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                             => ( ( V2M_27
                                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V4a0 ) ) @ V5a1 ) @ V6a2 ) )
                               => ( ( ap @ ( ap @ ( ap @ V3f @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V4a0 ) ) @ V5a1 ) @ V6a2 )
                                  = ( ap @ ( ap @ ( ap @ V0f_27 @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V4a0 ) ) @ V5a1 ) @ V6a2 ) ) ) ) ) )
                   => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w ) @ V1M ) @ V3f )
                      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w ) @ V2M_27 ) @ V0f_27 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__case__eq,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1f: $i] :
          ( ( mem @ V1f @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( arr @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ A_27a ) ) ) )
         => ! [V2v: $i] :
              ( ( mem @ V2v @ A_27a )
             => ( ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__CASE @ A_27a @ A_27t @ A_27w ) @ V0x ) @ V1f )
                  = V2v )
              <=> ? [V3c: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone,V4c0: $i] :
                    ( ( mem @ V4c0 @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
                    & ? [V5c1: $i] :
                        ( ( mem @ V5c1 @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) )
                        & ( V0x
                          = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erecordtype_2Efloat @ A_27t @ A_27w ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V3c ) ) @ V4c0 ) @ V5c1 ) )
                        & ( ( ap @ ( ap @ ( ap @ V1f @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V3c ) ) @ V4c0 ) @ V5c1 )
                          = V2v ) ) ) ) ) ) ) ).

thf(stp_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,type,
    tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal: $tType ).

thf(stp_inj_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,type,
    inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal > $i ).

thf(stp_surj_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,type,
    surj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal: $i > tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal ).

thf(stp_inj_surj_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal] :
      ( ( surj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal @ ( inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal @ X ) )
      = X ) ).

thf(stp_inj_mem_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal] : ( mem @ ( inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal @ X ) @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) ).

thf(stp_iso_mem_c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) )
     => ( X
        = ( inj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal @ ( surj__c_ty_2Eind__type_2Erecspace_ty_2Erealax_2Ereal @ X ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__value__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) @ ty_2Ebinary__ieee_2Efloat__value )
            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal )
              @ ^ [V1a0: $i] :
                  ( ap @ ( c_2Ebool_2E_21 @ ( arr @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) @ bool ) )
                  @ ( lam @ ( arr @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) @ bool )
                    @ ^ [V2_27float__value_27: $i] :
                        ( ap
                        @ ( ap @ c_2Emin_2E_3D_3D_3E
                          @ ( ap @ ( c_2Ebool_2E_21 @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) )
                            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal )
                              @ ^ [V3a0: $i] :
                                  ( ap
                                  @ ( ap @ c_2Emin_2E_3D_3D_3E
                                    @ ( ap
                                      @ ( ap @ c_2Ebool_2E_5C_2F
                                        @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Erealax_2Ereal )
                                          @ ( lam @ ty_2Erealax_2Ereal
                                            @ ^ [V4a: $i] :
                                                ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) @ V3a0 )
                                                @ ( ap
                                                  @ ( lam @ ty_2Erealax_2Ereal
                                                    @ ^ [V5a: $i] :
                                                        ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ty_2Erealax_2Ereal ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) @ V5a )
                                                        @ ( lam @ ty_2Enum_2Enum
                                                          @ ^ [V6n: $i] : ( c_2Eind__type_2EBOTTOM @ ty_2Erealax_2Ereal ) ) ) )
                                                  @ V4a ) ) ) ) )
                                      @ ( ap
                                        @ ( ap @ c_2Ebool_2E_5C_2F
                                          @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) @ V3a0 )
                                            @ ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ty_2Erealax_2Ereal ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2EARB @ ty_2Erealax_2Ereal ) )
                                              @ ( lam @ ty_2Enum_2Enum
                                                @ ^ [V7n: $i] : ( c_2Eind__type_2EBOTTOM @ ty_2Erealax_2Ereal ) ) ) ) )
                                        @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ty_2Erealax_2Ereal ) ) @ V3a0 )
                                          @ ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ty_2Erealax_2Ereal ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( c_2Ebool_2EARB @ ty_2Erealax_2Ereal ) )
                                            @ ( lam @ ty_2Enum_2Enum
                                              @ ^ [V8n: $i] : ( c_2Eind__type_2EBOTTOM @ ty_2Erealax_2Ereal ) ) ) ) ) ) )
                                  @ ( ap @ V2_27float__value_27 @ V3a0 ) ) ) ) )
                        @ ( ap @ V2_27float__value_27 @ V1a0 ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__value__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0a: tp__ty_2Erealax_2Ereal,V1f: $i] :
          ( ( mem @ V1f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
         => ! [V2v: $i] :
              ( ( mem @ V2v @ A_27a )
             => ! [V3v1: $i] :
                  ( ( mem @ V3v1 @ A_27a )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) ) @ V1f ) @ V2v ) @ V3v1 )
                    = ( ap @ V1f @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) ) ) ) )
      & ! [V4f: $i] :
          ( ( mem @ V4f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
         => ! [V5v: $i] :
              ( ( mem @ V5v @ A_27a )
             => ! [V6v1: $i] :
                  ( ( mem @ V6v1 @ A_27a )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity ) ) @ V4f ) @ V5v ) @ V6v1 )
                    = V5v ) ) ) )
      & ! [V7f: $i] :
          ( ( mem @ V7f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
         => ! [V8v: $i] :
              ( ( mem @ V8v @ A_27a )
             => ! [V9v1: $i] :
                  ( ( mem @ V9v1 @ A_27a )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN ) ) @ V7f ) @ V8v ) @ V9v1 )
                    = V9v1 ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__value__size__def,axiom,
    ( ! [V0a: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__value__size @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) ) )
        = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__value__size @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity ) ) )
      = fo__c_2Enum_2E0 )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__value__size @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN ) ) )
      = fo__c_2Enum_2E0 ) ) ).

thf(conj_thm_2Ebinary__ieee_2Edatatype__float__value,axiom,
    ! [V0float__value: $i] :
      ( ( mem @ V0float__value @ ( arr @ ( arr @ ty_2Erealax_2Ereal @ ty_2Ebinary__ieee_2Efloat__value ) @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ bool ) ) ) )
     => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ V0float__value @ c_2Ebinary__ieee_2EFloat ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__11,axiom,
    ! [V0a: tp__ty_2Erealax_2Ereal,V1a_27: tp__ty_2Erealax_2Ereal] :
      ( ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) )
        = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V1a_27 ) ) ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__distinct,axiom,
    ( ! [V0a: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) )
       != fo__c_2Ebinary__ieee_2EInfinity )
    & ! [V1a: tp__ty_2Erealax_2Ereal] :
        ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V1a ) ) )
       != fo__c_2Ebinary__ieee_2ENaN )
    & ( fo__c_2Ebinary__ieee_2EInfinity != fo__c_2Ebinary__ieee_2ENaN ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__nchotomy,axiom,
    ! [V0ff: tp__ty_2Ebinary__ieee_2Efloat__value] :
      ( ? [V1r: tp__ty_2Erealax_2Ereal] :
          ( V0ff
          = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V1r ) ) ) )
      | ( V0ff = fo__c_2Ebinary__ieee_2EInfinity )
      | ( V0ff = fo__c_2Ebinary__ieee_2ENaN ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__Axiom,axiom,
    ! [A_27a: del,V0f0: $i] :
      ( ( mem @ V0f0 @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
     => ! [V1f1: $i] :
          ( ( mem @ V1f1 @ A_27a )
         => ! [V2f2: $i] :
              ( ( mem @ V2f2 @ A_27a )
             => ? [V3fn: $i] :
                  ( ( mem @ V3fn @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ A_27a ) )
                  & ! [V4a: tp__ty_2Erealax_2Ereal] :
                      ( ( ap @ V3fn @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V4a ) ) )
                      = ( ap @ V0f0 @ ( inj__ty_2Erealax_2Ereal @ V4a ) ) )
                  & ( ( ap @ V3fn @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity ) )
                    = V1f1 )
                  & ( ( ap @ V3fn @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN ) )
                    = V2f2 ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__induction,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Ebinary__ieee_2Efloat__value @ bool ) )
     => ( ( ! [V1r: tp__ty_2Erealax_2Ereal] : ( p @ ( ap @ V0P @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V1r ) ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN ) ) ) )
       => ! [V2f: tp__ty_2Ebinary__ieee_2Efloat__value] : ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ V2f ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__case__cong,axiom,
    ! [A_27a: del,V0f_27: $i] :
      ( ( mem @ V0f_27 @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
     => ! [V1v_27: $i] :
          ( ( mem @ V1v_27 @ A_27a )
         => ! [V2v1_27: $i] :
              ( ( mem @ V2v1_27 @ A_27a )
             => ! [V3M: tp__ty_2Ebinary__ieee_2Efloat__value,V4M_27: tp__ty_2Ebinary__ieee_2Efloat__value,V5f: $i] :
                  ( ( mem @ V5f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
                 => ! [V6v: $i] :
                      ( ( mem @ V6v @ A_27a )
                     => ! [V7v1: $i] :
                          ( ( mem @ V7v1 @ A_27a )
                         => ( ( ( V3M = V4M_27 )
                              & ! [V8a: tp__ty_2Erealax_2Ereal] :
                                  ( ( V4M_27
                                    = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V8a ) ) ) )
                                 => ( ( ap @ V5f @ ( inj__ty_2Erealax_2Ereal @ V8a ) )
                                    = ( ap @ V0f_27 @ ( inj__ty_2Erealax_2Ereal @ V8a ) ) ) )
                              & ( ( V4M_27 = fo__c_2Ebinary__ieee_2EInfinity )
                               => ( V6v = V1v_27 ) )
                              & ( ( V4M_27 = fo__c_2Ebinary__ieee_2ENaN )
                               => ( V7v1 = V2v1_27 ) ) )
                           => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ V3M ) ) @ V5f ) @ V6v ) @ V7v1 )
                              = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ V4M_27 ) ) @ V0f_27 ) @ V1v_27 ) @ V2v1_27 ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__value__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Efloat__value,V1f: $i] :
      ( ( mem @ V1f @ ( arr @ ty_2Erealax_2Ereal @ A_27a ) )
     => ! [V2v: $i] :
          ( ( mem @ V2v @ A_27a )
         => ! [V3v1: $i] :
              ( ( mem @ V3v1 @ A_27a )
             => ! [V4v_27: $i] :
                  ( ( mem @ V4v_27 @ A_27a )
                 => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ V0x ) ) @ V1f ) @ V2v ) @ V3v1 )
                      = V4v_27 )
                  <=> ( ? [V5r: tp__ty_2Erealax_2Ereal] :
                          ( ( V0x
                            = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V5r ) ) ) )
                          & ( ( ap @ V1f @ ( inj__ty_2Erealax_2Ereal @ V5r ) )
                            = V4v_27 ) )
                      | ( ( V0x = fo__c_2Ebinary__ieee_2EInfinity )
                        & ( V2v = V4v_27 ) )
                      | ( ( V0x = fo__c_2Ebinary__ieee_2ENaN )
                        & ( V3v1 = V4v_27 ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__to__real__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V0x ) )
        = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Erealax_2Ereal ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0x ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( c_2Ewords_2Ew2n @ ty_2Eone_2Eone ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ ( c_2Ewords_2Ew2n @ A_27t ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( c_2Ewords_2Ew2n @ ty_2Eone_2Eone ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2Ew2n @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__add @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ ( c_2Ewords_2Ew2n @ A_27t ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0x ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__value__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) )
        = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0x ) ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0x ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2EInfinity ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__value @ fo__c_2Ebinary__ieee_2ENaN ) ) ) @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V0x ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__nan__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V0x ) )
      <=> ( p
          @ ( ap
            @ ( ap
              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ bool ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V1v1: $i] : c_2Ebool_2EF ) )
              @ c_2Ebool_2EF )
            @ c_2Ebool_2ET ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__signalling__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27t @ A_27w ) @ V0x ) )
      <=> ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V0x ) )
          & ~ ( p @ ( ap @ ( c_2Ewords_2Eword__msb @ A_27t ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0x ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__infinite__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V0x ) )
      <=> ( p
          @ ( ap
            @ ( ap
              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ bool ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V1v1: $i] : c_2Ebool_2EF ) )
              @ c_2Ebool_2ET )
            @ c_2Ebool_2EF ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__normal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ V0x ) )
      <=> ( ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0x )
           != ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
          & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0x )
           != ( c_2Ewords_2Eword__T @ A_27w ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__subnormal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ V0x ) )
      <=> ( ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0x )
            = ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
          & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0x )
           != ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__zero__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ V0x ) )
      <=> ( p
          @ ( ap
            @ ( ap
              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ bool ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V1r: $i] : ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V1r ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
              @ c_2Ebool_2EF )
            @ c_2Ebool_2EF ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__finite__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ V0x ) )
      <=> ( p
          @ ( ap
            @ ( ap
              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ bool ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V1v1: $i] : c_2Ebool_2ET ) )
              @ c_2Ebool_2EF )
            @ c_2Ebool_2EF ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eis__integral__def,axiom,
    ! [V0r: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ c_2Ebinary__ieee_2Eis__integral @ ( inj__ty_2Erealax_2Ereal @ V0r ) ) )
    <=> ? [V1n: tp__ty_2Enum_2Enum] :
          ( ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Eabs @ ( inj__ty_2Erealax_2Ereal @ V0r ) ) )
          = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__is__integral__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ V0x ) )
      <=> ( p
          @ ( ap
            @ ( ap
              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ bool ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V1r: $i] : ( ap @ c_2Ebinary__ieee_2Eis__integral @ V1r ) ) )
              @ c_2Ebool_2EF )
            @ c_2Ebool_2EF ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__negate__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ V0x )
        = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2Eword__1comp @ ty_2Eone_2Eone ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0x ) ) ) ) @ V0x ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__abs__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__abs @ A_27t @ A_27w ) @ V0x )
        = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ V0x ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__plus__infinity__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__plus__zero__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__top__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Ewords_2Eword__sub @ A_27w ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ ( c_2Ewords_2Eword__T @ A_27t ) ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__plus__min__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign__fupd @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent__fupd @ A_27t @ A_27w @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand__fupd @ A_27t @ A_27t @ A_27w ) @ ( ap @ ( c_2Ecombin_2EK @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) @ ( ty_2Efcp_2Ecart @ bool @ A_27t ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__minus__infinity__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__minus__zero__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__bottom__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__minus__min__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
      = ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ).

thf(stp_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $tType ).

thf(stp_inj_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

thf(stp_surj_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    surj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $i > tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ).

thf(stp_inj_surj_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] :
      ( ( surj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ ( inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) )
      = X ) ).

thf(stp_inj_mem_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( mem @ ( inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) ) ).

thf(stp_iso_mem_c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) )
     => ( X
        = ( inj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ ( surj__c_ty_2Eind__type_2Erecspace_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) ) ) ) ).

thf(stp_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $tType ).

thf(stp_inj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

thf(stp_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $i > tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ).

thf(stp_inj_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] :
      ( ( surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ ( inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) )
      = X ) ).

thf(stp_inj_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( mem @ ( inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) ).

thf(stp_iso_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) )
     => ( X
        = ( inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ ( surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) ) ) ) ).

thf(stp_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $tType ).

thf(stp_inj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o > $i ).

thf(stp_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,type,
    surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o: $i > tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o ).

thf(stp_inj_surj_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] :
      ( ( surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ ( inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) )
      = X ) ).

thf(stp_inj_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: tp__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o] : ( mem @ ( inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ).

thf(stp_iso_mem_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o,axiom,
    ! [X: $i] :
      ( ( mem @ X @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) )
     => ( X
        = ( inj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ ( surj__c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_c_ty_2Epair_2Eprod_o_o @ X ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) @ ty_2Ebinary__ieee_2Eflags )
            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) )
              @ ^ [V1a0_27: $i] :
                  ( ap @ ( c_2Ebool_2E_21 @ ( arr @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) @ bool ) )
                  @ ( lam @ ( arr @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) @ bool )
                    @ ^ [V2_27flags_27: $i] :
                        ( ap
                        @ ( ap @ c_2Emin_2E_3D_3D_3E
                          @ ( ap @ ( c_2Ebool_2E_21 @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) )
                            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) )
                              @ ^ [V3a0_27: $i] :
                                  ( ap
                                  @ ( ap @ c_2Emin_2E_3D_3D_3E
                                    @ ( ap @ ( c_2Ebool_2E_3F @ bool )
                                      @ ( lam @ bool
                                        @ ^ [V4a0: $i] :
                                            ( ap @ ( c_2Ebool_2E_3F @ bool )
                                            @ ( lam @ bool
                                              @ ^ [V5a1: $i] :
                                                  ( ap @ ( c_2Ebool_2E_3F @ bool )
                                                  @ ( lam @ bool
                                                    @ ^ [V6a2: $i] :
                                                        ( ap @ ( c_2Ebool_2E_3F @ bool )
                                                        @ ( lam @ bool
                                                          @ ^ [V7a3: $i] :
                                                              ( ap @ ( c_2Ebool_2E_3F @ bool )
                                                              @ ( lam @ bool
                                                                @ ^ [V8a4: $i] :
                                                                    ( ap @ ( c_2Ebool_2E_3F @ bool )
                                                                    @ ( lam @ bool
                                                                      @ ^ [V9a5: $i] :
                                                                          ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) ) @ V3a0_27 )
                                                                          @ ( ap
                                                                            @ ( ap
                                                                              @ ( ap
                                                                                @ ( ap
                                                                                  @ ( ap
                                                                                    @ ( ap
                                                                                      @ ( lam @ bool
                                                                                        @ ^ [V10a0: $i] :
                                                                                            ( lam @ bool
                                                                                            @ ^ [V11a1: $i] :
                                                                                                ( lam @ bool
                                                                                                @ ^ [V12a2: $i] :
                                                                                                    ( lam @ bool
                                                                                                    @ ^ [V13a3: $i] :
                                                                                                        ( lam @ bool
                                                                                                        @ ^ [V14a4: $i] :
                                                                                                            ( lam @ bool
                                                                                                            @ ^ [V15a5: $i] :
                                                                                                                ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) @ V10a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) @ V11a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) @ V12a2 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) @ V13a3 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ bool @ bool ) @ V14a4 ) @ V15a5 ) ) ) ) ) )
                                                                                                                @ ( lam @ ty_2Enum_2Enum
                                                                                                                  @ ^ [V16n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ ( ty_2Epair_2Eprod @ bool @ bool ) ) ) ) ) ) ) ) ) ) ) ) ) )
                                                                                      @ V4a0 )
                                                                                    @ V5a1 )
                                                                                  @ V6a2 )
                                                                                @ V7a3 )
                                                                              @ V8a4 )
                                                                            @ V9a5 ) ) ) ) ) ) ) ) ) ) ) ) ) ) )
                                  @ ( ap @ V2_27flags_27 @ V3a0_27 ) ) ) ) )
                        @ ( ap @ V2_27flags_27 @ V1a0_27 ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__case__def,axiom,
    ! [A_27a: del,V0a0: $i] :
      ( ( mem @ V0a0 @ bool )
     => ! [V1a1: $i] :
          ( ( mem @ V1a1 @ bool )
         => ! [V2a2: $i] :
              ( ( mem @ V2a2 @ bool )
             => ! [V3a3: $i] :
                  ( ( mem @ V3a3 @ bool )
                 => ! [V4a4: $i] :
                      ( ( mem @ V4a4 @ bool )
                     => ! [V5a5: $i] :
                          ( ( mem @ V5a5 @ bool )
                         => ! [V6f: $i] :
                              ( ( mem @ V6f @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ A_27a ) ) ) ) ) ) )
                             => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0a0 ) @ V1a1 ) @ V2a2 ) @ V3a3 ) @ V4a4 ) @ V5a5 ) ) @ V6f )
                                = ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V6f @ V0a0 ) @ V1a1 ) @ V2a2 ) @ V3a3 ) @ V4a4 ) @ V5a5 ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__size__def,axiom,
    ! [V0a0: $i] :
      ( ( mem @ V0a0 @ bool )
     => ! [V1a1: $i] :
          ( ( mem @ V1a1 @ bool )
         => ! [V2a2: $i] :
              ( ( mem @ V2a2 @ bool )
             => ! [V3a3: $i] :
                  ( ( mem @ V3a3 @ bool )
                 => ! [V4a4: $i] :
                      ( ( mem @ V4a4 @ bool )
                     => ! [V5a5: $i] :
                          ( ( mem @ V5a5 @ bool )
                         => ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Eflags__size @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0a0 ) @ V1a1 ) @ V2a2 ) @ V3a3 ) @ V4a4 ) @ V5a5 ) ) )
                            = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2EbasicSize_2Ebool__size @ V0a0 ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2EbasicSize_2Ebool__size @ V1a1 ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2EbasicSize_2Ebool__size @ V2a2 ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2EbasicSize_2Ebool__size @ V3a3 ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2EbasicSize_2Ebool__size @ V4a4 ) ) @ ( ap @ c_2EbasicSize_2Ebool__size @ V5a5 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__DivideByZero,axiom,
    ! [V0b: $i] :
      ( ( mem @ V0b @ bool )
     => ! [V1b0: $i] :
          ( ( mem @ V1b0 @ bool )
         => ! [V2b1: $i] :
              ( ( mem @ V2b1 @ bool )
             => ! [V3b2: $i] :
                  ( ( mem @ V3b2 @ bool )
                 => ! [V4b3: $i] :
                      ( ( mem @ V4b3 @ bool )
                     => ! [V5b4: $i] :
                          ( ( mem @ V5b4 @ bool )
                         => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                          <=> ( p @ V0b ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__InvalidOp,axiom,
    ! [V0b: $i] :
      ( ( mem @ V0b @ bool )
     => ! [V1b0: $i] :
          ( ( mem @ V1b0 @ bool )
         => ! [V2b1: $i] :
              ( ( mem @ V2b1 @ bool )
             => ! [V3b2: $i] :
                  ( ( mem @ V3b2 @ bool )
                 => ! [V4b3: $i] :
                      ( ( mem @ V4b3 @ bool )
                     => ! [V5b4: $i] :
                          ( ( mem @ V5b4 @ bool )
                         => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                          <=> ( p @ V1b0 ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Overflow,axiom,
    ! [V0b: $i] :
      ( ( mem @ V0b @ bool )
     => ! [V1b0: $i] :
          ( ( mem @ V1b0 @ bool )
         => ! [V2b1: $i] :
              ( ( mem @ V2b1 @ bool )
             => ! [V3b2: $i] :
                  ( ( mem @ V3b2 @ bool )
                 => ! [V4b3: $i] :
                      ( ( mem @ V4b3 @ bool )
                     => ! [V5b4: $i] :
                          ( ( mem @ V5b4 @ bool )
                         => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                          <=> ( p @ V2b1 ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Precision,axiom,
    ! [V0b: $i] :
      ( ( mem @ V0b @ bool )
     => ! [V1b0: $i] :
          ( ( mem @ V1b0 @ bool )
         => ! [V2b1: $i] :
              ( ( mem @ V2b1 @ bool )
             => ! [V3b2: $i] :
                  ( ( mem @ V3b2 @ bool )
                 => ! [V4b3: $i] :
                      ( ( mem @ V4b3 @ bool )
                     => ! [V5b4: $i] :
                          ( ( mem @ V5b4 @ bool )
                         => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                          <=> ( p @ V3b2 ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding,axiom,
    ! [V0b: $i] :
      ( ( mem @ V0b @ bool )
     => ! [V1b0: $i] :
          ( ( mem @ V1b0 @ bool )
         => ! [V2b1: $i] :
              ( ( mem @ V2b1 @ bool )
             => ! [V3b2: $i] :
                  ( ( mem @ V3b2 @ bool )
                 => ! [V4b3: $i] :
                      ( ( mem @ V4b3 @ bool )
                     => ! [V5b4: $i] :
                          ( ( mem @ V5b4 @ bool )
                         => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                          <=> ( p @ V4b3 ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding,axiom,
    ! [V0b: $i] :
      ( ( mem @ V0b @ bool )
     => ! [V1b0: $i] :
          ( ( mem @ V1b0 @ bool )
         => ! [V2b1: $i] :
              ( ( mem @ V2b1 @ bool )
             => ! [V3b2: $i] :
                  ( ( mem @ V3b2 @ bool )
                 => ! [V4b3: $i] :
                      ( ( mem @ V4b3 @ bool )
                     => ! [V5b4: $i] :
                          ( ( mem @ V5b4 @ bool )
                         => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                          <=> ( p @ V5b4 ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__accessors,axiom,
    ( ! [V0b: $i] :
        ( ( mem @ V0b @ bool )
       => ! [V1b0: $i] :
            ( ( mem @ V1b0 @ bool )
           => ! [V2b1: $i] :
                ( ( mem @ V2b1 @ bool )
               => ! [V3b2: $i] :
                    ( ( mem @ V3b2 @ bool )
                   => ! [V4b3: $i] :
                        ( ( mem @ V4b3 @ bool )
                       => ! [V5b4: $i] :
                            ( ( mem @ V5b4 @ bool )
                           => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0b ) @ V1b0 ) @ V2b1 ) @ V3b2 ) @ V4b3 ) @ V5b4 ) ) )
                            <=> ( p @ V0b ) ) ) ) ) ) ) )
    & ! [V6b: $i] :
        ( ( mem @ V6b @ bool )
       => ! [V7b0: $i] :
            ( ( mem @ V7b0 @ bool )
           => ! [V8b1: $i] :
                ( ( mem @ V8b1 @ bool )
               => ! [V9b2: $i] :
                    ( ( mem @ V9b2 @ bool )
                   => ! [V10b3: $i] :
                        ( ( mem @ V10b3 @ bool )
                       => ! [V11b4: $i] :
                            ( ( mem @ V11b4 @ bool )
                           => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V6b ) @ V7b0 ) @ V8b1 ) @ V9b2 ) @ V10b3 ) @ V11b4 ) ) )
                            <=> ( p @ V7b0 ) ) ) ) ) ) ) )
    & ! [V12b: $i] :
        ( ( mem @ V12b @ bool )
       => ! [V13b0: $i] :
            ( ( mem @ V13b0 @ bool )
           => ! [V14b1: $i] :
                ( ( mem @ V14b1 @ bool )
               => ! [V15b2: $i] :
                    ( ( mem @ V15b2 @ bool )
                   => ! [V16b3: $i] :
                        ( ( mem @ V16b3 @ bool )
                       => ! [V17b4: $i] :
                            ( ( mem @ V17b4 @ bool )
                           => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V12b ) @ V13b0 ) @ V14b1 ) @ V15b2 ) @ V16b3 ) @ V17b4 ) ) )
                            <=> ( p @ V14b1 ) ) ) ) ) ) ) )
    & ! [V18b: $i] :
        ( ( mem @ V18b @ bool )
       => ! [V19b0: $i] :
            ( ( mem @ V19b0 @ bool )
           => ! [V20b1: $i] :
                ( ( mem @ V20b1 @ bool )
               => ! [V21b2: $i] :
                    ( ( mem @ V21b2 @ bool )
                   => ! [V22b3: $i] :
                        ( ( mem @ V22b3 @ bool )
                       => ! [V23b4: $i] :
                            ( ( mem @ V23b4 @ bool )
                           => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V18b ) @ V19b0 ) @ V20b1 ) @ V21b2 ) @ V22b3 ) @ V23b4 ) ) )
                            <=> ( p @ V21b2 ) ) ) ) ) ) ) )
    & ! [V24b: $i] :
        ( ( mem @ V24b @ bool )
       => ! [V25b0: $i] :
            ( ( mem @ V25b0 @ bool )
           => ! [V26b1: $i] :
                ( ( mem @ V26b1 @ bool )
               => ! [V27b2: $i] :
                    ( ( mem @ V27b2 @ bool )
                   => ! [V28b3: $i] :
                        ( ( mem @ V28b3 @ bool )
                       => ! [V29b4: $i] :
                            ( ( mem @ V29b4 @ bool )
                           => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V24b ) @ V25b0 ) @ V26b1 ) @ V27b2 ) @ V28b3 ) @ V29b4 ) ) )
                            <=> ( p @ V28b3 ) ) ) ) ) ) ) )
    & ! [V30b: $i] :
        ( ( mem @ V30b @ bool )
       => ! [V31b0: $i] :
            ( ( mem @ V31b0 @ bool )
           => ! [V32b1: $i] :
                ( ( mem @ V32b1 @ bool )
               => ! [V33b2: $i] :
                    ( ( mem @ V33b2 @ bool )
                   => ! [V34b3: $i] :
                        ( ( mem @ V34b3 @ bool )
                       => ! [V35b4: $i] :
                            ( ( mem @ V35b4 @ bool )
                           => ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V30b ) @ V31b0 ) @ V32b1 ) @ V33b2 ) @ V34b3 ) @ V35b4 ) ) )
                            <=> ( p @ V35b4 ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__DivideByZero__fupd,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ bool ) )
     => ! [V1b: $i] :
          ( ( mem @ V1b @ bool )
         => ! [V2b0: $i] :
              ( ( mem @ V2b0 @ bool )
             => ! [V3b1: $i] :
                  ( ( mem @ V3b1 @ bool )
                 => ! [V4b2: $i] :
                      ( ( mem @ V4b2 @ bool )
                     => ! [V5b3: $i] :
                          ( ( mem @ V5b3 @ bool )
                         => ! [V6b4: $i] :
                              ( ( mem @ V6b4 @ bool )
                             => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ ( ap @ V0f @ V1b ) ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__InvalidOp__fupd,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ bool ) )
     => ! [V1b: $i] :
          ( ( mem @ V1b @ bool )
         => ! [V2b0: $i] :
              ( ( mem @ V2b0 @ bool )
             => ! [V3b1: $i] :
                  ( ( mem @ V3b1 @ bool )
                 => ! [V4b2: $i] :
                      ( ( mem @ V4b2 @ bool )
                     => ! [V5b3: $i] :
                          ( ( mem @ V5b3 @ bool )
                         => ! [V6b4: $i] :
                              ( ( mem @ V6b4 @ bool )
                             => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ ( ap @ V0f @ V2b0 ) ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Overflow__fupd,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ bool ) )
     => ! [V1b: $i] :
          ( ( mem @ V1b @ bool )
         => ! [V2b0: $i] :
              ( ( mem @ V2b0 @ bool )
             => ! [V3b1: $i] :
                  ( ( mem @ V3b1 @ bool )
                 => ! [V4b2: $i] :
                      ( ( mem @ V4b2 @ bool )
                     => ! [V5b3: $i] :
                          ( ( mem @ V5b3 @ bool )
                         => ! [V6b4: $i] :
                              ( ( mem @ V6b4 @ bool )
                             => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ ( ap @ V0f @ V3b1 ) ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Precision__fupd,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ bool ) )
     => ! [V1b: $i] :
          ( ( mem @ V1b @ bool )
         => ! [V2b0: $i] :
              ( ( mem @ V2b0 @ bool )
             => ! [V3b1: $i] :
                  ( ( mem @ V3b1 @ bool )
                 => ! [V4b2: $i] :
                      ( ( mem @ V4b2 @ bool )
                     => ! [V5b3: $i] :
                          ( ( mem @ V5b3 @ bool )
                         => ! [V6b4: $i] :
                              ( ( mem @ V6b4 @ bool )
                             => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ ( ap @ V0f @ V4b2 ) ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ bool ) )
     => ! [V1b: $i] :
          ( ( mem @ V1b @ bool )
         => ! [V2b0: $i] :
              ( ( mem @ V2b0 @ bool )
             => ! [V3b1: $i] :
                  ( ( mem @ V3b1 @ bool )
                 => ! [V4b2: $i] :
                      ( ( mem @ V4b2 @ bool )
                     => ! [V5b3: $i] :
                          ( ( mem @ V5b3 @ bool )
                         => ! [V6b4: $i] :
                              ( ( mem @ V6b4 @ bool )
                             => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ ( ap @ V0f @ V5b3 ) ) @ V6b4 ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd,axiom,
    ! [V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ bool ) )
     => ! [V1b: $i] :
          ( ( mem @ V1b @ bool )
         => ! [V2b0: $i] :
              ( ( mem @ V2b0 @ bool )
             => ! [V3b1: $i] :
                  ( ( mem @ V3b1 @ bool )
                 => ! [V4b2: $i] :
                      ( ( mem @ V4b2 @ bool )
                     => ! [V5b3: $i] :
                          ( ( mem @ V5b3 @ bool )
                         => ! [V6b4: $i] :
                              ( ( mem @ V6b4 @ bool )
                             => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ ( ap @ V0f @ V6b4 ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__fn__updates,axiom,
    ( ! [V0f: $i] :
        ( ( mem @ V0f @ ( arr @ bool @ bool ) )
       => ! [V1b: $i] :
            ( ( mem @ V1b @ bool )
           => ! [V2b0: $i] :
                ( ( mem @ V2b0 @ bool )
               => ! [V3b1: $i] :
                    ( ( mem @ V3b1 @ bool )
                   => ! [V4b2: $i] :
                        ( ( mem @ V4b2 @ bool )
                       => ! [V5b3: $i] :
                            ( ( mem @ V5b3 @ bool )
                           => ! [V6b4: $i] :
                                ( ( mem @ V6b4 @ bool )
                               => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) )
                                  = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ ( ap @ V0f @ V1b ) ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) ) )
    & ! [V7f: $i] :
        ( ( mem @ V7f @ ( arr @ bool @ bool ) )
       => ! [V8b: $i] :
            ( ( mem @ V8b @ bool )
           => ! [V9b0: $i] :
                ( ( mem @ V9b0 @ bool )
               => ! [V10b1: $i] :
                    ( ( mem @ V10b1 @ bool )
                   => ! [V11b2: $i] :
                        ( ( mem @ V11b2 @ bool )
                       => ! [V12b3: $i] :
                            ( ( mem @ V12b3 @ bool )
                           => ! [V13b4: $i] :
                                ( ( mem @ V13b4 @ bool )
                               => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V7f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V8b ) @ V9b0 ) @ V10b1 ) @ V11b2 ) @ V12b3 ) @ V13b4 ) ) )
                                  = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V8b ) @ ( ap @ V7f @ V9b0 ) ) @ V10b1 ) @ V11b2 ) @ V12b3 ) @ V13b4 ) ) ) ) ) ) ) ) ) )
    & ! [V14f: $i] :
        ( ( mem @ V14f @ ( arr @ bool @ bool ) )
       => ! [V15b: $i] :
            ( ( mem @ V15b @ bool )
           => ! [V16b0: $i] :
                ( ( mem @ V16b0 @ bool )
               => ! [V17b1: $i] :
                    ( ( mem @ V17b1 @ bool )
                   => ! [V18b2: $i] :
                        ( ( mem @ V18b2 @ bool )
                       => ! [V19b3: $i] :
                            ( ( mem @ V19b3 @ bool )
                           => ! [V20b4: $i] :
                                ( ( mem @ V20b4 @ bool )
                               => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V15b ) @ V16b0 ) @ V17b1 ) @ V18b2 ) @ V19b3 ) @ V20b4 ) ) )
                                  = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V15b ) @ V16b0 ) @ ( ap @ V14f @ V17b1 ) ) @ V18b2 ) @ V19b3 ) @ V20b4 ) ) ) ) ) ) ) ) ) )
    & ! [V21f: $i] :
        ( ( mem @ V21f @ ( arr @ bool @ bool ) )
       => ! [V22b: $i] :
            ( ( mem @ V22b @ bool )
           => ! [V23b0: $i] :
                ( ( mem @ V23b0 @ bool )
               => ! [V24b1: $i] :
                    ( ( mem @ V24b1 @ bool )
                   => ! [V25b2: $i] :
                        ( ( mem @ V25b2 @ bool )
                       => ! [V26b3: $i] :
                            ( ( mem @ V26b3 @ bool )
                           => ! [V27b4: $i] :
                                ( ( mem @ V27b4 @ bool )
                               => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V21f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V22b ) @ V23b0 ) @ V24b1 ) @ V25b2 ) @ V26b3 ) @ V27b4 ) ) )
                                  = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V22b ) @ V23b0 ) @ V24b1 ) @ ( ap @ V21f @ V25b2 ) ) @ V26b3 ) @ V27b4 ) ) ) ) ) ) ) ) ) )
    & ! [V28f: $i] :
        ( ( mem @ V28f @ ( arr @ bool @ bool ) )
       => ! [V29b: $i] :
            ( ( mem @ V29b @ bool )
           => ! [V30b0: $i] :
                ( ( mem @ V30b0 @ bool )
               => ! [V31b1: $i] :
                    ( ( mem @ V31b1 @ bool )
                   => ! [V32b2: $i] :
                        ( ( mem @ V32b2 @ bool )
                       => ! [V33b3: $i] :
                            ( ( mem @ V33b3 @ bool )
                           => ! [V34b4: $i] :
                                ( ( mem @ V34b4 @ bool )
                               => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V28f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V29b ) @ V30b0 ) @ V31b1 ) @ V32b2 ) @ V33b3 ) @ V34b4 ) ) )
                                  = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V29b ) @ V30b0 ) @ V31b1 ) @ V32b2 ) @ ( ap @ V28f @ V33b3 ) ) @ V34b4 ) ) ) ) ) ) ) ) ) )
    & ! [V35f: $i] :
        ( ( mem @ V35f @ ( arr @ bool @ bool ) )
       => ! [V36b: $i] :
            ( ( mem @ V36b @ bool )
           => ! [V37b0: $i] :
                ( ( mem @ V37b0 @ bool )
               => ! [V38b1: $i] :
                    ( ( mem @ V38b1 @ bool )
                   => ! [V39b2: $i] :
                        ( ( mem @ V39b2 @ bool )
                       => ! [V40b3: $i] :
                            ( ( mem @ V40b3 @ bool )
                           => ! [V41b4: $i] :
                                ( ( mem @ V41b4 @ bool )
                               => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V35f ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V36b ) @ V37b0 ) @ V38b1 ) @ V39b2 ) @ V40b3 ) @ V41b4 ) ) )
                                  = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V36b ) @ V37b0 ) @ V38b1 ) @ V39b2 ) @ V40b3 ) @ ( ap @ V35f @ V41b4 ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__accfupds,axiom,
    ( ! [V0f0: $i] :
        ( ( mem @ V0f0 @ ( arr @ bool @ bool ) )
       => ! [V1f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V0f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f ) ) ) ) )
    & ! [V2f0: $i] :
        ( ( mem @ V2f0 @ ( arr @ bool @ bool ) )
       => ! [V3f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V2f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V3f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V3f ) ) ) ) )
    & ! [V4f0: $i] :
        ( ( mem @ V4f0 @ ( arr @ bool @ bool ) )
       => ! [V5f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V4f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V5f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V5f ) ) ) ) )
    & ! [V6f0: $i] :
        ( ( mem @ V6f0 @ ( arr @ bool @ bool ) )
       => ! [V7f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V6f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V7f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V7f ) ) ) ) )
    & ! [V8f0: $i] :
        ( ( mem @ V8f0 @ ( arr @ bool @ bool ) )
       => ! [V9f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V8f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V9f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V9f ) ) ) ) )
    & ! [V10f0: $i] :
        ( ( mem @ V10f0 @ ( arr @ bool @ bool ) )
       => ! [V11f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V10f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V11f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V11f ) ) ) ) )
    & ! [V12f0: $i] :
        ( ( mem @ V12f0 @ ( arr @ bool @ bool ) )
       => ! [V13f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V12f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V13f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V13f ) ) ) ) )
    & ! [V14f0: $i] :
        ( ( mem @ V14f0 @ ( arr @ bool @ bool ) )
       => ! [V15f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V14f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V15f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V15f ) ) ) ) )
    & ! [V16f0: $i] :
        ( ( mem @ V16f0 @ ( arr @ bool @ bool ) )
       => ! [V17f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V16f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V17f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V17f ) ) ) ) )
    & ! [V18f0: $i] :
        ( ( mem @ V18f0 @ ( arr @ bool @ bool ) )
       => ! [V19f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V18f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V19f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V19f ) ) ) ) )
    & ! [V20f0: $i] :
        ( ( mem @ V20f0 @ ( arr @ bool @ bool ) )
       => ! [V21f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V20f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V21f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V21f ) ) ) ) )
    & ! [V22f0: $i] :
        ( ( mem @ V22f0 @ ( arr @ bool @ bool ) )
       => ! [V23f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V22f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V23f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V23f ) ) ) ) )
    & ! [V24f0: $i] :
        ( ( mem @ V24f0 @ ( arr @ bool @ bool ) )
       => ! [V25f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V24f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V25f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V25f ) ) ) ) )
    & ! [V26f0: $i] :
        ( ( mem @ V26f0 @ ( arr @ bool @ bool ) )
       => ! [V27f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V26f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V27f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V27f ) ) ) ) )
    & ! [V28f0: $i] :
        ( ( mem @ V28f0 @ ( arr @ bool @ bool ) )
       => ! [V29f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V28f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V29f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V29f ) ) ) ) )
    & ! [V30f0: $i] :
        ( ( mem @ V30f0 @ ( arr @ bool @ bool ) )
       => ! [V31f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V31f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V31f ) ) ) ) )
    & ! [V32f0: $i] :
        ( ( mem @ V32f0 @ ( arr @ bool @ bool ) )
       => ! [V33f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V32f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V33f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V33f ) ) ) ) )
    & ! [V34f0: $i] :
        ( ( mem @ V34f0 @ ( arr @ bool @ bool ) )
       => ! [V35f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V34f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V35f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V35f ) ) ) ) )
    & ! [V36f0: $i] :
        ( ( mem @ V36f0 @ ( arr @ bool @ bool ) )
       => ! [V37f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V36f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V37f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V37f ) ) ) ) )
    & ! [V38f0: $i] :
        ( ( mem @ V38f0 @ ( arr @ bool @ bool ) )
       => ! [V39f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V38f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V39f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V39f ) ) ) ) )
    & ! [V40f0: $i] :
        ( ( mem @ V40f0 @ ( arr @ bool @ bool ) )
       => ! [V41f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V40f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V41f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V41f ) ) ) ) )
    & ! [V42f0: $i] :
        ( ( mem @ V42f0 @ ( arr @ bool @ bool ) )
       => ! [V43f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V42f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V43f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V43f ) ) ) ) )
    & ! [V44f0: $i] :
        ( ( mem @ V44f0 @ ( arr @ bool @ bool ) )
       => ! [V45f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V44f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V45f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V45f ) ) ) ) )
    & ! [V46f0: $i] :
        ( ( mem @ V46f0 @ ( arr @ bool @ bool ) )
       => ! [V47f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V46f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V47f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V47f ) ) ) ) )
    & ! [V48f0: $i] :
        ( ( mem @ V48f0 @ ( arr @ bool @ bool ) )
       => ! [V49f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V48f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V49f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V49f ) ) ) ) )
    & ! [V50f0: $i] :
        ( ( mem @ V50f0 @ ( arr @ bool @ bool ) )
       => ! [V51f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V50f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V51f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V51f ) ) ) ) )
    & ! [V52f0: $i] :
        ( ( mem @ V52f0 @ ( arr @ bool @ bool ) )
       => ! [V53f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V52f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V53f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V53f ) ) ) ) )
    & ! [V54f0: $i] :
        ( ( mem @ V54f0 @ ( arr @ bool @ bool ) )
       => ! [V55f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V54f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V55f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V55f ) ) ) ) )
    & ! [V56f0: $i] :
        ( ( mem @ V56f0 @ ( arr @ bool @ bool ) )
       => ! [V57f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V56f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V57f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V57f ) ) ) ) )
    & ! [V58f0: $i] :
        ( ( mem @ V58f0 @ ( arr @ bool @ bool ) )
       => ! [V59f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V58f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V59f ) ) ) )
          <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V59f ) ) ) ) )
    & ! [V60f0: $i] :
        ( ( mem @ V60f0 @ ( arr @ bool @ bool ) )
       => ! [V61f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V60f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V61f ) ) ) )
          <=> ( p @ ( ap @ V60f0 @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V61f ) ) ) ) ) )
    & ! [V62f0: $i] :
        ( ( mem @ V62f0 @ ( arr @ bool @ bool ) )
       => ! [V63f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V62f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V63f ) ) ) )
          <=> ( p @ ( ap @ V62f0 @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V63f ) ) ) ) ) )
    & ! [V64f0: $i] :
        ( ( mem @ V64f0 @ ( arr @ bool @ bool ) )
       => ! [V65f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V64f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V65f ) ) ) )
          <=> ( p @ ( ap @ V64f0 @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V65f ) ) ) ) ) )
    & ! [V66f0: $i] :
        ( ( mem @ V66f0 @ ( arr @ bool @ bool ) )
       => ! [V67f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V66f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V67f ) ) ) )
          <=> ( p @ ( ap @ V66f0 @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V67f ) ) ) ) ) )
    & ! [V68f0: $i] :
        ( ( mem @ V68f0 @ ( arr @ bool @ bool ) )
       => ! [V69f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V68f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V69f ) ) ) )
          <=> ( p @ ( ap @ V68f0 @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V69f ) ) ) ) ) )
    & ! [V70f0: $i] :
        ( ( mem @ V70f0 @ ( arr @ bool @ bool ) )
       => ! [V71f: tp__ty_2Ebinary__ieee_2Eflags] :
            ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V70f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V71f ) ) ) )
          <=> ( p @ ( ap @ V70f0 @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V71f ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__fupdfupds,axiom,
    ( ! [V0g: $i] :
        ( ( mem @ V0g @ ( arr @ bool @ bool ) )
       => ! [V1f0: $i] :
            ( ( mem @ V1f0 @ ( arr @ bool @ bool ) )
           => ! [V2f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V1f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V2f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V1f0 ) @ V0g ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V2f ) ) ) ) ) )
    & ! [V3g: $i] :
        ( ( mem @ V3g @ ( arr @ bool @ bool ) )
       => ! [V4f0: $i] :
            ( ( mem @ V4f0 @ ( arr @ bool @ bool ) )
           => ! [V5f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V4f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V3g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V5f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V4f0 ) @ V3g ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V5f ) ) ) ) ) )
    & ! [V6g: $i] :
        ( ( mem @ V6g @ ( arr @ bool @ bool ) )
       => ! [V7f0: $i] :
            ( ( mem @ V7f0 @ ( arr @ bool @ bool ) )
           => ! [V8f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V7f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V6g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V8f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V7f0 ) @ V6g ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V8f ) ) ) ) ) )
    & ! [V9g: $i] :
        ( ( mem @ V9g @ ( arr @ bool @ bool ) )
       => ! [V10f0: $i] :
            ( ( mem @ V10f0 @ ( arr @ bool @ bool ) )
           => ! [V11f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V10f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V9g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V11f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V10f0 ) @ V9g ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V11f ) ) ) ) ) )
    & ! [V12g: $i] :
        ( ( mem @ V12g @ ( arr @ bool @ bool ) )
       => ! [V13f0: $i] :
            ( ( mem @ V13f0 @ ( arr @ bool @ bool ) )
           => ! [V14f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V13f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V12g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V14f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V13f0 ) @ V12g ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V14f ) ) ) ) ) )
    & ! [V15g: $i] :
        ( ( mem @ V15g @ ( arr @ bool @ bool ) )
       => ! [V16f0: $i] :
            ( ( mem @ V16f0 @ ( arr @ bool @ bool ) )
           => ! [V17f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V16f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V15g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V17f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V16f0 ) @ V15g ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V17f ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__fupdfupds__comp,axiom,
    ! [A_27a: del] :
      ( ! [V0g: $i] :
          ( ( mem @ V0g @ ( arr @ bool @ bool ) )
         => ! [V1f0: $i] :
              ( ( mem @ V1f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V1f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) )
                = ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V1f0 ) @ V0g ) ) ) ) )
      & ! [V2h: $i] :
          ( ( mem @ V2h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V3g: $i] :
              ( ( mem @ V3g @ ( arr @ bool @ bool ) )
             => ! [V4f0: $i] :
                  ( ( mem @ V4f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V4f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) ) @ V2h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V4f0 ) @ V3g ) ) ) @ V2h ) ) ) ) )
      & ! [V5g: $i] :
          ( ( mem @ V5g @ ( arr @ bool @ bool ) )
         => ! [V6f0: $i] :
              ( ( mem @ V6f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V6f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V5g ) )
                = ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V6f0 ) @ V5g ) ) ) ) )
      & ! [V7h: $i] :
          ( ( mem @ V7h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V8g: $i] :
              ( ( mem @ V8g @ ( arr @ bool @ bool ) )
             => ! [V9f0: $i] :
                  ( ( mem @ V9f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V9f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V8g ) ) @ V7h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V9f0 ) @ V8g ) ) ) @ V7h ) ) ) ) )
      & ! [V10g: $i] :
          ( ( mem @ V10g @ ( arr @ bool @ bool ) )
         => ! [V11f0: $i] :
              ( ( mem @ V11f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V11f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V10g ) )
                = ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V11f0 ) @ V10g ) ) ) ) )
      & ! [V12h: $i] :
          ( ( mem @ V12h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V13g: $i] :
              ( ( mem @ V13g @ ( arr @ bool @ bool ) )
             => ! [V14f0: $i] :
                  ( ( mem @ V14f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V13g ) ) @ V12h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V14f0 ) @ V13g ) ) ) @ V12h ) ) ) ) )
      & ! [V15g: $i] :
          ( ( mem @ V15g @ ( arr @ bool @ bool ) )
         => ! [V16f0: $i] :
              ( ( mem @ V16f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V15g ) )
                = ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V16f0 ) @ V15g ) ) ) ) )
      & ! [V17h: $i] :
          ( ( mem @ V17h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V18g: $i] :
              ( ( mem @ V18g @ ( arr @ bool @ bool ) )
             => ! [V19f0: $i] :
                  ( ( mem @ V19f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V19f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V18g ) ) @ V17h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V19f0 ) @ V18g ) ) ) @ V17h ) ) ) ) )
      & ! [V20g: $i] :
          ( ( mem @ V20g @ ( arr @ bool @ bool ) )
         => ! [V21f0: $i] :
              ( ( mem @ V21f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V21f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V20g ) )
                = ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V21f0 ) @ V20g ) ) ) ) )
      & ! [V22h: $i] :
          ( ( mem @ V22h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V23g: $i] :
              ( ( mem @ V23g @ ( arr @ bool @ bool ) )
             => ! [V24f0: $i] :
                  ( ( mem @ V24f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V24f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V23g ) ) @ V22h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V24f0 ) @ V23g ) ) ) @ V22h ) ) ) ) )
      & ! [V25g: $i] :
          ( ( mem @ V25g @ ( arr @ bool @ bool ) )
         => ! [V26f0: $i] :
              ( ( mem @ V26f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V26f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V25g ) )
                = ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V26f0 ) @ V25g ) ) ) ) )
      & ! [V27h: $i] :
          ( ( mem @ V27h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V28g: $i] :
              ( ( mem @ V28g @ ( arr @ bool @ bool ) )
             => ! [V29f0: $i] :
                  ( ( mem @ V29f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V29f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V28g ) ) @ V27h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ bool @ bool @ bool ) @ V29f0 ) @ V28g ) ) ) @ V27h ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__fupdcanon,axiom,
    ( ! [V0g: $i] :
        ( ( mem @ V0g @ ( arr @ bool @ bool ) )
       => ! [V1f0: $i] :
            ( ( mem @ V1f0 @ ( arr @ bool @ bool ) )
           => ! [V2f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V2f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V2f ) ) ) ) ) ) )
    & ! [V3g: $i] :
        ( ( mem @ V3g @ ( arr @ bool @ bool ) )
       => ! [V4f0: $i] :
            ( ( mem @ V4f0 @ ( arr @ bool @ bool ) )
           => ! [V5f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V4f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V5f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V4f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V5f ) ) ) ) ) ) )
    & ! [V6g: $i] :
        ( ( mem @ V6g @ ( arr @ bool @ bool ) )
       => ! [V7f0: $i] :
            ( ( mem @ V7f0 @ ( arr @ bool @ bool ) )
           => ! [V8f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V7f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V6g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V8f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V6g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V7f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V8f ) ) ) ) ) ) )
    & ! [V9g: $i] :
        ( ( mem @ V9g @ ( arr @ bool @ bool ) )
       => ! [V10f0: $i] :
            ( ( mem @ V10f0 @ ( arr @ bool @ bool ) )
           => ! [V11f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V10f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V9g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V11f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V9g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V10f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V11f ) ) ) ) ) ) )
    & ! [V12g: $i] :
        ( ( mem @ V12g @ ( arr @ bool @ bool ) )
       => ! [V13f0: $i] :
            ( ( mem @ V13f0 @ ( arr @ bool @ bool ) )
           => ! [V14f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V13f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V12g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V14f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V12g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V13f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V14f ) ) ) ) ) ) )
    & ! [V15g: $i] :
        ( ( mem @ V15g @ ( arr @ bool @ bool ) )
       => ! [V16f0: $i] :
            ( ( mem @ V16f0 @ ( arr @ bool @ bool ) )
           => ! [V17f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V15g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V17f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V15g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V17f ) ) ) ) ) ) )
    & ! [V18g: $i] :
        ( ( mem @ V18g @ ( arr @ bool @ bool ) )
       => ! [V19f0: $i] :
            ( ( mem @ V19f0 @ ( arr @ bool @ bool ) )
           => ! [V20f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V19f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V20f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V19f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V20f ) ) ) ) ) ) )
    & ! [V21g: $i] :
        ( ( mem @ V21g @ ( arr @ bool @ bool ) )
       => ! [V22f0: $i] :
            ( ( mem @ V22f0 @ ( arr @ bool @ bool ) )
           => ! [V23f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V22f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V21g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V23f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V21g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V22f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V23f ) ) ) ) ) ) )
    & ! [V24g: $i] :
        ( ( mem @ V24g @ ( arr @ bool @ bool ) )
       => ! [V25f0: $i] :
            ( ( mem @ V25f0 @ ( arr @ bool @ bool ) )
           => ! [V26f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V25f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V24g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V26f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V24g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V25f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V26f ) ) ) ) ) ) )
    & ! [V27g: $i] :
        ( ( mem @ V27g @ ( arr @ bool @ bool ) )
       => ! [V28f0: $i] :
            ( ( mem @ V28f0 @ ( arr @ bool @ bool ) )
           => ! [V29f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V28f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V27g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V29f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V27g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V28f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V29f ) ) ) ) ) ) )
    & ! [V30g: $i] :
        ( ( mem @ V30g @ ( arr @ bool @ bool ) )
       => ! [V31f0: $i] :
            ( ( mem @ V31f0 @ ( arr @ bool @ bool ) )
           => ! [V32f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V31f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V32f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V31f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V32f ) ) ) ) ) ) )
    & ! [V33g: $i] :
        ( ( mem @ V33g @ ( arr @ bool @ bool ) )
       => ! [V34f0: $i] :
            ( ( mem @ V34f0 @ ( arr @ bool @ bool ) )
           => ! [V35f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V34f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V33g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V35f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V33g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V34f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V35f ) ) ) ) ) ) )
    & ! [V36g: $i] :
        ( ( mem @ V36g @ ( arr @ bool @ bool ) )
       => ! [V37f0: $i] :
            ( ( mem @ V37f0 @ ( arr @ bool @ bool ) )
           => ! [V38f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V37f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V36g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V38f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V36g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V37f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V38f ) ) ) ) ) ) )
    & ! [V39g: $i] :
        ( ( mem @ V39g @ ( arr @ bool @ bool ) )
       => ! [V40f0: $i] :
            ( ( mem @ V40f0 @ ( arr @ bool @ bool ) )
           => ! [V41f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V40f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V39g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V41f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V39g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V40f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V41f ) ) ) ) ) ) )
    & ! [V42g: $i] :
        ( ( mem @ V42g @ ( arr @ bool @ bool ) )
       => ! [V43f0: $i] :
            ( ( mem @ V43f0 @ ( arr @ bool @ bool ) )
           => ! [V44f: tp__ty_2Ebinary__ieee_2Eflags] :
                ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V43f0 ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V42g ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V44f ) ) ) )
                = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V42g ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V43f0 ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V44f ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__fupdcanon__comp,axiom,
    ! [A_27a: del] :
      ( ! [V0g: $i] :
          ( ( mem @ V0g @ ( arr @ bool @ bool ) )
         => ! [V1f0: $i] :
              ( ( mem @ V1f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V0g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V1f0 ) ) ) ) )
      & ! [V2h: $i] :
          ( ( mem @ V2h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V3g: $i] :
              ( ( mem @ V3g @ ( arr @ bool @ bool ) )
             => ! [V4f0: $i] :
                  ( ( mem @ V4f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V4f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) ) @ V2h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V3g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V4f0 ) ) @ V2h ) ) ) ) ) )
      & ! [V5g: $i] :
          ( ( mem @ V5g @ ( arr @ bool @ bool ) )
         => ! [V6f0: $i] :
              ( ( mem @ V6f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V6f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V5g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V5g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V6f0 ) ) ) ) )
      & ! [V7h: $i] :
          ( ( mem @ V7h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V8g: $i] :
              ( ( mem @ V8g @ ( arr @ bool @ bool ) )
             => ! [V9f0: $i] :
                  ( ( mem @ V9f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V9f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V8g ) ) @ V7h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V8g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V9f0 ) ) @ V7h ) ) ) ) ) )
      & ! [V10g: $i] :
          ( ( mem @ V10g @ ( arr @ bool @ bool ) )
         => ! [V11f0: $i] :
              ( ( mem @ V11f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V11f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V10g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V10g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V11f0 ) ) ) ) )
      & ! [V12h: $i] :
          ( ( mem @ V12h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V13g: $i] :
              ( ( mem @ V13g @ ( arr @ bool @ bool ) )
             => ! [V14f0: $i] :
                  ( ( mem @ V14f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V13g ) ) @ V12h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V13g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V14f0 ) ) @ V12h ) ) ) ) ) )
      & ! [V15g: $i] :
          ( ( mem @ V15g @ ( arr @ bool @ bool ) )
         => ! [V16f0: $i] :
              ( ( mem @ V16f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V15g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V15g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V16f0 ) ) ) ) )
      & ! [V17h: $i] :
          ( ( mem @ V17h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V18g: $i] :
              ( ( mem @ V18g @ ( arr @ bool @ bool ) )
             => ! [V19f0: $i] :
                  ( ( mem @ V19f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V19f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g ) ) @ V17h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V18g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V19f0 ) ) @ V17h ) ) ) ) ) )
      & ! [V20g: $i] :
          ( ( mem @ V20g @ ( arr @ bool @ bool ) )
         => ! [V21f0: $i] :
              ( ( mem @ V21f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V21f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V20g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V20g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V21f0 ) ) ) ) )
      & ! [V22h: $i] :
          ( ( mem @ V22h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V23g: $i] :
              ( ( mem @ V23g @ ( arr @ bool @ bool ) )
             => ! [V24f0: $i] :
                  ( ( mem @ V24f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V24f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V23g ) ) @ V22h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V23g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V24f0 ) ) @ V22h ) ) ) ) ) )
      & ! [V25g: $i] :
          ( ( mem @ V25g @ ( arr @ bool @ bool ) )
         => ! [V26f0: $i] :
              ( ( mem @ V26f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V26f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V25g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V25g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V26f0 ) ) ) ) )
      & ! [V27h: $i] :
          ( ( mem @ V27h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V28g: $i] :
              ( ( mem @ V28g @ ( arr @ bool @ bool ) )
             => ! [V29f0: $i] :
                  ( ( mem @ V29f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V29f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V28g ) ) @ V27h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V28g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V29f0 ) ) @ V27h ) ) ) ) ) )
      & ! [V30g: $i] :
          ( ( mem @ V30g @ ( arr @ bool @ bool ) )
         => ! [V31f0: $i] :
              ( ( mem @ V31f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V31f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V30g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V31f0 ) ) ) ) )
      & ! [V32h: $i] :
          ( ( mem @ V32h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V33g: $i] :
              ( ( mem @ V33g @ ( arr @ bool @ bool ) )
             => ! [V34f0: $i] :
                  ( ( mem @ V34f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V34f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V33g ) ) @ V32h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V33g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V34f0 ) ) @ V32h ) ) ) ) ) )
      & ! [V35g: $i] :
          ( ( mem @ V35g @ ( arr @ bool @ bool ) )
         => ! [V36f0: $i] :
              ( ( mem @ V36f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V36f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V35g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V35g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V36f0 ) ) ) ) )
      & ! [V37h: $i] :
          ( ( mem @ V37h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V38g: $i] :
              ( ( mem @ V38g @ ( arr @ bool @ bool ) )
             => ! [V39f0: $i] :
                  ( ( mem @ V39f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V39f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V38g ) ) @ V37h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V38g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V39f0 ) ) @ V37h ) ) ) ) ) )
      & ! [V40g: $i] :
          ( ( mem @ V40g @ ( arr @ bool @ bool ) )
         => ! [V41f0: $i] :
              ( ( mem @ V41f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V41f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V40g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V40g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V41f0 ) ) ) ) )
      & ! [V42h: $i] :
          ( ( mem @ V42h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V43g: $i] :
              ( ( mem @ V43g @ ( arr @ bool @ bool ) )
             => ! [V44f0: $i] :
                  ( ( mem @ V44f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V44f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V43g ) ) @ V42h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V43g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V44f0 ) ) @ V42h ) ) ) ) ) )
      & ! [V45g: $i] :
          ( ( mem @ V45g @ ( arr @ bool @ bool ) )
         => ! [V46f0: $i] :
              ( ( mem @ V46f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V46f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V45g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V45g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V46f0 ) ) ) ) )
      & ! [V47h: $i] :
          ( ( mem @ V47h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V48g: $i] :
              ( ( mem @ V48g @ ( arr @ bool @ bool ) )
             => ! [V49f0: $i] :
                  ( ( mem @ V49f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V49f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V48g ) ) @ V47h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V48g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V49f0 ) ) @ V47h ) ) ) ) ) )
      & ! [V50g: $i] :
          ( ( mem @ V50g @ ( arr @ bool @ bool ) )
         => ! [V51f0: $i] :
              ( ( mem @ V51f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V51f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V50g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V50g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V51f0 ) ) ) ) )
      & ! [V52h: $i] :
          ( ( mem @ V52h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V53g: $i] :
              ( ( mem @ V53g @ ( arr @ bool @ bool ) )
             => ! [V54f0: $i] :
                  ( ( mem @ V54f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V54f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V53g ) ) @ V52h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ V53g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V54f0 ) ) @ V52h ) ) ) ) ) )
      & ! [V55g: $i] :
          ( ( mem @ V55g @ ( arr @ bool @ bool ) )
         => ! [V56f0: $i] :
              ( ( mem @ V56f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V56f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V55g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V55g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V56f0 ) ) ) ) )
      & ! [V57h: $i] :
          ( ( mem @ V57h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V58g: $i] :
              ( ( mem @ V58g @ ( arr @ bool @ bool ) )
             => ! [V59f0: $i] :
                  ( ( mem @ V59f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V59f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V58g ) ) @ V57h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ V58g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V59f0 ) ) @ V57h ) ) ) ) ) )
      & ! [V60g: $i] :
          ( ( mem @ V60g @ ( arr @ bool @ bool ) )
         => ! [V61f0: $i] :
              ( ( mem @ V61f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V61f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V60g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V60g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V61f0 ) ) ) ) )
      & ! [V62h: $i] :
          ( ( mem @ V62h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V63g: $i] :
              ( ( mem @ V63g @ ( arr @ bool @ bool ) )
             => ! [V64f0: $i] :
                  ( ( mem @ V64f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V64f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V63g ) ) @ V62h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ V63g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V64f0 ) ) @ V62h ) ) ) ) ) )
      & ! [V65g: $i] :
          ( ( mem @ V65g @ ( arr @ bool @ bool ) )
         => ! [V66f0: $i] :
              ( ( mem @ V66f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V66f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V65g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V65g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V66f0 ) ) ) ) )
      & ! [V67h: $i] :
          ( ( mem @ V67h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V68g: $i] :
              ( ( mem @ V68g @ ( arr @ bool @ bool ) )
             => ! [V69f0: $i] :
                  ( ( mem @ V69f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V69f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V68g ) ) @ V67h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ V68g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V69f0 ) ) @ V67h ) ) ) ) ) )
      & ! [V70g: $i] :
          ( ( mem @ V70g @ ( arr @ bool @ bool ) )
         => ! [V71f0: $i] :
              ( ( mem @ V71f0 @ ( arr @ bool @ bool ) )
             => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V71f0 ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V70g ) )
                = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V70g ) ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V71f0 ) ) ) ) )
      & ! [V72h: $i] :
          ( ( mem @ V72h @ ( arr @ A_27a @ ty_2Ebinary__ieee_2Eflags ) )
         => ! [V73g: $i] :
              ( ( mem @ V73g @ ( arr @ bool @ bool ) )
             => ! [V74f0: $i] :
                  ( ( mem @ V74f0 @ ( arr @ bool @ bool ) )
                 => ( ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V74f0 ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V73g ) ) @ V72h ) )
                    = ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ V73g ) ) @ ( ap @ ( ap @ ( c_2Ecombin_2Eo @ A_27a @ ty_2Ebinary__ieee_2Eflags @ ty_2Ebinary__ieee_2Eflags ) @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ V74f0 ) ) @ V72h ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__component__equality,axiom,
    ! [V0f1: tp__ty_2Ebinary__ieee_2Eflags,V1f2: tp__ty_2Ebinary__ieee_2Eflags] :
      ( ( V0f1 = V1f2 )
    <=> ( ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f1 ) ) )
        <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f2 ) ) ) )
        & ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f1 ) ) )
        <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f2 ) ) ) )
        & ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f1 ) ) )
        <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f2 ) ) ) )
        & ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f1 ) ) )
        <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f2 ) ) ) )
        & ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f1 ) ) )
        <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f2 ) ) ) )
        & ( ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f1 ) ) )
        <=> ( p @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f2 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__updates__eq__literal,axiom,
    ! [V0f: tp__ty_2Ebinary__ieee_2Eflags,V1b4: $i] :
      ( ( mem @ V1b4 @ bool )
     => ! [V2b3: $i] :
          ( ( mem @ V2b3 @ bool )
         => ! [V3b2: $i] :
              ( ( mem @ V3b2 @ bool )
             => ! [V4b1: $i] :
                  ( ( mem @ V4b1 @ bool )
                 => ! [V5b0: $i] :
                      ( ( mem @ V5b0 @ bool )
                     => ! [V6b: $i] :
                          ( ( mem @ V6b @ bool )
                         => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V1b4 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V2b3 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V3b2 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V4b1 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5b0 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V6b ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0f ) ) ) ) ) ) ) )
                            = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V1b4 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V2b3 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V3b2 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V4b1 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5b0 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V6b ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__literal__nchotomy,axiom,
    ! [V0f: tp__ty_2Ebinary__ieee_2Eflags] :
    ? [V1b4: $i] :
      ( ( mem @ V1b4 @ bool )
      & ? [V2b3: $i] :
          ( ( mem @ V2b3 @ bool )
          & ? [V3b2: $i] :
              ( ( mem @ V3b2 @ bool )
              & ? [V4b1: $i] :
                  ( ( mem @ V4b1 @ bool )
                  & ? [V5b0: $i] :
                      ( ( mem @ V5b0 @ bool )
                      & ? [V6b: $i] :
                          ( ( mem @ V6b @ bool )
                          & ( V0f
                            = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V1b4 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V2b3 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V3b2 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V4b1 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5b0 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V6b ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2EFORALL__flags,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) )
     => ( ! [V1f: tp__ty_2Ebinary__ieee_2Eflags] : ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f ) ) )
      <=> ! [V2b4: $i] :
            ( ( mem @ V2b4 @ bool )
           => ! [V3b3: $i] :
                ( ( mem @ V3b3 @ bool )
               => ! [V4b2: $i] :
                    ( ( mem @ V4b2 @ bool )
                   => ! [V5b1: $i] :
                        ( ( mem @ V5b1 @ bool )
                       => ! [V6b0: $i] :
                            ( ( mem @ V6b0 @ bool )
                           => ! [V7b: $i] :
                                ( ( mem @ V7b @ bool )
                               => ( p @ ( ap @ V0P @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V2b4 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V3b3 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V4b2 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5b1 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V6b0 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V7b ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2EEXISTS__flags,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) )
     => ( ? [V1f: tp__ty_2Ebinary__ieee_2Eflags] : ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1f ) ) )
      <=> ? [V2b4: $i] :
            ( ( mem @ V2b4 @ bool )
            & ? [V3b3: $i] :
                ( ( mem @ V3b3 @ bool )
                & ? [V4b2: $i] :
                    ( ( mem @ V4b2 @ bool )
                    & ? [V5b1: $i] :
                        ( ( mem @ V5b1 @ bool )
                        & ? [V6b0: $i] :
                            ( ( mem @ V6b0 @ bool )
                            & ? [V7b: $i] :
                                ( ( mem @ V7b @ bool )
                                & ( p @ ( ap @ V0P @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V2b4 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V3b3 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V4b2 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5b1 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V6b0 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V7b ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__literal__11,axiom,
    ! [V0b41: $i] :
      ( ( mem @ V0b41 @ bool )
     => ! [V1b31: $i] :
          ( ( mem @ V1b31 @ bool )
         => ! [V2b21: $i] :
              ( ( mem @ V2b21 @ bool )
             => ! [V3b11: $i] :
                  ( ( mem @ V3b11 @ bool )
                 => ! [V4b01: $i] :
                      ( ( mem @ V4b01 @ bool )
                     => ! [V5b1: $i] :
                          ( ( mem @ V5b1 @ bool )
                         => ! [V6b42: $i] :
                              ( ( mem @ V6b42 @ bool )
                             => ! [V7b32: $i] :
                                  ( ( mem @ V7b32 @ bool )
                                 => ! [V8b22: $i] :
                                      ( ( mem @ V8b22 @ bool )
                                     => ! [V9b12: $i] :
                                          ( ( mem @ V9b12 @ bool )
                                         => ! [V10b02: $i] :
                                              ( ( mem @ V10b02 @ bool )
                                             => ! [V11b2: $i] :
                                                  ( ( mem @ V11b2 @ bool )
                                                 => ( ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V0b41 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V1b31 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V2b21 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V3b11 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V4b01 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5b1 ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) )
                                                      = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V6b42 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V7b32 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V8b22 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V9b12 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V10b02 ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V11b2 ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) )
                                                  <=> ( ( ( p @ V0b41 )
                                                      <=> ( p @ V6b42 ) )
                                                      & ( ( p @ V1b31 )
                                                      <=> ( p @ V7b32 ) )
                                                      & ( ( p @ V2b21 )
                                                      <=> ( p @ V8b22 ) )
                                                      & ( ( p @ V3b11 )
                                                      <=> ( p @ V9b12 ) )
                                                      & ( ( p @ V4b01 )
                                                      <=> ( p @ V10b02 ) )
                                                      & ( ( p @ V5b1 )
                                                      <=> ( p @ V11b2 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Edatatype__flags,axiom,
    ! [V0record: $i] :
      ( ( mem @ V0record @ ( arr @ ty_2Ebinary__ieee_2Eflags @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ bool ) ) ) ) ) ) ) )
     => ! [V1flags: tp__ty_2Ebinary__ieee_2Eflags,V2DivideByZero: $i] :
          ( ( mem @ V2DivideByZero @ bool )
         => ! [V3InvalidOp: $i] :
              ( ( mem @ V3InvalidOp @ bool )
             => ! [V4Overflow: $i] :
                  ( ( mem @ V4Overflow @ bool )
                 => ! [V5Precision: $i] :
                      ( ( mem @ V5Precision @ bool )
                     => ! [V6Underflow__BeforeRounding: $i] :
                          ( ( mem @ V6Underflow__BeforeRounding @ bool )
                         => ! [V7Underflow__AfterRounding: $i] :
                              ( ( mem @ V7Underflow__AfterRounding @ bool )
                             => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V0record @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1flags ) ) @ V2DivideByZero ) @ V3InvalidOp ) @ V4Overflow ) @ V5Precision ) @ V6Underflow__BeforeRounding ) @ V7Underflow__AfterRounding ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__11,axiom,
    ! [V0a0: $i] :
      ( ( mem @ V0a0 @ bool )
     => ! [V1a1: $i] :
          ( ( mem @ V1a1 @ bool )
         => ! [V2a2: $i] :
              ( ( mem @ V2a2 @ bool )
             => ! [V3a3: $i] :
                  ( ( mem @ V3a3 @ bool )
                 => ! [V4a4: $i] :
                      ( ( mem @ V4a4 @ bool )
                     => ! [V5a5: $i] :
                          ( ( mem @ V5a5 @ bool )
                         => ! [V6a0_27: $i] :
                              ( ( mem @ V6a0_27 @ bool )
                             => ! [V7a1_27: $i] :
                                  ( ( mem @ V7a1_27 @ bool )
                                 => ! [V8a2_27: $i] :
                                      ( ( mem @ V8a2_27 @ bool )
                                     => ! [V9a3_27: $i] :
                                          ( ( mem @ V9a3_27 @ bool )
                                         => ! [V10a4_27: $i] :
                                              ( ( mem @ V10a4_27 @ bool )
                                             => ! [V11a5_27: $i] :
                                                  ( ( mem @ V11a5_27 @ bool )
                                                 => ( ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V0a0 ) @ V1a1 ) @ V2a2 ) @ V3a3 ) @ V4a4 ) @ V5a5 ) )
                                                      = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V6a0_27 ) @ V7a1_27 ) @ V8a2_27 ) @ V9a3_27 ) @ V10a4_27 ) @ V11a5_27 ) ) )
                                                  <=> ( ( ( p @ V0a0 )
                                                      <=> ( p @ V6a0_27 ) )
                                                      & ( ( p @ V1a1 )
                                                      <=> ( p @ V7a1_27 ) )
                                                      & ( ( p @ V2a2 )
                                                      <=> ( p @ V8a2_27 ) )
                                                      & ( ( p @ V3a3 )
                                                      <=> ( p @ V9a3_27 ) )
                                                      & ( ( p @ V4a4 )
                                                      <=> ( p @ V10a4_27 ) )
                                                      & ( ( p @ V5a5 )
                                                      <=> ( p @ V11a5_27 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__nchotomy,axiom,
    ! [V0ff: tp__ty_2Ebinary__ieee_2Eflags] :
    ? [V1b: $i] :
      ( ( mem @ V1b @ bool )
      & ? [V2b0: $i] :
          ( ( mem @ V2b0 @ bool )
          & ? [V3b1: $i] :
              ( ( mem @ V3b1 @ bool )
              & ? [V4b2: $i] :
                  ( ( mem @ V4b2 @ bool )
                  & ? [V5b3: $i] :
                      ( ( mem @ V5b3 @ bool )
                      & ? [V6b4: $i] :
                          ( ( mem @ V6b4 @ bool )
                          & ( V0ff
                            = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__Axiom,axiom,
    ! [A_27a: del,V0f: $i] :
      ( ( mem @ V0f @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ A_27a ) ) ) ) ) ) )
     => ? [V1fn: $i] :
          ( ( mem @ V1fn @ ( arr @ ty_2Ebinary__ieee_2Eflags @ A_27a ) )
          & ! [V2a0: $i] :
              ( ( mem @ V2a0 @ bool )
             => ! [V3a1: $i] :
                  ( ( mem @ V3a1 @ bool )
                 => ! [V4a2: $i] :
                      ( ( mem @ V4a2 @ bool )
                     => ! [V5a3: $i] :
                          ( ( mem @ V5a3 @ bool )
                         => ! [V6a4: $i] :
                              ( ( mem @ V6a4 @ bool )
                             => ! [V7a5: $i] :
                                  ( ( mem @ V7a5 @ bool )
                                 => ( ( ap @ V1fn @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V2a0 ) @ V3a1 ) @ V4a2 ) @ V5a3 ) @ V6a4 ) @ V7a5 ) )
                                    = ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V0f @ V2a0 ) @ V3a1 ) @ V4a2 ) @ V5a3 ) @ V6a4 ) @ V7a5 ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__induction,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Ebinary__ieee_2Eflags @ bool ) )
     => ( ! [V1b: $i] :
            ( ( mem @ V1b @ bool )
           => ! [V2b0: $i] :
                ( ( mem @ V2b0 @ bool )
               => ! [V3b1: $i] :
                    ( ( mem @ V3b1 @ bool )
                   => ! [V4b2: $i] :
                        ( ( mem @ V4b2 @ bool )
                       => ! [V5b3: $i] :
                            ( ( mem @ V5b3 @ bool )
                           => ! [V6b4: $i] :
                                ( ( mem @ V6b4 @ bool )
                               => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V1b ) @ V2b0 ) @ V3b1 ) @ V4b2 ) @ V5b3 ) @ V6b4 ) ) ) ) ) ) ) ) )
       => ! [V7f: tp__ty_2Ebinary__ieee_2Eflags] : ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Eflags @ V7f ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__case__cong,axiom,
    ! [A_27a: del,V0f_27: $i] :
      ( ( mem @ V0f_27 @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ A_27a ) ) ) ) ) ) )
     => ! [V1M: tp__ty_2Ebinary__ieee_2Eflags,V2M_27: tp__ty_2Ebinary__ieee_2Eflags,V3f: $i] :
          ( ( mem @ V3f @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ A_27a ) ) ) ) ) ) )
         => ( ( ( V1M = V2M_27 )
              & ! [V4a0: $i] :
                  ( ( mem @ V4a0 @ bool )
                 => ! [V5a1: $i] :
                      ( ( mem @ V5a1 @ bool )
                     => ! [V6a2: $i] :
                          ( ( mem @ V6a2 @ bool )
                         => ! [V7a3: $i] :
                              ( ( mem @ V7a3 @ bool )
                             => ! [V8a4: $i] :
                                  ( ( mem @ V8a4 @ bool )
                                 => ! [V9a5: $i] :
                                      ( ( mem @ V9a5 @ bool )
                                     => ( ( V2M_27
                                          = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V4a0 ) @ V5a1 ) @ V6a2 ) @ V7a3 ) @ V8a4 ) @ V9a5 ) ) )
                                       => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V3f @ V4a0 ) @ V5a1 ) @ V6a2 ) @ V7a3 ) @ V8a4 ) @ V9a5 )
                                          = ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V0f_27 @ V4a0 ) @ V5a1 ) @ V6a2 ) @ V7a3 ) @ V8a4 ) @ V9a5 ) ) ) ) ) ) ) ) ) )
           => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V1M ) ) @ V3f )
              = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V2M_27 ) ) @ V0f_27 ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eflags__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Eflags,V1f: $i] :
      ( ( mem @ V1f @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ ( arr @ bool @ A_27a ) ) ) ) ) ) )
     => ! [V2v: $i] :
          ( ( mem @ V2v @ A_27a )
         => ( ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eflags__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ V0x ) ) @ V1f )
              = V2v )
          <=> ? [V3b: $i] :
                ( ( mem @ V3b @ bool )
                & ? [V4b0: $i] :
                    ( ( mem @ V4b0 @ bool )
                    & ? [V5b1: $i] :
                        ( ( mem @ V5b1 @ bool )
                        & ? [V6b2: $i] :
                            ( ( mem @ V6b2 @ bool )
                            & ? [V7b3: $i] :
                                ( ( mem @ V7b3 @ bool )
                                & ? [V8b4: $i] :
                                    ( ( mem @ V8b4 @ bool )
                                    & ( V0x
                                      = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ c_2Ebinary__ieee_2Erecordtype_2Eflags @ V3b ) @ V4b0 ) @ V5b1 ) @ V6b2 ) @ V7b3 ) @ V8b4 ) ) )
                                    & ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V1f @ V3b ) @ V4b0 ) @ V5b1 ) @ V6b2 ) @ V7b3 ) @ V8b4 )
                                      = V2v ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eclear__flags__def,axiom,
    ( fo__c_2Ebinary__ieee_2Eclear__flags
    = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2EF ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2EF ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2EF ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2EF ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2EF ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2EF ) ) @ ( c_2Ebool_2EARB @ ty_2Ebinary__ieee_2Eflags ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Einvalidop__flags__def,axiom,
    ( fo__c_2Ebinary__ieee_2Einvalidop__flags
    = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2ET ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Edividezero__flags__def,axiom,
    ( fo__c_2Ebinary__ieee_2Edividezero__flags
    = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__DivideByZero__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ c_2Ebool_2ET ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Erounding__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ty_2Enum_2Enum ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ty_2Enum_2Enum @ ty_2Ebinary__ieee_2Erounding )
            @ ( lam @ ty_2Enum_2Enum
              @ ^ [V1n: $i] : ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V1n ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Erounding__BIJ,axiom,
    ( ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] :
        ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a ) ) ) )
        = V0a )
    & ! [V1r: tp__ty_2Enum_2Enum] :
        ( ( p
          @ ( ap
            @ ( lam @ ty_2Enum_2Enum
              @ ^ [V2n: $i] : ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V2n ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
            @ ( inj__ty_2Enum_2Enum @ V1r ) ) )
      <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ V1r ) ) ) )
          = V1r ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2rounding__rounding2num,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a ) ) ) )
      = V0a ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding2num__num2rounding,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V0r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ V0r ) ) ) )
        = V0r ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2rounding__11,axiom,
    ! [V0r: tp__ty_2Enum_2Enum,V1r_27: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V0r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V1r_27 ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
       => ( ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ V0r ) ) )
            = ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ V1r_27 ) ) ) )
        <=> ( V0r = V1r_27 ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding2num__11,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding,V1a_27: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a ) ) )
        = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V1a_27 ) ) ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2rounding__ONTO,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] :
    ? [V1r: tp__ty_2Enum_2Enum] :
      ( ( V0a
        = ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ V1r ) ) ) )
      & ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V1r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding2num__ONTO,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V0r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    <=> ? [V1a: tp__ty_2Ebinary__ieee_2Erounding] :
          ( V0r
          = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V1a ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2rounding__thm,axiom,
    ( ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      = fo__c_2Ebinary__ieee_2EroundTiesToEven )
    & ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = fo__c_2Ebinary__ieee_2EroundTowardPositive )
    & ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = fo__c_2Ebinary__ieee_2EroundTowardNegative )
    & ( ( surj__ty_2Ebinary__ieee_2Erounding @ ( ap @ c_2Ebinary__ieee_2Enum2rounding @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      = fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding2num__thm,axiom,
    ( ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTiesToEven ) ) )
      = fo__c_2Enum_2E0 )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardPositive ) ) )
      = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) )
      = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardZero ) ) )
      = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__EQ__rounding,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding,V1a_27: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( V0a = V1a_27 )
    <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a ) ) )
        = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V1a_27 ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Erounding__size__def,axiom,
    ! [V0x: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0x ) ) )
      = fo__c_2Enum_2E0 ) ).

thf(ax_thm_2Ebinary__ieee_2Erounding__CASE,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Erounding,V1v0: $i] :
      ( ( mem @ V1v0 @ A_27a )
     => ! [V2v1: $i] :
          ( ( mem @ V2v1 @ A_27a )
         => ! [V3v2: $i] :
              ( ( mem @ V3v2 @ A_27a )
             => ! [V4v3: $i] :
                  ( ( mem @ V4v3 @ A_27a )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0x ) ) @ V1v0 ) @ V2v1 ) @ V3v2 ) @ V4v3 )
                    = ( ap
                      @ ( lam @ ty_2Enum_2Enum
                        @ ^ [V5m: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ A_27a ) @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V5m ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ V1v0 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ A_27a ) @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V5m ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ V2v1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ A_27a ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Enum_2Enum ) @ V5m ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ V3v2 ) @ V4v3 ) ) ) )
                      @ ( ap @ c_2Ebinary__ieee_2Erounding2num @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0x ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0v0: $i] :
          ( ( mem @ V0v0 @ A_27a )
         => ! [V1v1: $i] :
              ( ( mem @ V1v1 @ A_27a )
             => ! [V2v2: $i] :
                  ( ( mem @ V2v2 @ A_27a )
                 => ! [V3v3: $i] :
                      ( ( mem @ V3v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTiesToEven ) ) @ V0v0 ) @ V1v1 ) @ V2v2 ) @ V3v3 )
                        = V0v0 ) ) ) ) )
      & ! [V4v0: $i] :
          ( ( mem @ V4v0 @ A_27a )
         => ! [V5v1: $i] :
              ( ( mem @ V5v1 @ A_27a )
             => ! [V6v2: $i] :
                  ( ( mem @ V6v2 @ A_27a )
                 => ! [V7v3: $i] :
                      ( ( mem @ V7v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardPositive ) ) @ V4v0 ) @ V5v1 ) @ V6v2 ) @ V7v3 )
                        = V5v1 ) ) ) ) )
      & ! [V8v0: $i] :
          ( ( mem @ V8v0 @ A_27a )
         => ! [V9v1: $i] :
              ( ( mem @ V9v1 @ A_27a )
             => ! [V10v2: $i] :
                  ( ( mem @ V10v2 @ A_27a )
                 => ! [V11v3: $i] :
                      ( ( mem @ V11v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) @ V8v0 ) @ V9v1 ) @ V10v2 ) @ V11v3 )
                        = V10v2 ) ) ) ) )
      & ! [V12v0: $i] :
          ( ( mem @ V12v0 @ A_27a )
         => ! [V13v1: $i] :
              ( ( mem @ V13v1 @ A_27a )
             => ! [V14v2: $i] :
                  ( ( mem @ V14v2 @ A_27a )
                 => ! [V15v3: $i] :
                      ( ( mem @ V15v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardZero ) ) @ V12v0 ) @ V13v1 ) @ V14v2 ) @ V15v3 )
                        = V15v3 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Edatatype__rounding,axiom,
    ! [V0rounding: $i] :
      ( ( mem @ V0rounding @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ty_2Ebinary__ieee_2Erounding @ bool ) ) ) ) )
     => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ ( ap @ V0rounding @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTiesToEven ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardPositive ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__distinct,axiom,
    ( ( fo__c_2Ebinary__ieee_2EroundTiesToEven != fo__c_2Ebinary__ieee_2EroundTowardPositive )
    & ( fo__c_2Ebinary__ieee_2EroundTiesToEven != fo__c_2Ebinary__ieee_2EroundTowardNegative )
    & ( fo__c_2Ebinary__ieee_2EroundTiesToEven != fo__c_2Ebinary__ieee_2EroundTowardZero )
    & ( fo__c_2Ebinary__ieee_2EroundTowardPositive != fo__c_2Ebinary__ieee_2EroundTowardNegative )
    & ( fo__c_2Ebinary__ieee_2EroundTowardPositive != fo__c_2Ebinary__ieee_2EroundTowardZero )
    & ( fo__c_2Ebinary__ieee_2EroundTowardNegative != fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__nchotomy,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( V0a = fo__c_2Ebinary__ieee_2EroundTiesToEven )
      | ( V0a = fo__c_2Ebinary__ieee_2EroundTowardPositive )
      | ( V0a = fo__c_2Ebinary__ieee_2EroundTowardNegative )
      | ( V0a = fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__Axiom,axiom,
    ! [A_27a: del,V0x0: $i] :
      ( ( mem @ V0x0 @ A_27a )
     => ! [V1x1: $i] :
          ( ( mem @ V1x1 @ A_27a )
         => ! [V2x2: $i] :
              ( ( mem @ V2x2 @ A_27a )
             => ! [V3x3: $i] :
                  ( ( mem @ V3x3 @ A_27a )
                 => ? [V4f: $i] :
                      ( ( mem @ V4f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ A_27a ) )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTiesToEven ) )
                        = V0x0 )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardPositive ) )
                        = V1x1 )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) )
                        = V2x2 )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardZero ) )
                        = V3x3 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__induction,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Ebinary__ieee_2Erounding @ bool ) )
     => ( ( ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTiesToEven ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardPositive ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardZero ) ) ) )
       => ! [V1a: tp__ty_2Ebinary__ieee_2Erounding] : ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Erounding @ V1a ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__case__cong,axiom,
    ! [A_27a: del,V0v0_27: $i] :
      ( ( mem @ V0v0_27 @ A_27a )
     => ! [V1v1_27: $i] :
          ( ( mem @ V1v1_27 @ A_27a )
         => ! [V2v2_27: $i] :
              ( ( mem @ V2v2_27 @ A_27a )
             => ! [V3v3_27: $i] :
                  ( ( mem @ V3v3_27 @ A_27a )
                 => ! [V4M: tp__ty_2Ebinary__ieee_2Erounding,V5M_27: tp__ty_2Ebinary__ieee_2Erounding,V6v0: $i] :
                      ( ( mem @ V6v0 @ A_27a )
                     => ! [V7v1: $i] :
                          ( ( mem @ V7v1 @ A_27a )
                         => ! [V8v2: $i] :
                              ( ( mem @ V8v2 @ A_27a )
                             => ! [V9v3: $i] :
                                  ( ( mem @ V9v3 @ A_27a )
                                 => ( ( ( V4M = V5M_27 )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTiesToEven )
                                       => ( V6v0 = V0v0_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTowardPositive )
                                       => ( V7v1 = V1v1_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTowardNegative )
                                       => ( V8v2 = V2v2_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EroundTowardZero )
                                       => ( V9v3 = V3v3_27 ) ) )
                                   => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V4M ) ) @ V6v0 ) @ V7v1 ) @ V8v2 ) @ V9v3 )
                                      = ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V5M_27 ) ) @ V0v0_27 ) @ V1v1_27 ) @ V2v2_27 ) @ V3v3_27 ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Erounding__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Erounding,V1v0: $i] :
      ( ( mem @ V1v0 @ A_27a )
     => ! [V2v1: $i] :
          ( ( mem @ V2v1 @ A_27a )
         => ! [V3v2: $i] :
              ( ( mem @ V3v2 @ A_27a )
             => ! [V4v3: $i] :
                  ( ( mem @ V4v3 @ A_27a )
                 => ! [V5v: $i] :
                      ( ( mem @ V5v @ A_27a )
                     => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0x ) ) @ V1v0 ) @ V2v1 ) @ V3v2 ) @ V4v3 )
                          = V5v )
                      <=> ( ( ( V0x = fo__c_2Ebinary__ieee_2EroundTiesToEven )
                            & ( V1v0 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EroundTowardPositive )
                            & ( V2v1 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EroundTowardNegative )
                            & ( V3v2 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EroundTowardZero )
                            & ( V4v3 = V5v ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eis__closest__def,axiom,
    ! [A_27a: del,A_27b: del,V0s: $i] :
      ( ( mem @ V0s @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) )
     => ! [V1x: tp__ty_2Erealax_2Ereal,V2a: $i] :
          ( ( mem @ V2a @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
         => ( ( p @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b ) @ V0s ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V2a ) )
          <=> ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) @ V2a ) @ V0s ) )
              & ! [V3b: $i] :
                  ( ( mem @ V3b @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
                 => ( ( p @ ( ap @ ( ap @ ( c_2Ebool_2EIN @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) @ V3b ) @ V0s ) )
                   => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Eabs @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b ) @ V2a ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) @ ( ap @ c_2Ereal_2Eabs @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b ) @ V3b ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eclosest__such__def,axiom,
    ! [A_27a: del,A_27b: del,V0p: $i] :
      ( ( mem @ V0p @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) )
     => ! [V1s: $i] :
          ( ( mem @ V1s @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) @ bool ) )
         => ! [V2x: tp__ty_2Erealax_2Ereal] :
              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27a @ A_27b ) @ V0p ) @ V1s ) @ ( inj__ty_2Erealax_2Ereal @ V2x ) )
              = ( ap @ ( c_2Emin_2E_40 @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
                @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b )
                  @ ^ [V3a: $i] :
                      ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b ) @ V1s ) @ ( inj__ty_2Erealax_2Ereal @ V2x ) ) @ V3a ) )
                      @ ( ap @ ( c_2Ebool_2E_21 @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
                        @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b )
                          @ ^ [V4b: $i] : ( ap @ ( ap @ c_2Emin_2E_3D_3D_3E @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eis__closest @ A_27a @ A_27b ) @ V1s ) @ ( inj__ty_2Erealax_2Ereal @ V2x ) ) @ V4b ) ) @ ( ap @ V0p @ V4b ) ) ) @ ( ap @ V0p @ V3a ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eclosest__def,axiom,
    ! [A_27a: del,A_27b: del] :
      ( ( c_2Ebinary__ieee_2Eclosest @ A_27a @ A_27b )
      = ( ap @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27a @ A_27b ) @ ( ap @ ( c_2Ecombin_2EK @ bool @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) @ c_2Ebool_2ET ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Elargest__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2D @ ( ap @ ( c_2Ewords_2EUINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Erealax_2Einv @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Ethreshold__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2D @ ( ap @ ( c_2Ewords_2EUINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Erealax_2Einv @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2EULP__primitive__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w )
      = ( ap
        @ ( ap @ ( c_2Erelation_2EWFREC @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ ty_2Erealax_2Ereal )
          @ ( ap @ ( c_2Emin_2E_40 @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ bool ) ) )
            @ ( lam @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ bool ) )
              @ ^ [V0R: $i] : ( ap @ ( c_2Erelation_2EWF @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) ) @ V0R ) ) ) )
        @ ( lam @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ ty_2Erealax_2Ereal )
          @ ^ [V1ULP: $i] :
              ( lam @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) )
              @ ^ [V2a: $i] :
                  ( ap @ ( ap @ ( c_2Epair_2Epair__CASE @ ty_2Erealax_2Ereal @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ V2a )
                  @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ A_27w )
                    @ ^ [V3v: $i] :
                        ( lam @ ( ty_2Ebool_2Eitself @ A_27t )
                        @ ^ [V4v1: $i] : ( ap @ ( c_2Ecombin_2EI @ ty_2Erealax_2Ereal ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Enum_2Enum ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V3v ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( c_2Ewords_2Ew2n @ A_27w ) @ V3v ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2EULP__ind,axiom,
    ! [A_27t: del,A_27w: del,V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ( ty_2Epair_2Eprod @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ bool ) )
     => ( ! [V1e: $i] :
            ( ( mem @ V1e @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
           => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ V1e ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) )
       => ! [V2v: $i] :
            ( ( mem @ V2v @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
           => ! [V3v1: $i] :
                ( ( mem @ V3v1 @ ( ty_2Ebool_2Eitself @ A_27t ) )
               => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ V2v ) @ V3v1 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2EULP__def,axiom,
    ! [A_27t: del,A_27w: del,V0e: $i] :
      ( ( mem @ V0e @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) )
     => ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ V0e ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) )
        = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Enum_2Enum ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) ) @ V0e ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( c_2Ewords_2Ew2n @ A_27w ) @ V0e ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eulp__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2EULP @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Efcp_2Ecart @ bool @ A_27w ) @ ( ty_2Ebool_2Eitself @ A_27t ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eround__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: tp__ty_2Erealax_2Ereal] :
      ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eround @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) )
      = ( ap
        @ ( ap
          @ ( ap
            @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) )
              @ ( ap
                @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                  @ ( lam @ ty_2Erealax_2Ereal
                    @ ^ [V2t: $i] :
                        ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V2t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                        @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__ge @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V2t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                          @ ( ap
                            @ ( ap
                              @ ( ap @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27t @ A_27w )
                                @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                  @ ^ [V3a: $i] : ( ap @ c_2Ebool_2E_7E @ ( ap @ ( c_2Ewords_2Eword__lsb @ A_27t ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V3a ) ) ) ) )
                              @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) )
                            @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
                @ ( ap @ ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
            @ ( ap
              @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V4t: $i] :
                      ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V4t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                      @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__gt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V4t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                        @ ( ap
                          @ ( ap @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w )
                            @ ( ap @ ( c_2Epred__set_2EGSPEC @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                              @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                @ ^ [V5a: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) @ V5a ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ V5a ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__ge @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V5a ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) )
                          @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
              @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
          @ ( ap
            @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
              @ ( lam @ ty_2Erealax_2Ereal
                @ ^ [V6t: $i] :
                    ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V6t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                    @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__gt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V6t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                      @ ( ap
                        @ ( ap @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w )
                          @ ( ap @ ( c_2Epred__set_2EGSPEC @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                            @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                              @ ^ [V7a: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) @ V7a ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ V7a ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V7a ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) )
                        @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
            @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            @ ( lam @ ty_2Erealax_2Ereal
              @ ^ [V8t: $i] :
                  ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V8t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                  @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__gt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V8t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                    @ ( ap
                      @ ( ap @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w )
                        @ ( ap @ ( c_2Epred__set_2EGSPEC @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                          @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                            @ ^ [V9a: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) @ V9a ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ V9a ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Eabs @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V9a ) ) ) @ ( ap @ c_2Ereal_2Eabs @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) ) )
                      @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
          @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eintegral__round__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: tp__ty_2Erealax_2Ereal] :
      ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eintegral__round @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) )
      = ( ap
        @ ( ap
          @ ( ap
            @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) )
              @ ( ap
                @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                  @ ( lam @ ty_2Erealax_2Ereal
                    @ ^ [V2t: $i] :
                        ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V2t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                        @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__ge @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V2t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                          @ ( ap
                            @ ( ap
                              @ ( ap @ ( c_2Ebinary__ieee_2Eclosest__such @ A_27t @ A_27w )
                                @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                  @ ^ [V3a: $i] :
                                      ( ap @ ( c_2Ebool_2E_3F @ ty_2Enum_2Enum )
                                      @ ( lam @ ty_2Enum_2Enum
                                        @ ^ [V4n: $i] : ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ c_2Earithmetic_2EEVEN @ V4n ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ ( ap @ c_2Ereal_2Eabs @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V3a ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ V4n ) ) ) ) ) ) )
                              @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) )
                            @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
                @ ( ap @ ( c_2Ebinary__ieee_2Ethreshold @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
            @ ( ap
              @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V5t: $i] :
                      ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V5t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                      @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__gt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V5t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                        @ ( ap
                          @ ( ap @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w )
                            @ ( ap @ ( c_2Epred__set_2EGSPEC @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                              @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                @ ^ [V6a: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) @ V6a ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ V6a ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__ge @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V6a ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) )
                          @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
              @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
          @ ( ap
            @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
              @ ( lam @ ty_2Erealax_2Ereal
                @ ^ [V7t: $i] :
                    ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V7t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                    @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__gt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V7t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                      @ ( ap
                        @ ( ap @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w )
                          @ ( ap @ ( c_2Epred__set_2EGSPEC @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                            @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                              @ ^ [V8a: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) @ V8a ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ V8a ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V8a ) ) @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) )
                        @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
            @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            @ ( lam @ ty_2Erealax_2Ereal
              @ ^ [V9t: $i] :
                  ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ ( ap @ c_2Erealax_2Ereal__neg @ V9t ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                  @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__gt @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) @ V9t ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
                    @ ( ap
                      @ ( ap @ ( c_2Ebinary__ieee_2Eclosest @ A_27t @ A_27w )
                        @ ( ap @ ( c_2Epred__set_2EGSPEC @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                          @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                            @ ^ [V10a: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool ) @ V10a ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ V10a ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Eabs @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V10a ) ) ) @ ( ap @ c_2Ereal_2Eabs @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) ) ) )
                      @ ( inj__ty_2Erealax_2Ereal @ V1x ) ) ) ) ) )
          @ ( ap @ ( c_2Ebinary__ieee_2Elargest @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efp__op__TY__DEF,axiom,
    ! [A_27t: del,A_27w: del] :
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
              @ ^ [V1a0_27: $i] :
                  ( ap @ ( c_2Ebool_2E_21 @ ( arr @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ bool ) )
                  @ ( lam @ ( arr @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ bool )
                    @ ^ [V2_27fp__op_27: $i] :
                        ( ap
                        @ ( ap @ c_2Emin_2E_3D_3D_3E
                          @ ( ap @ ( c_2Ebool_2E_21 @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                            @ ( lam @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
                              @ ^ [V3a0_27: $i] :
                                  ( ap
                                  @ ( ap @ c_2Emin_2E_3D_3D_3E
                                    @ ( ap
                                      @ ( ap @ c_2Ebool_2E_5C_2F
                                        @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                          @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                            @ ^ [V4a0: $i] :
                                                ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                  @ ^ [V5a1: $i] :
                                                      ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                      @ ( ap
                                                        @ ( ap
                                                          @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                            @ ^ [V6a0: $i] :
                                                                ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                @ ^ [V7a1: $i] :
                                                                    ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V6a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V7a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                                    @ ( lam @ ty_2Enum_2Enum
                                                                      @ ^ [V8n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) )
                                                          @ V4a0 )
                                                        @ V5a1 ) ) ) ) ) ) )
                                      @ ( ap
                                        @ ( ap @ c_2Ebool_2E_5C_2F
                                          @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                            @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                              @ ^ [V9a0: $i] :
                                                  ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                    @ ^ [V10a1: $i] :
                                                        ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                        @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                          @ ^ [V11a2: $i] :
                                                              ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                              @ ( ap
                                                                @ ( ap
                                                                  @ ( ap
                                                                    @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                                      @ ^ [V12a0: $i] :
                                                                          ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                          @ ^ [V13a1: $i] :
                                                                              ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                              @ ^ [V14a2: $i] :
                                                                                  ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V12a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V13a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V14a2 ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                                                  @ ( lam @ ty_2Enum_2Enum
                                                                                    @ ^ [V15n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) )
                                                                    @ V9a0 )
                                                                  @ V10a1 )
                                                                @ V11a2 ) ) ) ) ) ) ) ) )
                                        @ ( ap
                                          @ ( ap @ c_2Ebool_2E_5C_2F
                                            @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                              @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                @ ^ [V16a0: $i] :
                                                    ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                    @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                      @ ^ [V17a1: $i] :
                                                          ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                          @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                            @ ^ [V18a2: $i] :
                                                                ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                                @ ( ap
                                                                  @ ( ap
                                                                    @ ( ap
                                                                      @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                                        @ ^ [V19a0: $i] :
                                                                            ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                            @ ^ [V20a1: $i] :
                                                                                ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                @ ^ [V21a2: $i] :
                                                                                    ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V19a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V20a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V21a2 ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                                                    @ ( lam @ ty_2Enum_2Enum
                                                                                      @ ^ [V22n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) )
                                                                      @ V16a0 )
                                                                    @ V17a1 )
                                                                  @ V18a2 ) ) ) ) ) ) ) ) )
                                          @ ( ap
                                            @ ( ap @ c_2Ebool_2E_5C_2F
                                              @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                                @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                  @ ^ [V23a0: $i] :
                                                      ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                      @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                        @ ^ [V24a1: $i] :
                                                            ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                            @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                              @ ^ [V25a2: $i] :
                                                                  ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                                  @ ( ap
                                                                    @ ( ap
                                                                      @ ( ap
                                                                        @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                                          @ ^ [V26a0: $i] :
                                                                              ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                              @ ^ [V27a1: $i] :
                                                                                  ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                  @ ^ [V28a2: $i] :
                                                                                      ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V26a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V27a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V28a2 ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                                                      @ ( lam @ ty_2Enum_2Enum
                                                                                        @ ^ [V29n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) )
                                                                        @ V23a0 )
                                                                      @ V24a1 )
                                                                    @ V25a2 ) ) ) ) ) ) ) ) )
                                            @ ( ap
                                              @ ( ap @ c_2Ebool_2E_5C_2F
                                                @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                                  @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                    @ ^ [V30a0: $i] :
                                                        ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                        @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                          @ ^ [V31a1: $i] :
                                                              ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                              @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                @ ^ [V32a2: $i] :
                                                                    ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                                    @ ( ap
                                                                      @ ( ap
                                                                        @ ( ap
                                                                          @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                                            @ ^ [V33a0: $i] :
                                                                                ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                @ ^ [V34a1: $i] :
                                                                                    ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                    @ ^ [V35a2: $i] :
                                                                                        ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V33a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V34a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V35a2 ) @ ( c_2Ebool_2EARB @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) )
                                                                                        @ ( lam @ ty_2Enum_2Enum
                                                                                          @ ^ [V36n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) )
                                                                          @ V30a0 )
                                                                        @ V31a1 )
                                                                      @ V32a2 ) ) ) ) ) ) ) ) )
                                              @ ( ap
                                                @ ( ap @ c_2Ebool_2E_5C_2F
                                                  @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                                    @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                      @ ^ [V37a0: $i] :
                                                          ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                          @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                            @ ^ [V38a1: $i] :
                                                                ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                  @ ^ [V39a2: $i] :
                                                                      ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                      @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                        @ ^ [V40a3: $i] :
                                                                            ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                                            @ ( ap
                                                                              @ ( ap
                                                                                @ ( ap
                                                                                  @ ( ap
                                                                                    @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                                                      @ ^ [V41a0: $i] :
                                                                                          ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                          @ ^ [V42a1: $i] :
                                                                                              ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                              @ ^ [V43a2: $i] :
                                                                                                  ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                                  @ ^ [V44a3: $i] :
                                                                                                      ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V41a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V42a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V43a2 ) @ V44a3 ) ) ) )
                                                                                                      @ ( lam @ ty_2Enum_2Enum
                                                                                                        @ ^ [V45n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) ) )
                                                                                    @ V37a0 )
                                                                                  @ V38a1 )
                                                                                @ V39a2 )
                                                                              @ V40a3 ) ) ) ) ) ) ) ) ) ) )
                                                @ ( ap @ ( c_2Ebool_2E_3F @ ty_2Ebinary__ieee_2Erounding )
                                                  @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                    @ ^ [V46a0: $i] :
                                                        ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                        @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                          @ ^ [V47a1: $i] :
                                                              ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                              @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                @ ^ [V48a2: $i] :
                                                                    ( ap @ ( c_2Ebool_2E_3F @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                    @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                      @ ^ [V49a3: $i] :
                                                                          ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Eind__type_2Erecspace @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ V3a0_27 )
                                                                          @ ( ap
                                                                            @ ( ap
                                                                              @ ( ap
                                                                                @ ( ap
                                                                                  @ ( lam @ ty_2Ebinary__ieee_2Erounding
                                                                                    @ ^ [V50a0: $i] :
                                                                                        ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                        @ ^ [V51a1: $i] :
                                                                                            ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                            @ ^ [V52a2: $i] :
                                                                                                ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                                                                                                @ ^ [V53a3: $i] :
                                                                                                    ( ap @ ( ap @ ( ap @ ( c_2Eind__type_2ECONSTR @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( ap @ c_2Enum_2ESUC @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) @ V50a0 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V51a1 ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V52a2 ) @ V53a3 ) ) ) )
                                                                                                    @ ( lam @ ty_2Enum_2Enum
                                                                                                      @ ^ [V54n: $i] : ( c_2Eind__type_2EBOTTOM @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Erounding @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Epair_2Eprod @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) ) ) ) )
                                                                                  @ V46a0 )
                                                                                @ V47a1 )
                                                                              @ V48a2 )
                                                                            @ V49a3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )
                                  @ ( ap @ V2_27fp__op_27 @ V3a0_27 ) ) ) ) )
                        @ ( ap @ V2_27fp__op_27 @ V1a0_27 ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efp__op__case__def,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del] :
      ( ! [V0a0: tp__ty_2Ebinary__ieee_2Erounding,V1a1: $i] :
          ( ( mem @ V1a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V2f: $i] :
              ( ( mem @ V2f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
             => ! [V3f1: $i] :
                  ( ( mem @ V3f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                 => ! [V4f2: $i] :
                      ( ( mem @ V4f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V5f3: $i] :
                          ( ( mem @ V5f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V6f4: $i] :
                              ( ( mem @ V6f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V7f5: $i] :
                                  ( ( mem @ V7f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                 => ! [V8f6: $i] :
                                      ( ( mem @ V8f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a0 ) ) @ V1a1 ) ) @ V2f ) @ V3f1 ) @ V4f2 ) @ V5f3 ) @ V6f4 ) @ V7f5 ) @ V8f6 )
                                        = ( ap @ ( ap @ V2f @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a0 ) ) @ V1a1 ) ) ) ) ) ) ) ) ) )
      & ! [V9a0: tp__ty_2Ebinary__ieee_2Erounding,V10a1: $i] :
          ( ( mem @ V10a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V11a2: $i] :
              ( ( mem @ V11a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V12f: $i] :
                  ( ( mem @ V12f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                 => ! [V13f1: $i] :
                      ( ( mem @ V13f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V14f2: $i] :
                          ( ( mem @ V14f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V15f3: $i] :
                              ( ( mem @ V15f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V16f4: $i] :
                                  ( ( mem @ V16f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                 => ! [V17f5: $i] :
                                      ( ( mem @ V17f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                     => ! [V18f6: $i] :
                                          ( ( mem @ V18f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                         => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9a0 ) ) @ V10a1 ) @ V11a2 ) ) @ V12f ) @ V13f1 ) @ V14f2 ) @ V15f3 ) @ V16f4 ) @ V17f5 ) @ V18f6 )
                                            = ( ap @ ( ap @ ( ap @ V13f1 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9a0 ) ) @ V10a1 ) @ V11a2 ) ) ) ) ) ) ) ) ) ) )
      & ! [V19a0: tp__ty_2Ebinary__ieee_2Erounding,V20a1: $i] :
          ( ( mem @ V20a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V21a2: $i] :
              ( ( mem @ V21a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V22f: $i] :
                  ( ( mem @ V22f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                 => ! [V23f1: $i] :
                      ( ( mem @ V23f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V24f2: $i] :
                          ( ( mem @ V24f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V25f3: $i] :
                              ( ( mem @ V25f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V26f4: $i] :
                                  ( ( mem @ V26f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                 => ! [V27f5: $i] :
                                      ( ( mem @ V27f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                     => ! [V28f6: $i] :
                                          ( ( mem @ V28f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                         => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19a0 ) ) @ V20a1 ) @ V21a2 ) ) @ V22f ) @ V23f1 ) @ V24f2 ) @ V25f3 ) @ V26f4 ) @ V27f5 ) @ V28f6 )
                                            = ( ap @ ( ap @ ( ap @ V24f2 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19a0 ) ) @ V20a1 ) @ V21a2 ) ) ) ) ) ) ) ) ) ) )
      & ! [V29a0: tp__ty_2Ebinary__ieee_2Erounding,V30a1: $i] :
          ( ( mem @ V30a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V31a2: $i] :
              ( ( mem @ V31a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V32f: $i] :
                  ( ( mem @ V32f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                 => ! [V33f1: $i] :
                      ( ( mem @ V33f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V34f2: $i] :
                          ( ( mem @ V34f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V35f3: $i] :
                              ( ( mem @ V35f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V36f4: $i] :
                                  ( ( mem @ V36f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                 => ! [V37f5: $i] :
                                      ( ( mem @ V37f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                     => ! [V38f6: $i] :
                                          ( ( mem @ V38f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                         => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V29a0 ) ) @ V30a1 ) @ V31a2 ) ) @ V32f ) @ V33f1 ) @ V34f2 ) @ V35f3 ) @ V36f4 ) @ V37f5 ) @ V38f6 )
                                            = ( ap @ ( ap @ ( ap @ V35f3 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V29a0 ) ) @ V30a1 ) @ V31a2 ) ) ) ) ) ) ) ) ) ) )
      & ! [V39a0: tp__ty_2Ebinary__ieee_2Erounding,V40a1: $i] :
          ( ( mem @ V40a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V41a2: $i] :
              ( ( mem @ V41a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V42f: $i] :
                  ( ( mem @ V42f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                 => ! [V43f1: $i] :
                      ( ( mem @ V43f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V44f2: $i] :
                          ( ( mem @ V44f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V45f3: $i] :
                              ( ( mem @ V45f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V46f4: $i] :
                                  ( ( mem @ V46f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                 => ! [V47f5: $i] :
                                      ( ( mem @ V47f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                     => ! [V48f6: $i] :
                                          ( ( mem @ V48f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                         => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V39a0 ) ) @ V40a1 ) @ V41a2 ) ) @ V42f ) @ V43f1 ) @ V44f2 ) @ V45f3 ) @ V46f4 ) @ V47f5 ) @ V48f6 )
                                            = ( ap @ ( ap @ ( ap @ V46f4 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V39a0 ) ) @ V40a1 ) @ V41a2 ) ) ) ) ) ) ) ) ) ) )
      & ! [V49a0: tp__ty_2Ebinary__ieee_2Erounding,V50a1: $i] :
          ( ( mem @ V50a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V51a2: $i] :
              ( ( mem @ V51a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V52a3: $i] :
                  ( ( mem @ V52a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V53f: $i] :
                      ( ( mem @ V53f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                     => ! [V54f1: $i] :
                          ( ( mem @ V54f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V55f2: $i] :
                              ( ( mem @ V55f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V56f3: $i] :
                                  ( ( mem @ V56f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                 => ! [V57f4: $i] :
                                      ( ( mem @ V57f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                     => ! [V58f5: $i] :
                                          ( ( mem @ V58f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                         => ! [V59f6: $i] :
                                              ( ( mem @ V59f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                             => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V49a0 ) ) @ V50a1 ) @ V51a2 ) @ V52a3 ) ) @ V53f ) @ V54f1 ) @ V55f2 ) @ V56f3 ) @ V57f4 ) @ V58f5 ) @ V59f6 )
                                                = ( ap @ ( ap @ ( ap @ ( ap @ V58f5 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V49a0 ) ) @ V50a1 ) @ V51a2 ) @ V52a3 ) ) ) ) ) ) ) ) ) ) ) )
      & ! [V60a0: tp__ty_2Ebinary__ieee_2Erounding,V61a1: $i] :
          ( ( mem @ V61a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V62a2: $i] :
              ( ( mem @ V62a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V63a3: $i] :
                  ( ( mem @ V63a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V64f: $i] :
                      ( ( mem @ V64f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                     => ! [V65f1: $i] :
                          ( ( mem @ V65f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V66f2: $i] :
                              ( ( mem @ V66f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                             => ! [V67f3: $i] :
                                  ( ( mem @ V67f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                 => ! [V68f4: $i] :
                                      ( ( mem @ V68f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                     => ! [V69f5: $i] :
                                          ( ( mem @ V69f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                         => ! [V70f6: $i] :
                                              ( ( mem @ V70f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                             => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V60a0 ) ) @ V61a1 ) @ V62a2 ) @ V63a3 ) ) @ V64f ) @ V65f1 ) @ V66f2 ) @ V67f3 ) @ V68f4 ) @ V69f5 ) @ V70f6 )
                                                = ( ap @ ( ap @ ( ap @ ( ap @ V70f6 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V60a0 ) ) @ V61a1 ) @ V62a2 ) @ V63a3 ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efp__op__size__def,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0f: $i] :
          ( ( mem @ V0f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V1f1: $i] :
              ( ( mem @ V1f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V2a0: tp__ty_2Ebinary__ieee_2Erounding,V3a1: $i] :
                  ( ( mem @ V3a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V0f ) @ V1f1 ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V2a0 ) ) @ V3a1 ) ) )
                    = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V2a0 ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V0f ) @ V1f1 ) @ V3a1 ) ) ) ) ) ) ) )
      & ! [V4f: $i] :
          ( ( mem @ V4f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V5f1: $i] :
              ( ( mem @ V5f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V6a0: tp__ty_2Ebinary__ieee_2Erounding,V7a1: $i] :
                  ( ( mem @ V7a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V8a2: $i] :
                      ( ( mem @ V8a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V4f ) @ V5f1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V6a0 ) ) @ V7a1 ) @ V8a2 ) ) )
                        = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V6a0 ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V4f ) @ V5f1 ) @ V7a1 ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V4f ) @ V5f1 ) @ V8a2 ) ) ) ) ) ) ) ) ) )
      & ! [V9f: $i] :
          ( ( mem @ V9f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V10f1: $i] :
              ( ( mem @ V10f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V11a0: tp__ty_2Ebinary__ieee_2Erounding,V12a1: $i] :
                  ( ( mem @ V12a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V13a2: $i] :
                      ( ( mem @ V13a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V9f ) @ V10f1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V11a0 ) ) @ V12a1 ) @ V13a2 ) ) )
                        = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V11a0 ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V9f ) @ V10f1 ) @ V12a1 ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V9f ) @ V10f1 ) @ V13a2 ) ) ) ) ) ) ) ) ) )
      & ! [V14f: $i] :
          ( ( mem @ V14f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V15f1: $i] :
              ( ( mem @ V15f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
                  ( ( mem @ V17a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V18a2: $i] :
                      ( ( mem @ V18a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V14f ) @ V15f1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 ) @ V18a2 ) ) )
                        = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V14f ) @ V15f1 ) @ V17a1 ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V14f ) @ V15f1 ) @ V18a2 ) ) ) ) ) ) ) ) ) )
      & ! [V19f: $i] :
          ( ( mem @ V19f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V20f1: $i] :
              ( ( mem @ V20f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V21a0: tp__ty_2Ebinary__ieee_2Erounding,V22a1: $i] :
                  ( ( mem @ V22a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V23a2: $i] :
                      ( ( mem @ V23a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V19f ) @ V20f1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V21a0 ) ) @ V22a1 ) @ V23a2 ) ) )
                        = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V21a0 ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V19f ) @ V20f1 ) @ V22a1 ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V19f ) @ V20f1 ) @ V23a2 ) ) ) ) ) ) ) ) ) )
      & ! [V24f: $i] :
          ( ( mem @ V24f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V25f1: $i] :
              ( ( mem @ V25f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V26a0: tp__ty_2Ebinary__ieee_2Erounding,V27a1: $i] :
                  ( ( mem @ V27a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V28a2: $i] :
                      ( ( mem @ V28a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V29a3: $i] :
                          ( ( mem @ V29a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V24f ) @ V25f1 ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V26a0 ) ) @ V27a1 ) @ V28a2 ) @ V29a3 ) ) )
                            = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V26a0 ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V24f ) @ V25f1 ) @ V27a1 ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V24f ) @ V25f1 ) @ V28a2 ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V24f ) @ V25f1 ) @ V29a3 ) ) ) ) ) ) ) ) ) ) ) )
      & ! [V30f: $i] :
          ( ( mem @ V30f @ ( arr @ A_27t @ ty_2Enum_2Enum ) )
         => ! [V31f1: $i] :
              ( ( mem @ V31f1 @ ( arr @ A_27w @ ty_2Enum_2Enum ) )
             => ! [V32a0: tp__ty_2Ebinary__ieee_2Erounding,V33a1: $i] :
                  ( ( mem @ V33a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V34a2: $i] :
                      ( ( mem @ V34a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V35a3: $i] :
                          ( ( mem @ V35a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ( ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__size @ A_27t @ A_27w ) @ V30f ) @ V31f1 ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V32a0 ) ) @ V33a1 ) @ V34a2 ) @ V35a3 ) ) )
                            = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ c_2Ebinary__ieee_2Erounding__size @ ( inj__ty_2Ebinary__ieee_2Erounding @ V32a0 ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V30f ) @ V31f1 ) @ V33a1 ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V30f ) @ V31f1 ) @ V34a2 ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__size @ A_27t @ A_27w ) @ V30f ) @ V31f1 ) @ V35a3 ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Edatatype__fp__op,axiom,
    ! [A_27t: del,A_27w: del,V0fp__op: $i] :
      ( ( mem @ V0fp__op @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) @ ( arr @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) ) ) ) ) @ bool ) ) ) ) ) ) ) )
     => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ V0fp__op @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) ) @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__11,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0a0: tp__ty_2Ebinary__ieee_2Erounding,V1a1: $i] :
          ( ( mem @ V1a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V2a0_27: tp__ty_2Ebinary__ieee_2Erounding,V3a1_27: $i] :
              ( ( mem @ V3a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0a0 ) ) @ V1a1 )
                  = ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V2a0_27 ) ) @ V3a1_27 ) )
              <=> ( ( V0a0 = V2a0_27 )
                  & ( V1a1 = V3a1_27 ) ) ) ) )
      & ! [V4a0: tp__ty_2Ebinary__ieee_2Erounding,V5a1: $i] :
          ( ( mem @ V5a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V6a2: $i] :
              ( ( mem @ V6a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V7a0_27: tp__ty_2Ebinary__ieee_2Erounding,V8a1_27: $i] :
                  ( ( mem @ V8a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V9a2_27: $i] :
                      ( ( mem @ V9a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V4a0 ) ) @ V5a1 ) @ V6a2 )
                          = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V7a0_27 ) ) @ V8a1_27 ) @ V9a2_27 ) )
                      <=> ( ( V4a0 = V7a0_27 )
                          & ( V5a1 = V8a1_27 )
                          & ( V6a2 = V9a2_27 ) ) ) ) ) ) )
      & ! [V10a0: tp__ty_2Ebinary__ieee_2Erounding,V11a1: $i] :
          ( ( mem @ V11a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V12a2: $i] :
              ( ( mem @ V12a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V13a0_27: tp__ty_2Ebinary__ieee_2Erounding,V14a1_27: $i] :
                  ( ( mem @ V14a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V15a2_27: $i] :
                      ( ( mem @ V15a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V10a0 ) ) @ V11a1 ) @ V12a2 )
                          = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V13a0_27 ) ) @ V14a1_27 ) @ V15a2_27 ) )
                      <=> ( ( V10a0 = V13a0_27 )
                          & ( V11a1 = V14a1_27 )
                          & ( V12a2 = V15a2_27 ) ) ) ) ) ) )
      & ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
          ( ( mem @ V17a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V18a2: $i] :
              ( ( mem @ V18a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V19a0_27: tp__ty_2Ebinary__ieee_2Erounding,V20a1_27: $i] :
                  ( ( mem @ V20a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V21a2_27: $i] :
                      ( ( mem @ V21a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 ) @ V18a2 )
                          = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19a0_27 ) ) @ V20a1_27 ) @ V21a2_27 ) )
                      <=> ( ( V16a0 = V19a0_27 )
                          & ( V17a1 = V20a1_27 )
                          & ( V18a2 = V21a2_27 ) ) ) ) ) ) )
      & ! [V22a0: tp__ty_2Ebinary__ieee_2Erounding,V23a1: $i] :
          ( ( mem @ V23a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V24a2: $i] :
              ( ( mem @ V24a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V25a0_27: tp__ty_2Ebinary__ieee_2Erounding,V26a1_27: $i] :
                  ( ( mem @ V26a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V27a2_27: $i] :
                      ( ( mem @ V27a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V22a0 ) ) @ V23a1 ) @ V24a2 )
                          = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V25a0_27 ) ) @ V26a1_27 ) @ V27a2_27 ) )
                      <=> ( ( V22a0 = V25a0_27 )
                          & ( V23a1 = V26a1_27 )
                          & ( V24a2 = V27a2_27 ) ) ) ) ) ) )
      & ! [V28a0: tp__ty_2Ebinary__ieee_2Erounding,V29a1: $i] :
          ( ( mem @ V29a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V30a2: $i] :
              ( ( mem @ V30a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V31a3: $i] :
                  ( ( mem @ V31a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V32a0_27: tp__ty_2Ebinary__ieee_2Erounding,V33a1_27: $i] :
                      ( ( mem @ V33a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V34a2_27: $i] :
                          ( ( mem @ V34a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V35a3_27: $i] :
                              ( ( mem @ V35a3_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                             => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V28a0 ) ) @ V29a1 ) @ V30a2 ) @ V31a3 )
                                  = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V32a0_27 ) ) @ V33a1_27 ) @ V34a2_27 ) @ V35a3_27 ) )
                              <=> ( ( V28a0 = V32a0_27 )
                                  & ( V29a1 = V33a1_27 )
                                  & ( V30a2 = V34a2_27 )
                                  & ( V31a3 = V35a3_27 ) ) ) ) ) ) ) ) )
      & ! [V36a0: tp__ty_2Ebinary__ieee_2Erounding,V37a1: $i] :
          ( ( mem @ V37a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V38a2: $i] :
              ( ( mem @ V38a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V39a3: $i] :
                  ( ( mem @ V39a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V40a0_27: tp__ty_2Ebinary__ieee_2Erounding,V41a1_27: $i] :
                      ( ( mem @ V41a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V42a2_27: $i] :
                          ( ( mem @ V42a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V43a3_27: $i] :
                              ( ( mem @ V43a3_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                             => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V36a0 ) ) @ V37a1 ) @ V38a2 ) @ V39a3 )
                                  = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V40a0_27 ) ) @ V41a1_27 ) @ V42a2_27 ) @ V43a3_27 ) )
                              <=> ( ( V36a0 = V40a0_27 )
                                  & ( V37a1 = V41a1_27 )
                                  & ( V38a2 = V42a2_27 )
                                  & ( V39a3 = V43a3_27 ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__distinct,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ! [V0a2: $i] :
          ( ( mem @ V0a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V1a1_27: $i] :
              ( ( mem @ V1a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V2a1: $i] :
                  ( ( mem @ V2a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V3a0_27: tp__ty_2Ebinary__ieee_2Erounding,V4a0: tp__ty_2Ebinary__ieee_2Erounding] :
                      ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V4a0 ) ) @ V2a1 )
                     != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V3a0_27 ) ) @ V1a1_27 ) @ V0a2 ) ) ) ) )
      & ! [V5a2: $i] :
          ( ( mem @ V5a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V6a1_27: $i] :
              ( ( mem @ V6a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V7a1: $i] :
                  ( ( mem @ V7a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V8a0_27: tp__ty_2Ebinary__ieee_2Erounding,V9a0: tp__ty_2Ebinary__ieee_2Erounding] :
                      ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9a0 ) ) @ V7a1 )
                     != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V8a0_27 ) ) @ V6a1_27 ) @ V5a2 ) ) ) ) )
      & ! [V10a2: $i] :
          ( ( mem @ V10a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V11a1_27: $i] :
              ( ( mem @ V11a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V12a1: $i] :
                  ( ( mem @ V12a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V13a0_27: tp__ty_2Ebinary__ieee_2Erounding,V14a0: tp__ty_2Ebinary__ieee_2Erounding] :
                      ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V14a0 ) ) @ V12a1 )
                     != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V13a0_27 ) ) @ V11a1_27 ) @ V10a2 ) ) ) ) )
      & ! [V15a2: $i] :
          ( ( mem @ V15a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V16a1_27: $i] :
              ( ( mem @ V16a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V17a1: $i] :
                  ( ( mem @ V17a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V18a0_27: tp__ty_2Ebinary__ieee_2Erounding,V19a0: tp__ty_2Ebinary__ieee_2Erounding] :
                      ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19a0 ) ) @ V17a1 )
                     != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V18a0_27 ) ) @ V16a1_27 ) @ V15a2 ) ) ) ) )
      & ! [V20a3: $i] :
          ( ( mem @ V20a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V21a2: $i] :
              ( ( mem @ V21a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V22a1_27: $i] :
                  ( ( mem @ V22a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V23a1: $i] :
                      ( ( mem @ V23a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V24a0_27: tp__ty_2Ebinary__ieee_2Erounding,V25a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V25a0 ) ) @ V23a1 )
                         != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V24a0_27 ) ) @ V22a1_27 ) @ V21a2 ) @ V20a3 ) ) ) ) ) )
      & ! [V26a3: $i] :
          ( ( mem @ V26a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V27a2: $i] :
              ( ( mem @ V27a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V28a1_27: $i] :
                  ( ( mem @ V28a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V29a1: $i] :
                      ( ( mem @ V29a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V30a0_27: tp__ty_2Ebinary__ieee_2Erounding,V31a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V31a0 ) ) @ V29a1 )
                         != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V30a0_27 ) ) @ V28a1_27 ) @ V27a2 ) @ V26a3 ) ) ) ) ) )
      & ! [V32a2_27: $i] :
          ( ( mem @ V32a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V33a2: $i] :
              ( ( mem @ V33a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V34a1_27: $i] :
                  ( ( mem @ V34a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V35a1: $i] :
                      ( ( mem @ V35a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V36a0_27: tp__ty_2Ebinary__ieee_2Erounding,V37a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V37a0 ) ) @ V35a1 ) @ V33a2 )
                         != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V36a0_27 ) ) @ V34a1_27 ) @ V32a2_27 ) ) ) ) ) )
      & ! [V38a2_27: $i] :
          ( ( mem @ V38a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V39a2: $i] :
              ( ( mem @ V39a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V40a1_27: $i] :
                  ( ( mem @ V40a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V41a1: $i] :
                      ( ( mem @ V41a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V42a0_27: tp__ty_2Ebinary__ieee_2Erounding,V43a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V43a0 ) ) @ V41a1 ) @ V39a2 )
                         != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V42a0_27 ) ) @ V40a1_27 ) @ V38a2_27 ) ) ) ) ) )
      & ! [V44a2_27: $i] :
          ( ( mem @ V44a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V45a2: $i] :
              ( ( mem @ V45a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V46a1_27: $i] :
                  ( ( mem @ V46a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V47a1: $i] :
                      ( ( mem @ V47a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V48a0_27: tp__ty_2Ebinary__ieee_2Erounding,V49a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V49a0 ) ) @ V47a1 ) @ V45a2 )
                         != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V48a0_27 ) ) @ V46a1_27 ) @ V44a2_27 ) ) ) ) ) )
      & ! [V50a3: $i] :
          ( ( mem @ V50a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V51a2_27: $i] :
              ( ( mem @ V51a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V52a2: $i] :
                  ( ( mem @ V52a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V53a1_27: $i] :
                      ( ( mem @ V53a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V54a1: $i] :
                          ( ( mem @ V54a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V55a0_27: tp__ty_2Ebinary__ieee_2Erounding,V56a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V56a0 ) ) @ V54a1 ) @ V52a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V55a0_27 ) ) @ V53a1_27 ) @ V51a2_27 ) @ V50a3 ) ) ) ) ) ) )
      & ! [V57a3: $i] :
          ( ( mem @ V57a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V58a2_27: $i] :
              ( ( mem @ V58a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V59a2: $i] :
                  ( ( mem @ V59a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V60a1_27: $i] :
                      ( ( mem @ V60a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V61a1: $i] :
                          ( ( mem @ V61a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V62a0_27: tp__ty_2Ebinary__ieee_2Erounding,V63a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V63a0 ) ) @ V61a1 ) @ V59a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V62a0_27 ) ) @ V60a1_27 ) @ V58a2_27 ) @ V57a3 ) ) ) ) ) ) )
      & ! [V64a2_27: $i] :
          ( ( mem @ V64a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V65a2: $i] :
              ( ( mem @ V65a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V66a1_27: $i] :
                  ( ( mem @ V66a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V67a1: $i] :
                      ( ( mem @ V67a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V68a0_27: tp__ty_2Ebinary__ieee_2Erounding,V69a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V69a0 ) ) @ V67a1 ) @ V65a2 )
                         != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V68a0_27 ) ) @ V66a1_27 ) @ V64a2_27 ) ) ) ) ) )
      & ! [V70a2_27: $i] :
          ( ( mem @ V70a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V71a2: $i] :
              ( ( mem @ V71a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V72a1_27: $i] :
                  ( ( mem @ V72a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V73a1: $i] :
                      ( ( mem @ V73a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V74a0_27: tp__ty_2Ebinary__ieee_2Erounding,V75a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V75a0 ) ) @ V73a1 ) @ V71a2 )
                         != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V74a0_27 ) ) @ V72a1_27 ) @ V70a2_27 ) ) ) ) ) )
      & ! [V76a3: $i] :
          ( ( mem @ V76a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V77a2_27: $i] :
              ( ( mem @ V77a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V78a2: $i] :
                  ( ( mem @ V78a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V79a1_27: $i] :
                      ( ( mem @ V79a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V80a1: $i] :
                          ( ( mem @ V80a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V81a0_27: tp__ty_2Ebinary__ieee_2Erounding,V82a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V82a0 ) ) @ V80a1 ) @ V78a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V81a0_27 ) ) @ V79a1_27 ) @ V77a2_27 ) @ V76a3 ) ) ) ) ) ) )
      & ! [V83a3: $i] :
          ( ( mem @ V83a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V84a2_27: $i] :
              ( ( mem @ V84a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V85a2: $i] :
                  ( ( mem @ V85a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V86a1_27: $i] :
                      ( ( mem @ V86a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V87a1: $i] :
                          ( ( mem @ V87a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V88a0_27: tp__ty_2Ebinary__ieee_2Erounding,V89a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V89a0 ) ) @ V87a1 ) @ V85a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V88a0_27 ) ) @ V86a1_27 ) @ V84a2_27 ) @ V83a3 ) ) ) ) ) ) )
      & ! [V90a2_27: $i] :
          ( ( mem @ V90a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V91a2: $i] :
              ( ( mem @ V91a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V92a1_27: $i] :
                  ( ( mem @ V92a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V93a1: $i] :
                      ( ( mem @ V93a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V94a0_27: tp__ty_2Ebinary__ieee_2Erounding,V95a0: tp__ty_2Ebinary__ieee_2Erounding] :
                          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V95a0 ) ) @ V93a1 ) @ V91a2 )
                         != ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V94a0_27 ) ) @ V92a1_27 ) @ V90a2_27 ) ) ) ) ) )
      & ! [V96a3: $i] :
          ( ( mem @ V96a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V97a2_27: $i] :
              ( ( mem @ V97a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V98a2: $i] :
                  ( ( mem @ V98a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V99a1_27: $i] :
                      ( ( mem @ V99a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V100a1: $i] :
                          ( ( mem @ V100a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V101a0_27: tp__ty_2Ebinary__ieee_2Erounding,V102a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V102a0 ) ) @ V100a1 ) @ V98a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V101a0_27 ) ) @ V99a1_27 ) @ V97a2_27 ) @ V96a3 ) ) ) ) ) ) )
      & ! [V103a3: $i] :
          ( ( mem @ V103a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V104a2_27: $i] :
              ( ( mem @ V104a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V105a2: $i] :
                  ( ( mem @ V105a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V106a1_27: $i] :
                      ( ( mem @ V106a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V107a1: $i] :
                          ( ( mem @ V107a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V108a0_27: tp__ty_2Ebinary__ieee_2Erounding,V109a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V109a0 ) ) @ V107a1 ) @ V105a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V108a0_27 ) ) @ V106a1_27 ) @ V104a2_27 ) @ V103a3 ) ) ) ) ) ) )
      & ! [V110a3: $i] :
          ( ( mem @ V110a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V111a2_27: $i] :
              ( ( mem @ V111a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V112a2: $i] :
                  ( ( mem @ V112a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V113a1_27: $i] :
                      ( ( mem @ V113a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V114a1: $i] :
                          ( ( mem @ V114a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V115a0_27: tp__ty_2Ebinary__ieee_2Erounding,V116a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V116a0 ) ) @ V114a1 ) @ V112a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V115a0_27 ) ) @ V113a1_27 ) @ V111a2_27 ) @ V110a3 ) ) ) ) ) ) )
      & ! [V117a3: $i] :
          ( ( mem @ V117a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V118a2_27: $i] :
              ( ( mem @ V118a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V119a2: $i] :
                  ( ( mem @ V119a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V120a1_27: $i] :
                      ( ( mem @ V120a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V121a1: $i] :
                          ( ( mem @ V121a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V122a0_27: tp__ty_2Ebinary__ieee_2Erounding,V123a0: tp__ty_2Ebinary__ieee_2Erounding] :
                              ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V123a0 ) ) @ V121a1 ) @ V119a2 )
                             != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V122a0_27 ) ) @ V120a1_27 ) @ V118a2_27 ) @ V117a3 ) ) ) ) ) ) )
      & ! [V124a3_27: $i] :
          ( ( mem @ V124a3_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V125a3: $i] :
              ( ( mem @ V125a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V126a2_27: $i] :
                  ( ( mem @ V126a2_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V127a2: $i] :
                      ( ( mem @ V127a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ! [V128a1_27: $i] :
                          ( ( mem @ V128a1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                         => ! [V129a1: $i] :
                              ( ( mem @ V129a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                             => ! [V130a0_27: tp__ty_2Ebinary__ieee_2Erounding,V131a0: tp__ty_2Ebinary__ieee_2Erounding] :
                                  ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V131a0 ) ) @ V129a1 ) @ V127a2 ) @ V125a3 )
                                 != ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V130a0_27 ) ) @ V128a1_27 ) @ V126a2_27 ) @ V124a3_27 ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__nchotomy,axiom,
    ! [A_27t: del,A_27w: del,V0ff: $i] :
      ( ( mem @ V0ff @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
     => ( ? [V1r: tp__ty_2Ebinary__ieee_2Erounding,V2f: $i] :
            ( ( mem @ V2f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ( V0ff
              = ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V1r ) ) @ V2f ) ) )
        | ? [V3r: tp__ty_2Ebinary__ieee_2Erounding,V4f: $i] :
            ( ( mem @ V4f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ? [V5f0: $i] :
                ( ( mem @ V5f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                & ( V0ff
                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V3r ) ) @ V4f ) @ V5f0 ) ) ) )
        | ? [V6r: tp__ty_2Ebinary__ieee_2Erounding,V7f: $i] :
            ( ( mem @ V7f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ? [V8f0: $i] :
                ( ( mem @ V8f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                & ( V0ff
                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V6r ) ) @ V7f ) @ V8f0 ) ) ) )
        | ? [V9r: tp__ty_2Ebinary__ieee_2Erounding,V10f: $i] :
            ( ( mem @ V10f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ? [V11f0: $i] :
                ( ( mem @ V11f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                & ( V0ff
                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9r ) ) @ V10f ) @ V11f0 ) ) ) )
        | ? [V12r: tp__ty_2Ebinary__ieee_2Erounding,V13f: $i] :
            ( ( mem @ V13f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ? [V14f0: $i] :
                ( ( mem @ V14f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                & ( V0ff
                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V12r ) ) @ V13f ) @ V14f0 ) ) ) )
        | ? [V15r: tp__ty_2Ebinary__ieee_2Erounding,V16f: $i] :
            ( ( mem @ V16f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ? [V17f0: $i] :
                ( ( mem @ V17f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                & ? [V18f1: $i] :
                    ( ( mem @ V18f1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                    & ( V0ff
                      = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V15r ) ) @ V16f ) @ V17f0 ) @ V18f1 ) ) ) ) )
        | ? [V19r: tp__ty_2Ebinary__ieee_2Erounding,V20f: $i] :
            ( ( mem @ V20f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
            & ? [V21f0: $i] :
                ( ( mem @ V21f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                & ? [V22f1: $i] :
                    ( ( mem @ V22f1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                    & ( V0ff
                      = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19r ) ) @ V20f ) @ V21f0 ) @ V22f1 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__Axiom,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f0: $i] :
      ( ( mem @ V0f0 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
     => ! [V1f1: $i] :
          ( ( mem @ V1f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
         => ! [V2f2: $i] :
              ( ( mem @ V2f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
             => ! [V3f3: $i] :
                  ( ( mem @ V3f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                 => ! [V4f4: $i] :
                      ( ( mem @ V4f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V5f5: $i] :
                          ( ( mem @ V5f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                         => ! [V6f6: $i] :
                              ( ( mem @ V6f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                             => ? [V7fn: $i] :
                                  ( ( mem @ V7fn @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ A_27a ) )
                                  & ! [V8a0: tp__ty_2Ebinary__ieee_2Erounding,V9a1: $i] :
                                      ( ( mem @ V9a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ( ( ap @ V7fn @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V8a0 ) ) @ V9a1 ) )
                                        = ( ap @ ( ap @ V0f0 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V8a0 ) ) @ V9a1 ) ) )
                                  & ! [V10a0: tp__ty_2Ebinary__ieee_2Erounding,V11a1: $i] :
                                      ( ( mem @ V11a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ! [V12a2: $i] :
                                          ( ( mem @ V12a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                         => ( ( ap @ V7fn @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V10a0 ) ) @ V11a1 ) @ V12a2 ) )
                                            = ( ap @ ( ap @ ( ap @ V1f1 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V10a0 ) ) @ V11a1 ) @ V12a2 ) ) ) )
                                  & ! [V13a0: tp__ty_2Ebinary__ieee_2Erounding,V14a1: $i] :
                                      ( ( mem @ V14a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ! [V15a2: $i] :
                                          ( ( mem @ V15a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                         => ( ( ap @ V7fn @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V13a0 ) ) @ V14a1 ) @ V15a2 ) )
                                            = ( ap @ ( ap @ ( ap @ V2f2 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V13a0 ) ) @ V14a1 ) @ V15a2 ) ) ) )
                                  & ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
                                      ( ( mem @ V17a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ! [V18a2: $i] :
                                          ( ( mem @ V18a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                         => ( ( ap @ V7fn @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 ) @ V18a2 ) )
                                            = ( ap @ ( ap @ ( ap @ V3f3 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 ) @ V18a2 ) ) ) )
                                  & ! [V19a0: tp__ty_2Ebinary__ieee_2Erounding,V20a1: $i] :
                                      ( ( mem @ V20a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ! [V21a2: $i] :
                                          ( ( mem @ V21a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                         => ( ( ap @ V7fn @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19a0 ) ) @ V20a1 ) @ V21a2 ) )
                                            = ( ap @ ( ap @ ( ap @ V4f4 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19a0 ) ) @ V20a1 ) @ V21a2 ) ) ) )
                                  & ! [V22a0: tp__ty_2Ebinary__ieee_2Erounding,V23a1: $i] :
                                      ( ( mem @ V23a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ! [V24a2: $i] :
                                          ( ( mem @ V24a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                         => ! [V25a3: $i] :
                                              ( ( mem @ V25a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                             => ( ( ap @ V7fn @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V22a0 ) ) @ V23a1 ) @ V24a2 ) @ V25a3 ) )
                                                = ( ap @ ( ap @ ( ap @ ( ap @ V5f5 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V22a0 ) ) @ V23a1 ) @ V24a2 ) @ V25a3 ) ) ) ) )
                                  & ! [V26a0: tp__ty_2Ebinary__ieee_2Erounding,V27a1: $i] :
                                      ( ( mem @ V27a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                     => ! [V28a2: $i] :
                                          ( ( mem @ V28a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                         => ! [V29a3: $i] :
                                              ( ( mem @ V29a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                             => ( ( ap @ V7fn @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V26a0 ) ) @ V27a1 ) @ V28a2 ) @ V29a3 ) )
                                                = ( ap @ ( ap @ ( ap @ ( ap @ V6f6 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V26a0 ) ) @ V27a1 ) @ V28a2 ) @ V29a3 ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__induction,axiom,
    ! [A_27t: del,A_27w: del,V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ bool ) )
     => ( ( ! [V1r: tp__ty_2Ebinary__ieee_2Erounding,V2f: $i] :
              ( ( mem @ V2f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V1r ) ) @ V2f ) ) ) )
          & ! [V3r: tp__ty_2Ebinary__ieee_2Erounding,V4f: $i] :
              ( ( mem @ V4f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V5f0: $i] :
                  ( ( mem @ V5f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V3r ) ) @ V4f ) @ V5f0 ) ) ) ) )
          & ! [V6r: tp__ty_2Ebinary__ieee_2Erounding,V7f: $i] :
              ( ( mem @ V7f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V8f0: $i] :
                  ( ( mem @ V8f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V6r ) ) @ V7f ) @ V8f0 ) ) ) ) )
          & ! [V9r: tp__ty_2Ebinary__ieee_2Erounding,V10f: $i] :
              ( ( mem @ V10f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V11f0: $i] :
                  ( ( mem @ V11f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9r ) ) @ V10f ) @ V11f0 ) ) ) ) )
          & ! [V12r: tp__ty_2Ebinary__ieee_2Erounding,V13f: $i] :
              ( ( mem @ V13f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V14f0: $i] :
                  ( ( mem @ V14f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V12r ) ) @ V13f ) @ V14f0 ) ) ) ) )
          & ! [V15r: tp__ty_2Ebinary__ieee_2Erounding,V16f: $i] :
              ( ( mem @ V16f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V17f0: $i] :
                  ( ( mem @ V17f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V18f1: $i] :
                      ( ( mem @ V18f1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V15r ) ) @ V16f ) @ V17f0 ) @ V18f1 ) ) ) ) ) )
          & ! [V19r: tp__ty_2Ebinary__ieee_2Erounding,V20f: $i] :
              ( ( mem @ V20f @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ! [V21f0: $i] :
                  ( ( mem @ V21f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                 => ! [V22f1: $i] :
                      ( ( mem @ V22f1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                     => ( p @ ( ap @ V0P @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V19r ) ) @ V20f ) @ V21f0 ) @ V22f1 ) ) ) ) ) ) )
       => ! [V23f: $i] :
            ( ( mem @ V23f @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
           => ( p @ ( ap @ V0P @ V23f ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__case__cong,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0f_27: $i] :
      ( ( mem @ V0f_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
     => ! [V1f1_27: $i] :
          ( ( mem @ V1f1_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
         => ! [V2f2_27: $i] :
              ( ( mem @ V2f2_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
             => ! [V3f3_27: $i] :
                  ( ( mem @ V3f3_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                 => ! [V4f4_27: $i] :
                      ( ( mem @ V4f4_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V5f5_27: $i] :
                          ( ( mem @ V5f5_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                         => ! [V6f6_27: $i] :
                              ( ( mem @ V6f6_27 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                             => ! [V7M: $i] :
                                  ( ( mem @ V7M @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
                                 => ! [V8M_27: $i] :
                                      ( ( mem @ V8M_27 @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
                                     => ! [V9f: $i] :
                                          ( ( mem @ V9f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
                                         => ! [V10f1: $i] :
                                              ( ( mem @ V10f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                             => ! [V11f2: $i] :
                                                  ( ( mem @ V11f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                                 => ! [V12f3: $i] :
                                                      ( ( mem @ V12f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                                     => ! [V13f4: $i] :
                                                          ( ( mem @ V13f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                                                         => ! [V14f5: $i] :
                                                              ( ( mem @ V14f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                                             => ! [V15f6: $i] :
                                                                  ( ( mem @ V15f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                                                 => ( ( ( V7M = V8M_27 )
                                                                      & ! [V16a0: tp__ty_2Ebinary__ieee_2Erounding,V17a1: $i] :
                                                                          ( ( mem @ V17a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ( ( V8M_27
                                                                              = ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 ) )
                                                                           => ( ( ap @ ( ap @ V9f @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 )
                                                                              = ( ap @ ( ap @ V0f_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V16a0 ) ) @ V17a1 ) ) ) )
                                                                      & ! [V18a0: tp__ty_2Ebinary__ieee_2Erounding,V19a1: $i] :
                                                                          ( ( mem @ V19a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ! [V20a2: $i] :
                                                                              ( ( mem @ V20a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                             => ( ( V8M_27
                                                                                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V18a0 ) ) @ V19a1 ) @ V20a2 ) )
                                                                               => ( ( ap @ ( ap @ ( ap @ V10f1 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V18a0 ) ) @ V19a1 ) @ V20a2 )
                                                                                  = ( ap @ ( ap @ ( ap @ V1f1_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V18a0 ) ) @ V19a1 ) @ V20a2 ) ) ) ) )
                                                                      & ! [V21a0: tp__ty_2Ebinary__ieee_2Erounding,V22a1: $i] :
                                                                          ( ( mem @ V22a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ! [V23a2: $i] :
                                                                              ( ( mem @ V23a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                             => ( ( V8M_27
                                                                                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V21a0 ) ) @ V22a1 ) @ V23a2 ) )
                                                                               => ( ( ap @ ( ap @ ( ap @ V11f2 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V21a0 ) ) @ V22a1 ) @ V23a2 )
                                                                                  = ( ap @ ( ap @ ( ap @ V2f2_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V21a0 ) ) @ V22a1 ) @ V23a2 ) ) ) ) )
                                                                      & ! [V24a0: tp__ty_2Ebinary__ieee_2Erounding,V25a1: $i] :
                                                                          ( ( mem @ V25a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ! [V26a2: $i] :
                                                                              ( ( mem @ V26a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                             => ( ( V8M_27
                                                                                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V24a0 ) ) @ V25a1 ) @ V26a2 ) )
                                                                               => ( ( ap @ ( ap @ ( ap @ V12f3 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V24a0 ) ) @ V25a1 ) @ V26a2 )
                                                                                  = ( ap @ ( ap @ ( ap @ V3f3_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V24a0 ) ) @ V25a1 ) @ V26a2 ) ) ) ) )
                                                                      & ! [V27a0: tp__ty_2Ebinary__ieee_2Erounding,V28a1: $i] :
                                                                          ( ( mem @ V28a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ! [V29a2: $i] :
                                                                              ( ( mem @ V29a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                             => ( ( V8M_27
                                                                                  = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V27a0 ) ) @ V28a1 ) @ V29a2 ) )
                                                                               => ( ( ap @ ( ap @ ( ap @ V13f4 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V27a0 ) ) @ V28a1 ) @ V29a2 )
                                                                                  = ( ap @ ( ap @ ( ap @ V4f4_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V27a0 ) ) @ V28a1 ) @ V29a2 ) ) ) ) )
                                                                      & ! [V30a0: tp__ty_2Ebinary__ieee_2Erounding,V31a1: $i] :
                                                                          ( ( mem @ V31a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ! [V32a2: $i] :
                                                                              ( ( mem @ V32a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                             => ! [V33a3: $i] :
                                                                                  ( ( mem @ V33a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                                 => ( ( V8M_27
                                                                                      = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V30a0 ) ) @ V31a1 ) @ V32a2 ) @ V33a3 ) )
                                                                                   => ( ( ap @ ( ap @ ( ap @ ( ap @ V14f5 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V30a0 ) ) @ V31a1 ) @ V32a2 ) @ V33a3 )
                                                                                      = ( ap @ ( ap @ ( ap @ ( ap @ V5f5_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V30a0 ) ) @ V31a1 ) @ V32a2 ) @ V33a3 ) ) ) ) ) )
                                                                      & ! [V34a0: tp__ty_2Ebinary__ieee_2Erounding,V35a1: $i] :
                                                                          ( ( mem @ V35a1 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                         => ! [V36a2: $i] :
                                                                              ( ( mem @ V36a2 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                             => ! [V37a3: $i] :
                                                                                  ( ( mem @ V37a3 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                                                 => ( ( V8M_27
                                                                                      = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V34a0 ) ) @ V35a1 ) @ V36a2 ) @ V37a3 ) )
                                                                                   => ( ( ap @ ( ap @ ( ap @ ( ap @ V15f6 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V34a0 ) ) @ V35a1 ) @ V36a2 ) @ V37a3 )
                                                                                      = ( ap @ ( ap @ ( ap @ ( ap @ V6f6_27 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V34a0 ) ) @ V35a1 ) @ V36a2 ) @ V37a3 ) ) ) ) ) ) )
                                                                   => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ V7M ) @ V9f ) @ V10f1 ) @ V11f2 ) @ V12f3 ) @ V13f4 ) @ V14f5 ) @ V15f6 )
                                                                      = ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ V8M_27 ) @ V0f_27 ) @ V1f1_27 ) @ V2f2_27 ) @ V3f3_27 ) @ V4f4_27 ) @ V5f5_27 ) @ V6f6_27 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efp__op__case__eq,axiom,
    ! [A_27a: del,A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
     => ! [V1f: $i] :
          ( ( mem @ V1f @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) )
         => ! [V2f1: $i] :
              ( ( mem @ V2f1 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
             => ! [V3f2: $i] :
                  ( ( mem @ V3f2 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                 => ! [V4f3: $i] :
                      ( ( mem @ V4f3 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                     => ! [V5f4: $i] :
                          ( ( mem @ V5f4 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) )
                         => ! [V6f5: $i] :
                              ( ( mem @ V6f5 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                             => ! [V7f6: $i] :
                                  ( ( mem @ V7f6 @ ( arr @ ty_2Ebinary__ieee_2Erounding @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ A_27a ) ) ) ) )
                                 => ! [V8v: $i] :
                                      ( ( mem @ V8v @ A_27a )
                                     => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efp__op__CASE @ A_27a @ A_27t @ A_27w ) @ V0x ) @ V1f ) @ V2f1 ) @ V3f2 ) @ V4f3 ) @ V5f4 ) @ V6f5 ) @ V7f6 )
                                          = V8v )
                                      <=> ( ? [V9r: tp__ty_2Ebinary__ieee_2Erounding,V10f_27: $i] :
                                              ( ( mem @ V10f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ( V0x
                                                = ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9r ) ) @ V10f_27 ) )
                                              & ( ( ap @ ( ap @ V1f @ ( inj__ty_2Ebinary__ieee_2Erounding @ V9r ) ) @ V10f_27 )
                                                = V8v ) )
                                          | ? [V11r: tp__ty_2Ebinary__ieee_2Erounding,V12f_27: $i] :
                                              ( ( mem @ V12f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ? [V13f0: $i] :
                                                  ( ( mem @ V13f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  & ( V0x
                                                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V11r ) ) @ V12f_27 ) @ V13f0 ) )
                                                  & ( ( ap @ ( ap @ ( ap @ V2f1 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V11r ) ) @ V12f_27 ) @ V13f0 )
                                                    = V8v ) ) )
                                          | ? [V14r: tp__ty_2Ebinary__ieee_2Erounding,V15f_27: $i] :
                                              ( ( mem @ V15f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ? [V16f0: $i] :
                                                  ( ( mem @ V16f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  & ( V0x
                                                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V14r ) ) @ V15f_27 ) @ V16f0 ) )
                                                  & ( ( ap @ ( ap @ ( ap @ V3f2 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V14r ) ) @ V15f_27 ) @ V16f0 )
                                                    = V8v ) ) )
                                          | ? [V17r: tp__ty_2Ebinary__ieee_2Erounding,V18f_27: $i] :
                                              ( ( mem @ V18f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ? [V19f0: $i] :
                                                  ( ( mem @ V19f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  & ( V0x
                                                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V17r ) ) @ V18f_27 ) @ V19f0 ) )
                                                  & ( ( ap @ ( ap @ ( ap @ V4f3 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V17r ) ) @ V18f_27 ) @ V19f0 )
                                                    = V8v ) ) )
                                          | ? [V20r: tp__ty_2Ebinary__ieee_2Erounding,V21f_27: $i] :
                                              ( ( mem @ V21f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ? [V22f0: $i] :
                                                  ( ( mem @ V22f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  & ( V0x
                                                    = ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V20r ) ) @ V21f_27 ) @ V22f0 ) )
                                                  & ( ( ap @ ( ap @ ( ap @ V5f4 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V20r ) ) @ V21f_27 ) @ V22f0 )
                                                    = V8v ) ) )
                                          | ? [V23r: tp__ty_2Ebinary__ieee_2Erounding,V24f_27: $i] :
                                              ( ( mem @ V24f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ? [V25f0: $i] :
                                                  ( ( mem @ V25f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  & ? [V26f1_27: $i] :
                                                      ( ( mem @ V26f1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                      & ( V0x
                                                        = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V23r ) ) @ V24f_27 ) @ V25f0 ) @ V26f1_27 ) )
                                                      & ( ( ap @ ( ap @ ( ap @ ( ap @ V6f5 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V23r ) ) @ V24f_27 ) @ V25f0 ) @ V26f1_27 )
                                                        = V8v ) ) ) )
                                          | ? [V27r: tp__ty_2Ebinary__ieee_2Erounding,V28f_27: $i] :
                                              ( ( mem @ V28f_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                              & ? [V29f0: $i] :
                                                  ( ( mem @ V29f0 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                  & ? [V30f1_27: $i] :
                                                      ( ( mem @ V30f1_27 @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
                                                      & ( V0x
                                                        = ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V27r ) ) @ V28f_27 ) @ V29f0 ) @ V30f1_27 ) )
                                                      & ( ( ap @ ( ap @ ( ap @ ( ap @ V7f6 @ ( inj__ty_2Ebinary__ieee_2Erounding @ V27r ) ) @ V28f_27 ) @ V29f0 ) @ V30f1_27 )
                                                        = V8v ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__some__qnan__def,axiom,
    ! [A_27t: del,A_27w: del,V0fp__op: $i] :
      ( ( mem @ V0fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
     => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V0fp__op )
        = ( ap
          @ ( ap @ ( c_2Emin_2E_40 @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
            @ ( lam @ ( arr @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
              @ ^ [V1f: $i] :
                  ( ap
                  @ ( ap @ ( c_2Ebool_2ELET @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ bool )
                    @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                      @ ^ [V2qnan: $i] : ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V2qnan ) ) @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27t @ A_27w ) @ V2qnan ) ) ) ) )
                  @ ( ap @ V1f @ V0fp__op ) ) ) )
          @ V0fp__op ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__round__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1toneg: $i] :
      ( ( mem @ V1toneg @ bool )
     => ! [V2r: tp__ty_2Erealax_2Ereal] :
          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1toneg ) @ ( inj__ty_2Erealax_2Ereal @ V2r ) )
          = ( ap
            @ ( ap @ ( c_2Ebool_2ELET @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
              @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                @ ^ [V3x: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ V3x ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1toneg ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) @ V3x ) ) )
            @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eround @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Erealax_2Ereal @ V2r ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__round__with__flags__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1to__neg: $i] :
      ( ( mem @ V1to__neg @ bool )
     => ! [V2r: tp__ty_2Erealax_2Ereal] :
          ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1to__neg ) @ ( inj__ty_2Erealax_2Ereal @ V2r ) )
          = ( ap
            @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
              @ ( ap
                @ ( ap @ ( c_2Ebool_2ELET @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) )
                  @ ( lam @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w )
                    @ ^ [V3x: $i] :
                        ( lam @ ty_2Erealax_2Ereal
                        @ ^ [V4a: $i] :
                            ( ap
                            @ ( ap @ ( c_2Ebool_2ELET @ bool @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                              @ ( lam @ bool
                                @ ^ [V5inexact: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Overflow__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3x ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2EINT__MIN @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) @ V4a ) ) ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__BeforeRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5inexact ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ V4a ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Underflow__AfterRounding__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5inexact ) @ ( ap @ ( ap @ ( c_2Ewords_2Eword__ls @ ( ty_2Esum_2Esum @ A_27w @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ ( ty_2Esum_2Esum @ A_27w @ ty_2Eone_2Eone ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ ( ty_2Esum_2Esum @ A_27w @ ty_2Eone_2Eone ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1to__neg ) @ ( inj__ty_2Erealax_2Ereal @ V2r ) ) ) ) @ ( ap @ ( c_2Ewords_2En2w @ ( ty_2Esum_2Esum @ A_27w @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ewords_2EINT__MIN @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__Precision__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ V5inexact ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) ) ) ) ) @ V3x ) ) )
                            @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V3x ) ) @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( inj__ty_2Erealax_2Ereal @ V2r ) ) ) ) ) ) ) )
                @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1to__neg ) @ ( inj__ty_2Erealax_2Ereal @ V2r ) ) ) )
            @ ( ap @ c_2Ereal_2Eabs @ ( inj__ty_2Erealax_2Ereal @ V2r ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Echeck__for__signalling__def,axiom,
    ! [A_27a: del,A_27b: del,V0l: $i] :
      ( ( mem @ V0l @ ( ty_2Elist_2Elist @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) )
     => ( ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27a @ A_27b ) @ V0l ) )
        = ( surj__ty_2Ebinary__ieee_2Eflags @ ( ap @ ( ap @ c_2Ebinary__ieee_2Eflags__InvalidOp__fupd @ ( ap @ ( c_2Ecombin_2EK @ bool @ bool ) @ ( ap @ ( ap @ ( c_2Elist_2EEXISTS @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) ) @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27a @ A_27b ) ) @ V0l ) ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Ereal__to__float__def,axiom,
    ! [A_27a: del,A_27b: del,V0m: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( ap @ ( c_2Ebinary__ieee_2Ereal__to__float @ A_27a @ A_27b ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0m ) )
      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round @ A_27a @ A_27b ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0m ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Erounding ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0m ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Ereal__to__float__with__flags__def,axiom,
    ! [A_27a: del,A_27b: del,V0m: tp__ty_2Ebinary__ieee_2Erounding] :
      ( ( ap @ ( c_2Ebinary__ieee_2Ereal__to__float__with__flags @ A_27a @ A_27b ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0m ) )
      = ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27a @ A_27b ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0m ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Erounding ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0m ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__round__to__integral__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__to__integral @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x )
        = ( ap
          @ ( ap
            @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) )
              @ ( lam @ ty_2Erealax_2Ereal
                @ ^ [V2r: $i] : ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eintegral__round @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V2r ) ) )
            @ V1x )
          @ V1x ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__to__int__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__int @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) )
        = ( surj__c_ty_2Eoption_2Eoption_ty_2Einteger_2Eint
          @ ( ap
            @ ( ap
              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Eoption_2Eoption @ ty_2Einteger_2Eint ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) )
                @ ( lam @ ty_2Erealax_2Ereal
                  @ ^ [V2r: $i] :
                      ( ap @ ( c_2Eoption_2ESOME @ ty_2Einteger_2Eint )
                      @ ( ap
                        @ ( ap
                          @ ( ap
                            @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Erounding__CASE @ ty_2Einteger_2Eint ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) )
                              @ ( ap
                                @ ( ap @ ( c_2Ebool_2ELET @ ty_2Einteger_2Eint @ ty_2Einteger_2Eint )
                                  @ ( lam @ ty_2Einteger_2Eint
                                    @ ^ [V3f: $i] :
                                        ( ap
                                        @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ty_2Einteger_2Eint )
                                          @ ( lam @ ty_2Erealax_2Ereal
                                            @ ^ [V4df: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Einteger_2Eint ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ V4df ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V4df ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ c_2Earithmetic_2EEVEN @ ( ap @ c_2Einteger_2ENum @ ( ap @ c_2Einteger_2EABS @ V3f ) ) ) ) ) ) @ V3f ) @ ( ap @ c_2Eintreal_2EINT__CEILING @ V2r ) ) ) )
                                        @ ( ap @ c_2Ereal_2Eabs @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ V2r ) @ ( ap @ c_2Eintreal_2Ereal__of__int @ V3f ) ) ) ) ) )
                                @ ( ap @ c_2Eintreal_2EINT__FLOOR @ V2r ) ) )
                            @ ( ap @ c_2Eintreal_2EINT__CEILING @ V2r ) )
                          @ ( ap @ c_2Eintreal_2EINT__FLOOR @ V2r ) )
                        @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Einteger_2Eint ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ c_2Eintreal_2EINT__CEILING @ V2r ) ) @ ( ap @ c_2Eintreal_2EINT__FLOOR @ V2r ) ) ) ) ) )
              @ ( c_2Eoption_2ENONE @ ty_2Einteger_2Eint ) )
            @ ( c_2Eoption_2ENONE @ ty_2Einteger_2Eint ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__sqrt__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x )
        = ( ap
          @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
            @ ( ap
              @ ( ap
                @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) )
                  @ ( lam @ ty_2Erealax_2Ereal
                    @ ^ [V2r: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ c_2Ebool_2EF ) @ ( ap @ c_2Etransc_2Esqrt @ V2r ) ) ) )
                @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
              @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) ) ) ) )
          @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sqrt @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__add__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V2y: $i] :
          ( ( mem @ V2y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y )
            = ( ap @ ( ap @ ( c_2Epair_2Epair__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V2y ) ) )
              @ ( lam @ ty_2Ebinary__ieee_2Efloat__value
                @ ^ [V3v: $i] :
                    ( lam @ ty_2Ebinary__ieee_2Efloat__value
                    @ ^ [V4v1: $i] :
                        ( ap
                        @ ( ap
                          @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V3v )
                            @ ( lam @ ty_2Erealax_2Ereal
                              @ ^ [V5r1: $i] :
                                  ( ap
                                  @ ( ap
                                    @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                      @ ( lam @ ty_2Erealax_2Ereal
                                        @ ^ [V6r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V5r1 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V6r2 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Erounding ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__add @ V5r1 ) @ V6r2 ) ) ) )
                                    @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ V2y ) )
                                  @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) )
                          @ ( ap
                            @ ( ap
                              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                @ ( lam @ ty_2Erealax_2Ereal
                                  @ ^ [V7v7: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ V1x ) ) )
                              @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ V1x ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) )
                            @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) )
                        @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__sub__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V2y: $i] :
          ( ( mem @ V2y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y )
            = ( ap @ ( ap @ ( c_2Epair_2Epair__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V2y ) ) )
              @ ( lam @ ty_2Ebinary__ieee_2Efloat__value
                @ ^ [V3v: $i] :
                    ( lam @ ty_2Ebinary__ieee_2Efloat__value
                    @ ^ [V4v1: $i] :
                        ( ap
                        @ ( ap
                          @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V3v )
                            @ ( lam @ ty_2Erealax_2Ereal
                              @ ^ [V5r1: $i] :
                                  ( ap
                                  @ ( ap
                                    @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                      @ ( lam @ ty_2Erealax_2Ereal
                                        @ ^ [V6r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V5r1 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V6r2 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Erounding ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ V5r1 ) @ V6r2 ) ) ) )
                                    @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ V2y ) ) )
                                  @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) )
                          @ ( ap
                            @ ( ap
                              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                @ ( lam @ ty_2Erealax_2Ereal
                                  @ ^ [V7v7: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ V1x ) ) )
                              @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ V1x ) ) )
                            @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) )
                        @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__mul__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V2y: $i] :
          ( ( mem @ V2y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y )
            = ( ap @ ( ap @ ( c_2Epair_2Epair__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V2y ) ) )
              @ ( lam @ ty_2Ebinary__ieee_2Efloat__value
                @ ^ [V3v: $i] :
                    ( lam @ ty_2Ebinary__ieee_2Efloat__value
                    @ ^ [V4v1: $i] :
                        ( ap
                        @ ( ap
                          @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V3v )
                            @ ( lam @ ty_2Erealax_2Ereal
                              @ ^ [V5r_27: $i] :
                                  ( ap
                                  @ ( ap
                                    @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                      @ ( lam @ ty_2Erealax_2Ereal
                                        @ ^ [V6r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ V5r_27 ) @ V6r2 ) ) ) )
                                    @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V5r_27 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) )
                                  @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) )
                          @ ( ap
                            @ ( ap
                              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                @ ( lam @ ty_2Erealax_2Ereal
                                  @ ^ [V7r: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V7r ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ) )
                              @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) )
                            @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) )
                        @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Mul @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__div__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V2y: $i] :
          ( ( mem @ V2y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y )
            = ( ap @ ( ap @ ( c_2Epair_2Epair__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V2y ) ) )
              @ ( lam @ ty_2Ebinary__ieee_2Efloat__value
                @ ^ [V3v: $i] :
                    ( lam @ ty_2Ebinary__ieee_2Efloat__value
                    @ ^ [V4v1: $i] :
                        ( ap
                        @ ( ap
                          @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V3v )
                            @ ( lam @ ty_2Erealax_2Ereal
                              @ ^ [V5r1: $i] :
                                  ( ap
                                  @ ( ap
                                    @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                      @ ( lam @ ty_2Erealax_2Ereal
                                        @ ^ [V6r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V6r2 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V5r1 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Edividezero__flags ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ V5r1 ) @ V6r2 ) ) ) ) )
                                    @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) )
                                  @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) )
                          @ ( ap
                            @ ( ap
                              @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ V4v1 )
                                @ ( lam @ ty_2Erealax_2Ereal
                                  @ ^ [V7v7: $i] : ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) )
                              @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) )
                            @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) )
                        @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__Div @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__mul__add__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V2y: $i] :
          ( ( mem @ V2y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V3z: $i] :
              ( ( mem @ V3z @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__mul__add @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) @ V3z )
                = ( ap
                  @ ( ap @ ( c_2Ebool_2ELET @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                    @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone )
                      @ ^ [V4signP: $i] :
                          ( ap
                          @ ( ap @ ( c_2Ebool_2ELET @ bool @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                            @ ( lam @ bool
                              @ ^ [V5infP: $i] :
                                  ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V2y ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V3z ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V3z ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) @ V3z ) ) ) )
                                  @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5infP ) @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) @ V3z ) ) ) )
                                    @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5infP ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
                                      @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5infP ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
                                        @ ( ap
                                          @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                                            @ ( ap
                                              @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) )
                                                @ ( lam @ ty_2Erealax_2Ereal
                                                  @ ^ [V6r1: $i] :
                                                      ( lam @ ty_2Erealax_2Ereal
                                                      @ ^ [V7r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V6r1 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V7r2 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Erounding ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__add @ V6r1 ) @ V7r2 ) ) ) ) )
                                              @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V2y ) ) ) )
                                          @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V3z ) ) ) ) ) ) ) )
                          @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V2y ) ) ) ) )
                  @ ( ap @ ( ap @ ( c_2Ewords_2Eword__xor @ ty_2Eone_2Eone ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__mul__sub__def,axiom,
    ! [A_27t: del,A_27w: del,V0mode: tp__ty_2Ebinary__ieee_2Erounding,V1x: $i] :
      ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V2y: $i] :
          ( ( mem @ V2y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ! [V3z: $i] :
              ( ( mem @ V3z @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
             => ( ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__mul__sub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) @ V3z )
                = ( ap
                  @ ( ap @ ( c_2Ebool_2ELET @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                    @ ( lam @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone )
                      @ ^ [V4signP: $i] :
                          ( ap
                          @ ( ap @ ( c_2Ebool_2ELET @ bool @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                            @ ( lam @ bool
                              @ ^ [V5infP: $i] :
                                  ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V2y ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ V3z ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Echeck__for__signalling @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V1x ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V2y ) @ ( ap @ ( ap @ ( c_2Elist_2ECONS @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ V3z ) @ ( c_2Elist_2ENIL @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulSub @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) @ V3z ) ) ) )
                                  @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V2y ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5infP ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Einvalidop__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2EFP__MulAdd @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ V1x ) @ V2y ) @ V3z ) ) ) )
                                    @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5infP ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
                                      @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ V5infP ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( inj__ty_2Ebinary__ieee_2Eflags @ fo__c_2Ebinary__ieee_2Eclear__flags ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
                                        @ ( ap
                                          @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) )
                                            @ ( ap
                                              @ ( ap @ ( c_2Ebool_2ELET @ ty_2Erealax_2Ereal @ ( arr @ ty_2Erealax_2Ereal @ ( ty_2Epair_2Eprod @ ty_2Ebinary__ieee_2Eflags @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) )
                                                @ ( lam @ ty_2Erealax_2Ereal
                                                  @ ^ [V6r1: $i] :
                                                      ( lam @ ty_2Erealax_2Ereal
                                                      @ ^ [V7r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__round__with__flags @ A_27t @ A_27w ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ bool ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V6r1 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ ( ap @ c_2Ebool_2E_2F_5C @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V7r2 ) @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) @ ( ap @ c_2Ebool_2E_7E @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V3z ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ V4signP ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Ebinary__ieee_2Erounding ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ V0mode ) ) @ ( inj__ty_2Ebinary__ieee_2Erounding @ fo__c_2Ebinary__ieee_2EroundTowardNegative ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Ereal__sub @ V6r1 ) @ V7r2 ) ) ) ) )
                                              @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V2y ) ) ) )
                                          @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ V3z ) ) ) ) ) ) ) )
                          @ ( ap @ ( ap @ c_2Ebool_2E_5C_2F @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V2y ) ) ) ) )
                  @ ( ap @ ( ap @ ( c_2Ewords_2Eword__xor @ ty_2Eone_2Eone ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V2y ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__compare__TY__DEF,axiom,
    ? [V0rep: $i] :
      ( ( mem @ V0rep @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ty_2Enum_2Enum ) )
      & ( p
        @ ( ap
          @ ( ap @ ( c_2Ebool_2ETYPE__DEFINITION @ ty_2Enum_2Enum @ ty_2Ebinary__ieee_2Efloat__compare )
            @ ( lam @ ty_2Enum_2Enum
              @ ^ [V1n: $i] : ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V1n ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
          @ V0rep ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__compare__BIJ,axiom,
    ( ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
        ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0a ) ) ) )
        = V0a )
    & ! [V1r: tp__ty_2Enum_2Enum] :
        ( ( p
          @ ( ap
            @ ( lam @ ty_2Enum_2Enum
              @ ^ [V2n: $i] : ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V2n ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
            @ ( inj__ty_2Enum_2Enum @ V1r ) ) )
      <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ V1r ) ) ) )
          = V1r ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2float__compare__float__compare2num,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0a ) ) ) )
      = V0a ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare2num__num2float__compare,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V0r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ V0r ) ) ) )
        = V0r ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2float__compare__11,axiom,
    ! [V0r: tp__ty_2Enum_2Enum,V1r_27: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V0r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
     => ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V1r_27 ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
       => ( ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ V0r ) ) )
            = ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ V1r_27 ) ) ) )
        <=> ( V0r = V1r_27 ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare2num__11,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare,V1a_27: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0a ) ) )
        = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V1a_27 ) ) ) )
    <=> ( V0a = V1a_27 ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2float__compare__ONTO,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
    ? [V1r: tp__ty_2Enum_2Enum] :
      ( ( V0a
        = ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ V1r ) ) ) )
      & ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V1r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare2num__ONTO,axiom,
    ! [V0r: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( inj__ty_2Enum_2Enum @ V0r ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
    <=> ? [V1a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
          ( V0r
          = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V1a ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Enum2float__compare__thm,axiom,
    ( ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      = fo__c_2Ebinary__ieee_2ELT )
    & ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = fo__c_2Ebinary__ieee_2EEQ )
    & ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      = fo__c_2Ebinary__ieee_2EGT )
    & ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ c_2Ebinary__ieee_2Enum2float__compare @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      = fo__c_2Ebinary__ieee_2EUN ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare2num__thm,axiom,
    ( ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) )
      = fo__c_2Enum_2E0 )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) ) )
      = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) )
      = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
    & ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) )
      = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__EQ__float__compare,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare,V1a_27: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( V0a = V1a_27 )
    <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0a ) ) )
        = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V1a_27 ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__compare__size__def,axiom,
    ! [V0x: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( surj__ty_2Enum_2Enum @ ( ap @ c_2Ebinary__ieee_2Efloat__compare__size @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0x ) ) )
      = fo__c_2Enum_2E0 ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__compare__CASE,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Efloat__compare,V1v0: $i] :
      ( ( mem @ V1v0 @ A_27a )
     => ! [V2v1: $i] :
          ( ( mem @ V2v1 @ A_27a )
         => ! [V3v2: $i] :
              ( ( mem @ V3v2 @ A_27a )
             => ! [V4v3: $i] :
                  ( ( mem @ V4v3 @ A_27a )
                 => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0x ) ) @ V1v0 ) @ V2v1 ) @ V3v2 ) @ V4v3 )
                    = ( ap
                      @ ( lam @ ty_2Enum_2Enum
                        @ ^ [V5m: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ A_27a ) @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V5m ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ V1v0 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ A_27a ) @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ V5m ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ V2v1 ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ A_27a ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Enum_2Enum ) @ V5m ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ V3v2 ) @ V4v3 ) ) ) )
                      @ ( ap @ c_2Ebinary__ieee_2Efloat__compare2num @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0x ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__case__def,axiom,
    ! [A_27a: del] :
      ( ! [V0v0: $i] :
          ( ( mem @ V0v0 @ A_27a )
         => ! [V1v1: $i] :
              ( ( mem @ V1v1 @ A_27a )
             => ! [V2v2: $i] :
                  ( ( mem @ V2v2 @ A_27a )
                 => ! [V3v3: $i] :
                      ( ( mem @ V3v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) @ V0v0 ) @ V1v1 ) @ V2v2 ) @ V3v3 )
                        = V0v0 ) ) ) ) )
      & ! [V4v0: $i] :
          ( ( mem @ V4v0 @ A_27a )
         => ! [V5v1: $i] :
              ( ( mem @ V5v1 @ A_27a )
             => ! [V6v2: $i] :
                  ( ( mem @ V6v2 @ A_27a )
                 => ! [V7v3: $i] :
                      ( ( mem @ V7v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) ) @ V4v0 ) @ V5v1 ) @ V6v2 ) @ V7v3 )
                        = V5v1 ) ) ) ) )
      & ! [V8v0: $i] :
          ( ( mem @ V8v0 @ A_27a )
         => ! [V9v1: $i] :
              ( ( mem @ V9v1 @ A_27a )
             => ! [V10v2: $i] :
                  ( ( mem @ V10v2 @ A_27a )
                 => ! [V11v3: $i] :
                      ( ( mem @ V11v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) @ V8v0 ) @ V9v1 ) @ V10v2 ) @ V11v3 )
                        = V10v2 ) ) ) ) )
      & ! [V12v0: $i] :
          ( ( mem @ V12v0 @ A_27a )
         => ! [V13v1: $i] :
              ( ( mem @ V13v1 @ A_27a )
             => ! [V14v2: $i] :
                  ( ( mem @ V14v2 @ A_27a )
                 => ! [V15v3: $i] :
                      ( ( mem @ V15v3 @ A_27a )
                     => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) @ V12v0 ) @ V13v1 ) @ V14v2 ) @ V15v3 )
                        = V15v3 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Edatatype__float__compare,axiom,
    ! [V0float__compare: $i] :
      ( ( mem @ V0float__compare @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ bool ) ) ) ) )
     => ( p @ ( ap @ ( c_2Ebool_2EDATATYPE @ bool ) @ ( ap @ ( ap @ ( ap @ ( ap @ V0float__compare @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__distinct,axiom,
    ( ( fo__c_2Ebinary__ieee_2ELT != fo__c_2Ebinary__ieee_2EEQ )
    & ( fo__c_2Ebinary__ieee_2ELT != fo__c_2Ebinary__ieee_2EGT )
    & ( fo__c_2Ebinary__ieee_2ELT != fo__c_2Ebinary__ieee_2EUN )
    & ( fo__c_2Ebinary__ieee_2EEQ != fo__c_2Ebinary__ieee_2EGT )
    & ( fo__c_2Ebinary__ieee_2EEQ != fo__c_2Ebinary__ieee_2EUN )
    & ( fo__c_2Ebinary__ieee_2EGT != fo__c_2Ebinary__ieee_2EUN ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__nchotomy,axiom,
    ! [V0a: tp__ty_2Ebinary__ieee_2Efloat__compare] :
      ( ( V0a = fo__c_2Ebinary__ieee_2ELT )
      | ( V0a = fo__c_2Ebinary__ieee_2EEQ )
      | ( V0a = fo__c_2Ebinary__ieee_2EGT )
      | ( V0a = fo__c_2Ebinary__ieee_2EUN ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__Axiom,axiom,
    ! [A_27a: del,V0x0: $i] :
      ( ( mem @ V0x0 @ A_27a )
     => ! [V1x1: $i] :
          ( ( mem @ V1x1 @ A_27a )
         => ! [V2x2: $i] :
              ( ( mem @ V2x2 @ A_27a )
             => ! [V3x3: $i] :
                  ( ( mem @ V3x3 @ A_27a )
                 => ? [V4f: $i] :
                      ( ( mem @ V4f @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ A_27a ) )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) )
                        = V0x0 )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) )
                        = V1x1 )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) )
                        = V2x2 )
                      & ( ( ap @ V4f @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) )
                        = V3x3 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__induction,axiom,
    ! [V0P: $i] :
      ( ( mem @ V0P @ ( arr @ ty_2Ebinary__ieee_2Efloat__compare @ bool ) )
     => ( ( ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) )
          & ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) ) )
       => ! [V1a: tp__ty_2Ebinary__ieee_2Efloat__compare] : ( p @ ( ap @ V0P @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V1a ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__case__cong,axiom,
    ! [A_27a: del,V0v0_27: $i] :
      ( ( mem @ V0v0_27 @ A_27a )
     => ! [V1v1_27: $i] :
          ( ( mem @ V1v1_27 @ A_27a )
         => ! [V2v2_27: $i] :
              ( ( mem @ V2v2_27 @ A_27a )
             => ! [V3v3_27: $i] :
                  ( ( mem @ V3v3_27 @ A_27a )
                 => ! [V4M: tp__ty_2Ebinary__ieee_2Efloat__compare,V5M_27: tp__ty_2Ebinary__ieee_2Efloat__compare,V6v0: $i] :
                      ( ( mem @ V6v0 @ A_27a )
                     => ! [V7v1: $i] :
                          ( ( mem @ V7v1 @ A_27a )
                         => ! [V8v2: $i] :
                              ( ( mem @ V8v2 @ A_27a )
                             => ! [V9v3: $i] :
                                  ( ( mem @ V9v3 @ A_27a )
                                 => ( ( ( V4M = V5M_27 )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2ELT )
                                       => ( V6v0 = V0v0_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EEQ )
                                       => ( V7v1 = V1v1_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EGT )
                                       => ( V8v2 = V2v2_27 ) )
                                      & ( ( V5M_27 = fo__c_2Ebinary__ieee_2EUN )
                                       => ( V9v3 = V3v3_27 ) ) )
                                   => ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V4M ) ) @ V6v0 ) @ V7v1 ) @ V8v2 ) @ V9v3 )
                                      = ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V5M_27 ) ) @ V0v0_27 ) @ V1v1_27 ) @ V2v2_27 ) @ V3v3_27 ) ) ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__compare__case__eq,axiom,
    ! [A_27a: del,V0x: tp__ty_2Ebinary__ieee_2Efloat__compare,V1v0: $i] :
      ( ( mem @ V1v0 @ A_27a )
     => ! [V2v1: $i] :
          ( ( mem @ V2v1 @ A_27a )
         => ! [V3v2: $i] :
              ( ( mem @ V3v2 @ A_27a )
             => ! [V4v3: $i] :
                  ( ( mem @ V4v3 @ A_27a )
                 => ! [V5v: $i] :
                      ( ( mem @ V5v @ A_27a )
                     => ( ( ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ A_27a ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ V0x ) ) @ V1v0 ) @ V2v1 ) @ V3v2 ) @ V4v3 )
                          = V5v )
                      <=> ( ( ( V0x = fo__c_2Ebinary__ieee_2ELT )
                            & ( V1v0 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EEQ )
                            & ( V2v1 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EGT )
                            & ( V3v2 = V5v ) )
                          | ( ( V0x = fo__c_2Ebinary__ieee_2EUN )
                            & ( V4v3 = V5v ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__compare__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1y: $i] :
          ( ( mem @ V1y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
            = ( surj__ty_2Ebinary__ieee_2Efloat__compare
              @ ( ap @ ( ap @ ( c_2Epair_2Epair__CASE @ ty_2Ebinary__ieee_2Efloat__compare @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( ap @ ( c_2Epair_2E_2C @ ty_2Ebinary__ieee_2Efloat__value @ ty_2Ebinary__ieee_2Efloat__value ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V0x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ V1y ) ) )
                @ ( lam @ ty_2Ebinary__ieee_2Efloat__value
                  @ ^ [V2v: $i] :
                      ( lam @ ty_2Ebinary__ieee_2Efloat__value
                      @ ^ [V3v1: $i] :
                          ( ap
                          @ ( ap
                            @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ty_2Ebinary__ieee_2Efloat__compare ) @ V2v )
                              @ ( lam @ ty_2Erealax_2Ereal
                                @ ^ [V4r1: $i] :
                                    ( ap
                                    @ ( ap
                                      @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ty_2Ebinary__ieee_2Efloat__compare ) @ V3v1 )
                                        @ ( lam @ ty_2Erealax_2Ereal
                                          @ ^ [V5r2: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__compare ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ V4r1 ) @ V5r2 ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__compare ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ty_2Erealax_2Ereal ) @ V4r1 ) @ V5r2 ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) ) ) )
                                      @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__compare ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1y ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) )
                                    @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) ) )
                            @ ( ap
                              @ ( ap
                                @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value__CASE @ ty_2Ebinary__ieee_2Efloat__compare ) @ V3v1 )
                                  @ ( lam @ ty_2Erealax_2Ereal
                                    @ ^ [V6v7: $i] : ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__compare ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0x ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) ) )
                                @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__compare ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0x ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1y ) ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EEQ ) ) @ ( ap @ ( ap @ ( ap @ ( c_2Ebool_2ECOND @ ty_2Ebinary__ieee_2Efloat__compare ) @ ( ap @ ( ap @ ( c_2Emin_2E_3D @ ( ty_2Efcp_2Ecart @ bool @ ty_2Eone_2Eone ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0x ) ) @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2ELT ) ) @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EGT ) ) ) )
                              @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) )
                          @ ( inj__ty_2Ebinary__ieee_2Efloat__compare @ fo__c_2Ebinary__ieee_2EUN ) ) ) ) ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__less__than__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1y: $i] :
          ( ( mem @ V1y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( p @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__less__than @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
          <=> ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
              = fo__c_2Ebinary__ieee_2ELT ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__less__equal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1y: $i] :
          ( ( mem @ V1y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( p @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__less__equal @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
          <=> ( p @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ bool ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ V0x ) @ V1y ) ) @ c_2Ebool_2ET ) @ c_2Ebool_2ET ) @ c_2Ebool_2EF ) @ c_2Ebool_2EF ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__greater__than__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1y: $i] :
          ( ( mem @ V1y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( p @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__greater__than @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
          <=> ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
              = fo__c_2Ebinary__ieee_2EGT ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__greater__equal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1y: $i] :
          ( ( mem @ V1y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( p @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__greater__equal @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
          <=> ( p @ ( ap @ ( ap @ ( ap @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare__CASE @ bool ) @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ V0x ) @ V1y ) ) @ c_2Ebool_2EF ) @ c_2Ebool_2ET ) @ c_2Ebool_2ET ) @ c_2Ebool_2EF ) ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Efloat__equal__def,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1y: $i] :
          ( ( mem @ V1y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( p @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__equal @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
          <=> ( ( surj__ty_2Ebinary__ieee_2Efloat__compare @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Efloat__compare @ A_27t @ A_27w ) @ V0x ) @ V1y ) )
              = fo__c_2Ebinary__ieee_2EEQ ) ) ) ) ).

thf(ax_thm_2Ebinary__ieee_2Eexponent__boundary__def,axiom,
    ! [A_27t: del,A_27w: del,V0y: $i] :
      ( ( mem @ V0y @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ! [V1x: $i] :
          ( ( mem @ V1x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
         => ( ( p @ ( ap @ ( ap @ ( c_2Ebinary__ieee_2Eexponent__boundary @ A_27t @ A_27w ) @ V0y ) @ V1x ) )
          <=> ( ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V1x ) )
                = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ V0y ) ) )
              & ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Ewords_2Ew2n @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V1x ) ) )
                = ( surj__ty_2Enum_2Enum @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( c_2Ewords_2Ew2n @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V0y ) ) ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
              & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ V1x )
               != ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
              & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V0y )
                = ( ap @ ( c_2Ewords_2Eword__2comp @ A_27t ) @ ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
              & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ V1x )
                = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ezero__lt__twopow,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ezero__le__twopow,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ezero__neq__twopow,axiom,
    ! [V0n: tp__ty_2Enum_2Enum] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0n ) ) )
     != ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ezero__le__pos__div__twopow,axiom,
    ! [V0m: tp__ty_2Enum_2Enum,V1n: tp__ty_2Enum_2Enum] : ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ V0m ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V1n ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ediv__eq0,axiom,
    ! [V0a: tp__ty_2Erealax_2Ereal,V1b: tp__ty_2Erealax_2Ereal] :
      ( ( p @ ( ap @ ( ap @ c_2Erealax_2Ereal__lt @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1b ) ) )
     => ( ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( inj__ty_2Erealax_2Ereal @ V0a ) ) @ ( inj__ty_2Erealax_2Ereal @ V1b ) ) )
          = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      <=> ( V0a
          = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eexp__ge2,axiom,
    ! [V0b: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2EEXP @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0b ) ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Earithmetic_2E_3C_3D @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0b ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eexp__gt2,axiom,
    ! [V0b: tp__ty_2Enum_2Enum] :
      ( ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2EEXP @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0b ) ) ) )
    <=> ( p @ ( ap @ ( ap @ c_2Eprim__rec_2E_3C @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) @ ( inj__ty_2Enum_2Enum @ V0b ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ele2,axiom,
    ! [V0n: tp__ty_2Erealax_2Ereal,V1m: tp__ty_2Erealax_2Ereal] :
      ( ( ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V0n ) ) )
        & ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( inj__ty_2Erealax_2Ereal @ V1m ) ) ) )
     => ( p @ ( ap @ ( ap @ c_2Ereal_2Ereal__lte @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Erealax_2Ereal__mul @ ( inj__ty_2Erealax_2Ereal @ V0n ) ) @ ( inj__ty_2Erealax_2Ereal @ V1m ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__components,axiom,
    ! [A_27a: del,A_27b: del,A_27c: del,A_27d: del,A_27e: del,A_27f: del,A_27g: del,A_27h: del,A_27i: del,A_27j: del,A_27t: del,A_27w: del] :
      ( ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27w ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27w ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( c_2Ewords_2En2w @ A_27t ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( ap @ ( c_2Ewords_2Eword__sub @ A_27w ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27t ) )
      & ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2En2w @ ty_2Eone_2Eone ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( ap @ ( ap @ ( c_2Ewords_2Eword__sub @ A_27w ) @ ( c_2Ewords_2Eword__T @ A_27w ) ) @ ( ap @ ( c_2Ewords_2En2w @ A_27w ) @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
        = ( c_2Ewords_2Eword__T @ A_27t ) )
      & ! [V0fp__op: $i] :
          ( ( mem @ V0fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27a @ A_27b ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) )
            = ( c_2Ewords_2Eword__T @ A_27b ) ) )
      & ! [V1fp__op: $i] :
          ( ( mem @ V1fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27c @ A_27d ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27c @ A_27d ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27c @ A_27d ) @ V1fp__op ) )
           != ( ap @ ( c_2Ewords_2En2w @ A_27c ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      & ! [V2x: $i] :
          ( ( mem @ V2x @ ( ty_2Ebinary__ieee_2Efloat @ A_27e @ A_27f ) )
         => ( ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27e @ A_27f ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27e @ A_27f ) @ V2x ) ) )
            = ( surj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ ( ap @ ( c_2Ewords_2Eword__1comp @ ty_2Eone_2Eone ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__Sign @ A_27e @ A_27f ) @ V2x ) ) ) ) )
      & ! [V3x: $i] :
          ( ( mem @ V3x @ ( ty_2Ebinary__ieee_2Efloat @ A_27g @ A_27h ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27g @ A_27h ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27g @ A_27h ) @ V3x ) )
            = ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27g @ A_27h ) @ V3x ) ) )
      & ! [V4x: $i] :
          ( ( mem @ V4x @ ( ty_2Ebinary__ieee_2Efloat @ A_27i @ A_27j ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27i @ A_27j ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27i @ A_27j ) @ V4x ) )
            = ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27i @ A_27j ) @ V4x ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__distinct,axiom,
    ! [A_27a: del,A_27b: del,A_27t: del,A_27w: del] :
      ( ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V0fp__op: $i] :
          ( ( mem @ V0fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V0fp__op ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V1fp__op: $i] :
          ( ( mem @ V1fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V1fp__op ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V2fp__op: $i] :
          ( ( mem @ V2fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V2fp__op ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V3fp__op: $i] :
          ( ( mem @ V3fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V3fp__op ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V4fp__op: $i] :
          ( ( mem @ V4fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V4fp__op ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V5fp__op: $i] :
          ( ( mem @ V5fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V5fp__op ) ) )
      & ! [V6fp__op: $i] :
          ( ( mem @ V6fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V6fp__op ) ) )
      & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
       != ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      & ! [V7fp__op: $i] :
          ( ( mem @ V7fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27t @ A_27w ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) )
           != ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27t @ A_27w ) @ V7fp__op ) ) )
      & ! [V8x: $i] :
          ( ( mem @ V8x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
         => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b ) @ V8x )
           != V8x ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__values,axiom,
    ! [A_27a: del,A_27b: del,A_27t: del,A_27w: del] :
      ( ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = fo__c_2Ebinary__ieee_2EInfinity )
      & ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = fo__c_2Ebinary__ieee_2EInfinity )
      & ! [V0fp__op: $i] :
          ( ( mem @ V0fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27a @ A_27b ) )
         => ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
            = fo__c_2Ebinary__ieee_2ENaN ) )
      & ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
      & ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) )
      & ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) )
      & ( ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ ( c_2Ebinary__ieee_2Efloat__value @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__ty_2Ebinary__ieee_2Efloat__value @ ( ap @ c_2Ebinary__ieee_2EFloat @ ( ap @ ( ap @ c_2Ereal_2E_2F @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT2 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) @ ( ap @ ( ap @ c_2Earithmetic_2E_2B @ ( ap @ ( c_2Ewords_2EINT__MAX @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) ) @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ezero__to__real,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) )
      & ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
        = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Esign__not__zero,axiom,
    ! [V0s: tp__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( ap @ c_2Ereal_2Epow @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ c_2Ereal_2Ereal__of__num @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) @ ( ap @ ( c_2Ewords_2Ew2n @ ty_2Eone_2Eone ) @ ( inj__c_ty_2Efcp_2Ecart_o_ty_2Eone_2Eone @ V0s ) ) ) )
     != ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Ereal_2Ereal__of__num @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__sets,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w )
        = ( ap @ ( ap @ ( c_2Epred__set_2EINSERT @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( ap @ ( c_2Epred__set_2EINSERT @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( c_2Epred__set_2EEMPTY @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) )
      & ( ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w )
        = ( ap @ ( ap @ ( c_2Epred__set_2EINSERT @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( ap @ ( ap @ ( c_2Epred__set_2EINSERT @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) @ ( c_2Epred__set_2EEMPTY @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Einfinity__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ezero__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__zero @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Esome__nan__properties,axiom,
    ! [A_27a: del,A_27b: del,V0fp__op: $i] :
      ( ( mem @ V0fp__op @ ( ty_2Ebinary__ieee_2Efp__op @ A_27a @ A_27b ) )
     => ( ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__signalling @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) )
        & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__some__qnan @ A_27a @ A_27b ) @ V0fp__op ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Emin__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      <=> ( ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) )
            = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
          & ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) )
            = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__integral @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      <=> ( ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) )
            = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) )
          & ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27t ) @ ( c_2Ebool_2Ethe__value @ A_27t ) ) )
            = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Etop__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) )
         != ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) )
          = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__top @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Ebottom__properties,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      & ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) )
         != ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      <=> ( ( surj__ty_2Enum_2Enum @ ( ap @ ( c_2Efcp_2Edimindex @ A_27w ) @ ( c_2Ebool_2Ethe__value @ A_27w ) ) )
          = ( surj__ty_2Enum_2Enum @ ( ap @ c_2Earithmetic_2ENUMERAL @ ( ap @ c_2Earithmetic_2EBIT1 @ ( inj__ty_2Enum_2Enum @ fo__c_2Earithmetic_2EZERO ) ) ) ) ) )
      & ~ ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__bottom @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__is__zero,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) )
      <=> ( ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Exponent @ A_27a @ A_27b ) @ V0x )
            = ( ap @ ( c_2Ewords_2En2w @ A_27b ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) )
          & ( ( ap @ ( c_2Ebinary__ieee_2Efloat__Significand @ A_27a @ A_27b ) @ V0x )
            = ( ap @ ( c_2Ewords_2En2w @ A_27a ) @ ( inj__ty_2Enum_2Enum @ fo__c_2Enum_2E0 ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__is__finite,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b ) @ V0x ) )
      <=> ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ V0x ) )
          | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ V0x ) )
          | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__cases__finite,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
        | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) )
        | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b ) @ V0x ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__distinct__finite,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__finite @ A_27a @ A_27b ) @ V0x ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__cases,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
        | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) )
        | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ V0x ) )
        | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ V0x ) )
        | ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__is__distinct,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__nan @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__normal @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) ) )
        & ~ ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__subnormal @ A_27a @ A_27b ) @ V0x ) )
            & ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__zero @ A_27a @ A_27b ) @ V0x ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__infinities,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ( ( p @ ( ap @ ( c_2Ebinary__ieee_2Efloat__is__infinite @ A_27t @ A_27w ) @ V0x ) )
      <=> ( ( V0x
            = ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
          | ( V0x
            = ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__infinities__distinct,axiom,
    ! [A_27t: del,A_27w: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27t @ A_27w ) )
     => ~ ( ( V0x
            = ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
          & ( V0x
            = ( ap @ ( c_2Ebinary__ieee_2Efloat__minus__infinity @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__to__real__negate,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b ) @ V0x ) ) )
        = ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27a @ A_27b ) @ V0x ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Efloat__negate__negate,axiom,
    ! [A_27a: del,A_27b: del,V0x: $i] :
      ( ( mem @ V0x @ ( ty_2Ebinary__ieee_2Efloat @ A_27a @ A_27b ) )
     => ( ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27a @ A_27b ) @ V0x ) )
        = V0x ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eulp,axiom,
    ! [A_27t: del,A_27w: del] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) )
      = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ).

thf(conj_thm_2Ebinary__ieee_2Eneg__ulp,conjecture,
    ! [A_27t: del,A_27w: del] :
      ( ( surj__ty_2Erealax_2Ereal @ ( ap @ c_2Erealax_2Ereal__neg @ ( ap @ ( c_2Ebinary__ieee_2Eulp @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) )
      = ( surj__ty_2Erealax_2Ereal @ ( ap @ ( c_2Ebinary__ieee_2Efloat__to__real @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__negate @ A_27t @ A_27w ) @ ( ap @ ( c_2Ebinary__ieee_2Efloat__plus__min @ A_27t @ A_27w ) @ ( c_2Ebool_2Ethe__value @ ( ty_2Epair_2Eprod @ A_27t @ A_27w ) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
